/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cbord.dx;

import biz.papercut.pcng.domain.Printer;
import biz.papercut.pcng.domain.PrinterGroup;
import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.ConfigurationException;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.BalanceResponse;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.CBORDDXCardLookup;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.CBORDDXConnectionConfig;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.CBORDDXConnectionManager;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.DebitResponse;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.RequestMessage;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.tuple.Pair;
import com.papercut.server.lang.service.ApplicationLogLevelEnum;
import com.papercut.server.lang.service.ServiceException;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CBORDDXPlugin
implements EnableablePlugin,
SpringContextPlugin,
UserLinkPlugin {
    private static final Logger logger = LoggerFactory.getLogger(CBORDDXPlugin.class);
    private static final String PRINTER_GROUP_PREFIX = "CBORDDX-";
    private static final String PRINTER_GROUP_LOCATION = "CBORDDX-Location:";
    private static final String PRINTER_GROUP_CODE_MAP = "CBORDDX-CodeMap:";
    private static final String PAYMENT_GATEWAY_PAGE_NAME = "ExtnCBORDDX";
    private static final double ROUNDING_TOLERANCE = 1.0E-5;
    private static final String TRANSACTION_SOURCE_NAME = "CBORD";
    private static final String CONFIG_PREFIX = "cbord-dx.";
    private static final String CONFIG_ENABLED = "cbord-dx.enabled";
    private static final String CONFIG_BALANCE_DISPLAY_PREFIX = "cbord-dx.balance-display.";
    private static final String CONFIG_BALANCE_DISPLAY_ENABLED = "cbord-dx.balance-display.enabled";
    private static final String CONFIG_BALANCE_DISPLAY_LABEL = "cbord-dx.balance-display.label";
    private static final String CONFIG_BALANCE_DISPLAY_AVAILABLE_CREDIT_PREFIX = "cbord-dx.balance-display.available-credit.";
    private static final String CONFIG_BALANCE_DISPLAY_AVAILABLE_CREDIT_LABEL = "cbord-dx.balance-display.available-credit.label";
    private static final String CONFIG_SERVER_PREFIX = "cbord-dx.server.";
    private static final String CONFIG_SERVER_TYPE = "cbord-dx.server.type";
    private static final String CONFIG_SERVER_HOST = "cbord-dx.server.host";
    private static final String CONFIG_SERVER_PORT = "cbord-dx.server.port";
    private static final String CONFIG_SERVER_SSL = "cbord-dx.server.ssl";
    private static final String CONFIG_SERVER_SSL_PROTOCOLS = "cbord-dx.server.ssl-protocols";
    private static final String CONFIG_SERVER_SSL_CIPHERS = "cbord-dx.server.ssl-ciphers";
    private static final String CONFIG_SERVER_CONNECT_TIMEOUT = "cbord-dx.server.connect-timeout";
    private static final String CONFIG_SERVER_READ_TIMEOUT = "cbord-dx.server.read-timeout";
    private static final String CONFIG_SERVER_RECEIVE_TIMEOUT = "cbord-dx.server.receive-timeout";
    private static final String CONFIG_PROVIDER = "cbord-dx.provider";
    private static final String CONFIG_CURRENCY = "cbord-dx.currency";
    private static final String CONFIG_DEFAULT_LOCATION = "cbord-dx.location";
    private static final String CONFIG_DEFAULT_CODE_MAP = "cbord-dx.code-map";
    private static final String CONFIG_SENDING_CARD_NUMBERS = "cbord-dx.sending-card-numbers";
    private static final String CONFIG_CARD_ID_IS_VISIBLE = "cbord-dx.card-id-is-visible";
    private static final String CONFIG_OPERATOR = "cbord-dx.operator";
    private static final String CONFIG_NO_ID_DEFINED_MESSAGE = "cbord-dx.no-id-defined";
    private static final String CONFIG_MANUAL_PREFIX = "cbord-dx.manual-transfer.";
    private static final String CONFIG_MANUAL_TRANSFER_ENABLED = "cbord-dx.manual-transfer.enabled";
    private static final String CONFIG_MANUAL_TRANSFER_PAGE_TITLE = "cbord-dx.manual-transfer.page.title";
    private static final String CONFIG_MANUAL_TRANSFER_PAGE_HEADING = "cbord-dx.manual-transfer.page.heading";
    private static final String CONFIG_MANUAL_TRANSFER_TRANSACTION_COMMENT = "cbord-dx.manual-transfer.transaction-comment";
    protected static final String CONFIG_MANUAL_TRANSFER_ALLOWED_AMOUNTS = "cbord-dx.manual-transfer.allowed-amounts";
    private static final String CONFIG_MANUAL_TRANSFER_ALLOWED_GROUPS = "cbord-dx.manual-transfer.allowed-groups";
    private static final String CONFIG_MANUAL_TRANSFER_USER_ERROR_MESSAGE = "cbord-dx.manual-transfer.user-error-message";
    private static final String CONFIG_ON_DEMAND_PREFIX = "cbord-dx.on-demand-transfer.";
    private static final String CONFIG_ON_DEMAND_TRANSFER_ENABLED = "cbord-dx.on-demand-transfer.enabled";
    private static final String CONFIG_ON_DEMAND_TRANSFER_DEFAULT_TRANSFER_AMOUNT = "cbord-dx.on-demand-transfer.default-transfer-amount";
    private static final String CONFIG_ON_DEMAND_TRANSFER_MAX_TRANSFER_AMOUNT = "cbord-dx.on-demand-transfer.max-transfer-amount";
    private static final String CONFIG_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT = "cbord-dx.on-demand-transfer.transaction-comment";
    private static final String CONFIG_ON_DEMAND_TRANSFER_ENABLED_GROUPS = "cbord-dx.on-demand-transfer.enabled-groups";
    private static final String DEFAULT_PAPERCUT_PROVIDER = "PaperCut";
    private static final String DEFAULT_MANUAL_TRANSFER_TRANSACTION_COMMENT = "Funds added from CBORD";
    private static final String DEFAULT_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT = "Automatic transfer from CBORD";
    private static final int DEFAULT_SERVER_CONNECT_TIMEOUT = 3000;
    private static final int DEFAULT_SERVER_READ_TIMEOUT = 2000;
    private static final int DEFAULT_SERVER_RECEIVE_TIMEOUT = 4000;
    @AESProperty
    private static final String NOT_USE_CONFIG_CARD_ID_LOOKUP_DB_PASSWORD = "cbord-dx.card-id-lookup.db-password";
    @Nullable
    private final CBORDDXCardLookup _cardLookup = new CBORDDXCardLookup(this);
    @Nullable
    private volatile CBORDDXConnectionManager _connectionManager;
    @Nullable
    private volatile ApplicationContext _ctx;

    @CheckForNull
    public String getIsConfigured() {
        CBORDDXConnectionConfig connectionConfig;
        String errorPrefix = "Configuration problem: ";
        String errorSuffix = "  Please check the payment gateway config file.";
        try {
            connectionConfig = CBORDDXPlugin.getConnectionConfig();
        }
        catch (Exception e) {
            return errorPrefix + e.getMessage() + errorSuffix;
        }
        if (connectionConfig.getServerType() == ServerType.Odyssey && CBORDDXPlugin.getOperator() == null) {
            String errorMsg = "'operator' field is required when connecting to an Odyssey server.";
            EventLog.getInstance().logEvent(errorMsg);
            return errorPrefix + errorMsg + errorSuffix;
        }
        try {
            this.getManualTransferAllowedAmounts();
        }
        catch (Exception e) {
            String errorMsg = "Allowed amounts setting uses the wrong format.";
            EventLog.getInstance().logEvent(errorMsg);
            return errorPrefix + errorMsg + errorSuffix;
        }
        if (this.getManualTransferAllowedAmounts().isEmpty()) {
            String errorMsg = "Must specify at least one allowed payment amount.";
            EventLog.getInstance().logEvent(errorMsg);
            return errorPrefix + errorMsg + errorSuffix;
        }
        if (this.isOnDemandTransferEnabled()) {
            if (this.getOnDemandTransferDefaultTransferAmount() == null) {
                String errorMsg = "If on-demand transfers is enabled a default transfer amount must be specified.";
                EventLog.getInstance().logEvent(errorMsg);
                return errorPrefix + errorMsg + errorSuffix;
            }
            if (this.getOnDemandTransferMaxTransferAmount() == null) {
                String errorMsg = "If on-demand transfers is enabled a max transfer amount must be specified.";
                EventLog.getInstance().logEvent(errorMsg);
                return errorPrefix + errorMsg + errorSuffix;
            }
        }
        try {
            this._cardLookup.checkConfiguration();
        }
        catch (ConfigurationException ce) {
            logger.error(ce.getMessage());
            EventLog.getInstance().logEvent(ce.getMessage());
            return ce.getMessage();
        }
        return null;
    }

    public BalanceResponse getBalance(User user, @Nullable String location, @Nullable String codeMap) {
        Pair<String, String> idAndCard = this.getIdAndCard(this.getCardLookup().getCBORDCardNumber(user));
        return this.getBalance((String)idAndCard.get0(), (String)idAndCard.get1(), location, codeMap);
    }

    protected BalanceResponse getBalance(@Nullable String cbordId, @Nullable String cbordCardNumber, @Nullable String location, @Nullable String codeMap) {
        BalanceResponse response;
        RequestMessage.CardOrIdType cardOrIdType;
        String cardOrId;
        if (StringUtils.isBlank((String)cbordId)) {
            cardOrId = cbordCardNumber;
            cardOrIdType = RequestMessage.CardOrIdType.Card;
        } else {
            cardOrId = cbordId;
            cardOrIdType = RequestMessage.CardOrIdType.Id;
        }
        String locationOut = StringUtils.isBlank((String)location) ? CBORDDXPlugin.getDefaultLocation() : location;
        String codeMapOut = StringUtils.isBlank((String)codeMap) ? CBORDDXPlugin.getDefaultCodeMap() : codeMap;
        String msg = "Attempting balance inquiry for id: " + cbordId + ", card: " + this.visibleCardId(cbordCardNumber) + ", location: " + locationOut + ", code map: " + codeMapOut;
        logger.debug(msg);
        CBORDDXPlugin.getEventLog().logEvent(msg);
        try {
            response = this.getConnectionManager().getBalance(cardOrId, cardOrIdType, locationOut, codeMapOut);
        }
        catch (ConfigurationException ce) {
            return new BalanceResponse(false, "CONFIG_ERROR", ce.getMessage(), null, null, 0.0, 0.0);
        }
        String msg2 = "Balance inquiry for id " + cbordId + ", card " + this.visibleCardId(cbordCardNumber) + ": " + String.valueOf(response);
        if (response.isSuccess()) {
            logger.debug(msg2);
        } else {
            logger.error(msg2);
        }
        CBORDDXPlugin.getEventLog().logEvent(msg2);
        return response;
    }

    public DebitResponse performDebit(User user, double amount, @Nullable String location, @Nullable String codeMap) {
        Pair<String, String> idAndCard = this.getIdAndCard(this.getCardLookup().getCBORDCardNumber(user));
        return this.performDebit((String)idAndCard.get0(), (String)idAndCard.get1(), amount, location, codeMap);
    }

    protected DebitResponse performDebit(@Nullable String cbordId, @Nullable String cbordCardNumber, double amount, @Nullable String location, @Nullable String codeMap) {
        DebitResponse response;
        RequestMessage.CardOrIdType cardOrIdType;
        String cardOrId;
        if (StringUtils.isBlank((String)cbordId)) {
            cardOrId = cbordCardNumber;
            cardOrIdType = RequestMessage.CardOrIdType.Card;
        } else {
            cardOrId = cbordId;
            cardOrIdType = RequestMessage.CardOrIdType.Id;
        }
        int amountCents = CBORDDXPlugin.roundDoubleDollarsToCents(amount);
        String locationOut = StringUtils.isBlank((String)location) ? CBORDDXPlugin.getDefaultLocation() : location;
        String codeMapOut = StringUtils.isBlank((String)codeMap) ? CBORDDXPlugin.getDefaultCodeMap() : codeMap;
        String orderId = this.getNextOrderId();
        String msg = "Attempting debit transaction for id: " + cbordId + ", card: " + this.visibleCardId(cbordCardNumber) + ", amount: " + amountCents + "c, location: " + locationOut + ", code map: " + codeMapOut;
        logger.debug(msg);
        CBORDDXPlugin.getEventLog().logEvent(msg);
        try {
            response = this.getConnectionManager().performDebit(cardOrId, cardOrIdType, locationOut, codeMapOut, amountCents, orderId);
        }
        catch (ConfigurationException ce) {
            return new DebitResponse(false, "CONFIG_ERROR", ce.getMessage(), null, null, null, 0.0);
        }
        String msg2 = "Transaction for id " + cbordId + ", card " + this.visibleCardId(cbordCardNumber) + ": " + String.valueOf(response);
        if (response.isSuccess()) {
            logger.debug(msg2);
        } else {
            logger.error(msg2);
            if (StringUtils.equals((String)response.getStatusMessage(), (String)"DOUBLE POST")) {
                this.getAppLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, "CBOARD Payment Gateway reported DOUBLE POST on debit transaction.  Possible duplicate debit has occurred.  CBOARD ID: " + cbordId + " Card: " + this.visibleCardId(cbordCardNumber) + ", amount: " + amountCents);
            }
        }
        CBORDDXPlugin.getEventLog().logEvent(msg2);
        if (response.isSuccess()) {
            String idOrCard = cbordId == null ? this.visibleCardId(cbordCardNumber) : cbordId;
            CBORDDXPlugin.getEventLog().logTransaction(idOrCard, orderId, amount, TRANSACTION_SOURCE_NAME, locationOut, codeMapOut);
        }
        return response;
    }

    public boolean isBalanceDisplayEnabled() {
        return BooleanUtils.isTrue((Boolean)CBORDDXPlugin.getGatewayConfig().getBoolean(CONFIG_BALANCE_DISPLAY_ENABLED));
    }

    public String getBalanceDisplayLabel() {
        return StringUtils.trimToEmpty((String)CBORDDXPlugin.getGatewayConfig().getString(CONFIG_BALANCE_DISPLAY_LABEL));
    }

    public String getBalanceDisplayAvailableCreditLabel() {
        return StringUtils.trimToEmpty((String)CBORDDXPlugin.getGatewayConfig().getString(CONFIG_BALANCE_DISPLAY_AVAILABLE_CREDIT_LABEL));
    }

    private static CBORDDXConnectionConfig getConnectionConfig() throws Exception {
        Integer serverPort;
        ServerType serverType;
        GatewayConfig gc = CBORDDXPlugin.getGatewayConfig();
        String serverTypeString = StringUtils.upperCase((String)StringUtils.trimToNull((String)gc.getString(CONFIG_SERVER_TYPE)));
        try {
            serverType = ServerType.valueOfCode(serverTypeString);
        }
        catch (IllegalArgumentException iae) {
            throw new Exception("Invalid CBORD server type (cbord-dx.server.type)");
        }
        String serverHost = StringUtils.trimToNull((String)gc.getString(CONFIG_SERVER_HOST));
        try {
            serverPort = gc.getInteger(CONFIG_SERVER_PORT);
        }
        catch (Exception e) {
            throw new Exception("CBORD server port is required and must be a port number (cbord-dx.server.port)");
        }
        boolean ssl = BooleanUtils.isTrue((Boolean)gc.getBoolean(CONFIG_SERVER_SSL));
        List<String> ciphers = gc.getStringList(CONFIG_SERVER_SSL_CIPHERS);
        List<String> protocols = gc.getStringList(CONFIG_SERVER_SSL_PROTOCOLS);
        int socketConnectTimeoutMS = NumberUtils.toInt((String)gc.getString(CONFIG_SERVER_CONNECT_TIMEOUT), (int)3000);
        int socketReadTimeoutMS = NumberUtils.toInt((String)gc.getString(CONFIG_SERVER_READ_TIMEOUT), (int)2000);
        int messageReceiveTimeoutMS = NumberUtils.toInt((String)gc.getString(CONFIG_SERVER_RECEIVE_TIMEOUT), (int)4000);
        return new CBORDDXConnectionConfig(serverType, serverHost, serverPort, ssl, protocols, ciphers, socketConnectTimeoutMS, socketReadTimeoutMS, messageReceiveTimeoutMS);
    }

    private static String getProvider() {
        try {
            String provider = CBORDDXPlugin.getGatewayConfig().getString(CONFIG_PROVIDER);
            if (provider != null) {
                return provider;
            }
        }
        catch (Exception e) {
            logger.error("Invalid provider name.", (Throwable)e);
        }
        return DEFAULT_PAPERCUT_PROVIDER;
    }

    @CheckForNull
    private static String getCurrency() {
        return StringUtils.trimToNull((String)CBORDDXPlugin.getGatewayConfig().getString(CONFIG_CURRENCY));
    }

    @Nullable
    protected static String getDefaultLocation() {
        return StringUtils.trimToNull((String)CBORDDXPlugin.getGatewayConfig().getString(CONFIG_DEFAULT_LOCATION));
    }

    @Nullable
    protected static String getDefaultCodeMap() {
        return StringUtils.trimToNull((String)CBORDDXPlugin.getGatewayConfig().getString(CONFIG_DEFAULT_CODE_MAP));
    }

    @CheckForNull
    protected static String getOperator() {
        return StringUtils.trimToNull((String)CBORDDXPlugin.getGatewayConfig().getString(CONFIG_OPERATOR));
    }

    private boolean isSendingCardNumbers() {
        return BooleanUtils.isTrue((Boolean)CBORDDXPlugin.getGatewayConfig().getBoolean(CONFIG_SENDING_CARD_NUMBERS));
    }

    public boolean isManualTransferEnabled() {
        return BooleanUtils.isTrue((Boolean)CBORDDXPlugin.getGatewayConfig().getBoolean(CONFIG_MANUAL_TRANSFER_ENABLED));
    }

    @CheckForNull
    public String getManualTransferPageTitle() {
        return CBORDDXPlugin.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFER_PAGE_TITLE);
    }

    public String getManualTransferPageHeading() {
        return StringUtils.trimToEmpty((String)CBORDDXPlugin.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFER_PAGE_HEADING));
    }

    public String getManualTransferTransactionComment() {
        Object txnComment = StringUtils.trimToNull((String)CBORDDXPlugin.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFER_TRANSACTION_COMMENT));
        if (txnComment == null) {
            txnComment = DEFAULT_MANUAL_TRANSFER_TRANSACTION_COMMENT;
        }
        if (!this.isLicensed()) {
            txnComment = (String)txnComment + " (" + GatewayUtils.getNotLicensedUserMessage() + ")";
        }
        return txnComment;
    }

    public List<Double> getManualTransferAllowedAmounts() {
        return CBORDDXPlugin.getGatewayConfig().getDoubleList(CONFIG_MANUAL_TRANSFER_ALLOWED_AMOUNTS);
    }

    public boolean isManualTransferAccessibleByUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        return GatewayUtils.isAccessibleByUser(username, CONFIG_MANUAL_TRANSFER_ALLOWED_GROUPS, this.getUserManager());
    }

    public String getManualTransferUserErrorMessage() {
        String userError = StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_MANUAL_TRANSFER_USER_ERROR_MESSAGE));
        if (userError == null) {
            userError = "An error has occurred, please try again. If you continue to receive this error please contact a network administrator for assistance.";
        }
        return userError;
    }

    public String getNoIdDefinedMessage() {
        String noIdError = StringUtils.trimToEmpty((String)GatewayConfig.getInstance().getString(CONFIG_NO_ID_DEFINED_MESSAGE));
        if (noIdError == null) {
            noIdError = "This service is currently not available as your login is not yet associated with a CBORD account. Please contact a network administrator for assistance. (Reason: no card/id defined.)";
        }
        return noIdError;
    }

    public String visibleCardId(String cardId) {
        return GatewayConfig.getInstance().maskIfConfigExistsAndFalse(cardId, CONFIG_CARD_ID_IS_VISIBLE);
    }

    public boolean isOnDemandTransferEnabled() {
        return BooleanUtils.isTrue((Boolean)CBORDDXPlugin.getGatewayConfig().getBoolean(CONFIG_ON_DEMAND_TRANSFER_ENABLED));
    }

    @Nullable
    public Double getOnDemandTransferDefaultTransferAmount() {
        Double amount = null;
        try {
            amount = CBORDDXPlugin.getGatewayConfig().getDouble(CONFIG_ON_DEMAND_TRANSFER_DEFAULT_TRANSFER_AMOUNT);
        }
        catch (Exception e) {
            logger.error("Invalid on-demand transfer default transfer amount.", (Throwable)e);
        }
        return amount;
    }

    @Nullable
    public Double getOnDemandTransferMaxTransferAmount() {
        Double amount = null;
        try {
            amount = CBORDDXPlugin.getGatewayConfig().getDouble(CONFIG_ON_DEMAND_TRANSFER_MAX_TRANSFER_AMOUNT);
        }
        catch (Exception e) {
            logger.error("Invalid on-demand transfer max transfer amount.", (Throwable)e);
        }
        return amount;
    }

    public String getOnDemandTransferTransactionComment() {
        Object txnComment = StringUtils.trimToNull((String)CBORDDXPlugin.getGatewayConfig().getString(CONFIG_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT));
        if (txnComment == null) {
            txnComment = DEFAULT_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT;
        }
        if (!this.isLicensed()) {
            txnComment = (String)txnComment + " (" + GatewayUtils.getNotLicensedUserMessage() + ")";
        }
        return txnComment;
    }

    public boolean isOnDemandTransferEnabledForUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        if (!this.isOnDemandTransferEnabled()) {
            return false;
        }
        return GatewayUtils.isAccessibleByUser(username, CONFIG_ON_DEMAND_TRANSFER_ENABLED_GROUPS, this.getUserManager());
    }

    private String getNextOrderId() {
        return String.valueOf(CreditCardGatewayPlugin.getUniqueOrderID());
    }

    protected static int roundDoubleDollarsToCents(double dollars) {
        double dollarsToRound = dollars - 1.0E-5;
        return (int)Math.ceil(dollarsToRound * 100.0);
    }

    private Pair<String, String> getIdAndCard(@Nullable String idOrCard) {
        if (this.isSendingCardNumbers()) {
            return Pair.from(null, (Object)idOrCard);
        }
        return Pair.from((Object)idOrCard, null);
    }

    public boolean isLicensed() {
        return GatewayUtils.isLicensed(this.getLicenceManager(), "payment-gateways-cbord");
    }

    public boolean isPluginEnabled() {
        Boolean enabled = GatewayConfig.getInstance().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isManualTransferEnabled() && this.isManualTransferAccessibleByUser(username)) {
            return List.of(PAYMENT_GATEWAY_PAGE_NAME);
        }
        return null;
    }

    @CheckForNull
    public String getPageTitle() {
        return this.getManualTransferPageTitle();
    }

    public synchronized ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
        this.getCardLookup().setApplicationContext(ctx);
    }

    private ApplicationLogManager getAppLogManager() {
        return (ApplicationLogManager)this.getApplicationContext().getBean("applicationLogManager", ApplicationLogManager.class);
    }

    @CheckForNull
    protected static String getPrinterLocationOverride(Printer printer) {
        return CBORDDXPlugin.lookUpPrinterGroupValue(printer, PRINTER_GROUP_LOCATION);
    }

    @CheckForNull
    protected static String getPrinterCodeMapOverride(Printer printer) {
        return CBORDDXPlugin.lookUpPrinterGroupValue(printer, PRINTER_GROUP_CODE_MAP);
    }

    @CheckForNull
    private static String lookUpPrinterGroupValue(Printer printer, String printerGroupName) {
        Set printerGroups = printer.getPrinterGroups();
        for (PrinterGroup pg : printerGroups) {
            String name = pg.getDisplayName();
            if (!name.startsWith(printerGroupName)) continue;
            return name.substring(printerGroupName.length());
        }
        return null;
    }

    private CBORDDXCardLookup getCardLookup() {
        if (this._cardLookup == null) {
            throw new ServiceException("CBORD DX payment gateway not fully configured");
        }
        return this._cardLookup;
    }

    private synchronized CBORDDXConnectionManager getConnectionManager() throws ConfigurationException {
        if (this._connectionManager == null) {
            String configError = this.getIsConfigured();
            if (configError != null) {
                logger.error(configError);
                throw new ConfigurationException(configError);
            }
            try {
                this._connectionManager = new CBORDDXConnectionManager(CBORDDXPlugin.getConnectionConfig(), CBORDDXPlugin.getProvider(), CBORDDXPlugin.getCurrency(), CBORDDXPlugin.getOperator());
            }
            catch (Exception e) {
                String errorMsg = "CBORD plugin not fully configured: " + e.getMessage();
                logger.error(errorMsg, (Throwable)e);
                throw new ConfigurationException(errorMsg);
            }
        }
        return this._connectionManager;
    }

    private static EventLog getEventLog() {
        return EventLog.getInstance();
    }

    private static GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    private LicenseManager getLicenceManager() {
        return (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    protected static enum ServerType {
        CSGold("CSGOLD"),
        Odyssey("ODYSSEY");

        private final String _code;

        private ServerType(String code) {
            this._code = code;
        }

        public static ServerType valueOfCode(String code) {
            for (ServerType st : ServerType.values()) {
                if (!st._code.equals(code)) continue;
                return st;
            }
            throw new IllegalArgumentException("Invalid server type: " + code);
        }
    }
}

