/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cbord.dx;

import biz.papercut.pcng.domain.Printer;
import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.BalanceResponse;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.CBORDDXPlugin;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.DebitResponse;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin3;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin4;
import biz.papercut.pcng.service.PrinterManager;
import biz.papercut.pcng.service.UserManager;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CBORDDXTopupAccountOnDemandPlugin
implements TopupAccountOnDemandPlugin4,
SpringContextPlugin {
    private static final Logger logger = LoggerFactory.getLogger(CBORDDXTopupAccountOnDemandPlugin.class);
    @Nullable
    @GuardedBy(value="this")
    private ApplicationContext _ctx;

    public Map<String, Double> getBalance(Map<String, String> userDetails) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        CBORDDXPlugin cp = CBORDDXTopupAccountOnDemandPlugin.getCBORDDXPlugin();
        if (!cp.isBalanceDisplayEnabled()) {
            logger.debug("CBORD balance display disabled.");
            return null;
        }
        String username = userDetails.get("username");
        User user = this.getUserManager().getUser(username);
        if (user == null) {
            logger.error("Unknown user: {}", (Object)username);
            return null;
        }
        if (!cp.isOnDemandTransferEnabledForUser(username)) {
            logger.debug("CBORD top-up on demand plugin not enabled for user '{}'.", (Object)username);
            return null;
        }
        BalanceResponse br = cp.getBalance(user, null, null);
        if (!br.isSuccess()) {
            if (logger.isDebugEnabled()) {
                logger.error("Unable to retrieve CBORD balance for user \"{}\": {} {}", new Object[]{username, br.getStatusMessage(), br});
            } else {
                logger.error("Unable to retrieve CBORD balance for user \"{}\": {}", (Object)username, (Object)br.getStatusMessage());
            }
            return null;
        }
        HashMap<String, Double> balances = new HashMap<String, Double>();
        balances.put(cp.getBalanceDisplayLabel(), br.getBalance());
        return balances;
    }

    @Nullable
    public TopupAccountOnDemandPlugin3.AvailableCredit getAvailableCreditForTopUp(String username, String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            return null;
        }
        CBORDDXPlugin cp = CBORDDXTopupAccountOnDemandPlugin.getCBORDDXPlugin();
        if (!cp.isOnDemandTransferEnabledForUser(username)) {
            logger.debug("CBORD top-up on demand plugin not enabled for user '{}'.", (Object)username);
            return null;
        }
        User user = this.getUserManager().getUser(username);
        if (user == null) {
            logger.error("Unknown user: {}", (Object)username);
            return null;
        }
        BalanceResponse response = cp.getBalance(user, null, null);
        if (!response.isSuccess()) {
            logger.error("Error retrieving available credit for user '{}', response: {}", (Object)username, (Object)response);
            return null;
        }
        return new TopupAccountOnDemandPlugin3.AvailableCredit(false, response.getAvailableCredit());
    }

    public TopupAccountOnDemandPlugin.TopupResponse getTopup(double amountRequired, String username, String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged, Map<String, String> usageDetails) {
        String codeMapOverride;
        String locationOverride;
        if (!this.isPluginEnabled()) {
            return null;
        }
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            logger.debug("CBORD top-up on demand plugin not enabled for shared accounts.");
            return null;
        }
        double topupAmount = CBORDDXTopupAccountOnDemandPlugin.calcTopUpAmount(amountRequired);
        if (topupAmount <= 0.0) {
            return null;
        }
        User user = this.getUserManager().getUser(username);
        if (user == null) {
            logger.debug("Unknown user: {}", (Object)username);
            return null;
        }
        CBORDDXPlugin cp = CBORDDXTopupAccountOnDemandPlugin.getCBORDDXPlugin();
        if (!cp.isOnDemandTransferEnabledForUser(username)) {
            logger.debug("CBORD top-up on demand plugin not enabled for user '{}'.", (Object)username);
            return null;
        }
        String serverName = usageDetails.get("server-name");
        String printerName = usageDetails.get("printer-name");
        Printer printer = this.getPrinterManager().findPrinter(serverName, printerName);
        if (printer == null) {
            if (StringUtils.isBlank((String)serverName) && StringUtils.isBlank((String)printerName)) {
                logger.debug("Printer name not provided - will not be used to look up overrides.");
            } else {
                logger.error("Printer not found: {}\\{}", (Object)serverName, (Object)printerName);
            }
            locationOverride = null;
            codeMapOverride = null;
        } else {
            locationOverride = CBORDDXPlugin.getPrinterLocationOverride(printer);
            if (logger.isDebugEnabled() && StringUtils.isNotBlank((String)locationOverride)) {
                logger.debug("Using printer-level location override: {}", (Object)locationOverride);
            }
            codeMapOverride = CBORDDXPlugin.getPrinterCodeMapOverride(printer);
            if (logger.isDebugEnabled() && StringUtils.isNotBlank((String)codeMapOverride)) {
                logger.debug("Using printer-level code map override: {}", (Object)codeMapOverride);
            }
        }
        String txnComment = cp.getOnDemandTransferTransactionComment();
        DebitResponse response = cp.performDebit(user, topupAmount, locationOverride, codeMapOverride);
        txnComment = txnComment.replaceAll("%(?i)transactionId%", response.isSuccess() && response.getTransactionId() != null ? response.getTransactionId() : "Couldn't get transaction Id");
        return GatewayUtils.performTopupDebit((TopupAccountOnDemandPlugin3)this, amount -> {
            logger.debug("Result: {}", (Object)response);
            return response.isSuccess() ? Double.valueOf(response.getAmount()) : null;
        }, topupAmount, amountRequired, username, sharedAccount, accountCharged, usageDetails, txnComment);
    }

    private static double calcTopUpAmount(double amountRequired) {
        if (amountRequired <= 0.0) {
            return 0.0;
        }
        CBORDDXPlugin cp = CBORDDXTopupAccountOnDemandPlugin.getCBORDDXPlugin();
        Double defaultAmount = cp.getOnDemandTransferDefaultTransferAmount();
        Double maxAmount = cp.getOnDemandTransferMaxTransferAmount();
        if (defaultAmount == null || maxAmount == null) {
            return 0.0;
        }
        if (defaultAmount > 0.0 && maxAmount > 0.0 && defaultAmount > maxAmount) {
            logger.warn("CBORD default transfer amount is greater than the max transfer amount.  Using default transfer amount as max amount.");
            maxAmount = defaultAmount;
        }
        double topupAmount = amountRequired;
        if (defaultAmount > 0.0 && amountRequired < defaultAmount) {
            logger.debug("Using default transfer amount of {}", (Object)defaultAmount);
            topupAmount = defaultAmount;
        }
        if (maxAmount > 0.0 && topupAmount > maxAmount) {
            logger.debug("Transfer amount of {} exceeds maximum of {}", (Object)topupAmount, (Object)maxAmount);
            topupAmount = 0.0;
        }
        return topupAmount;
    }

    public boolean isPluginEnabled() {
        CBORDDXPlugin cp = CBORDDXTopupAccountOnDemandPlugin.getCBORDDXPlugin();
        return cp.isPluginEnabled() && cp.isOnDemandTransferEnabled();
    }

    public synchronized ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public synchronized void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    private static CBORDDXPlugin getCBORDDXPlugin() {
        return (CBORDDXPlugin)PluginManager.getInstance().getPluginByClass(CBORDDXPlugin.class);
    }

    private PrinterManager getPrinterManager() {
        return (PrinterManager)this.getApplicationContext().getBean("printerManager", PrinterManager.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }
}

