/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cbord.dx;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.BalanceResponse;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.CBORDDXPlugin;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.DebitResponse;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.CreditSourceManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.ValidationDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnCBORDDX
extends BasePaperCutPage
implements PageRenderListener {
    protected static final Logger logger = LoggerFactory.getLogger(ExtnCBORDDX.class);

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract Double getCBORDBalance();

    public abstract void setCBORDBalance(Double var1);

    public abstract Double getCBORDAvailableCredit();

    public abstract void setCBORDAvailableCredit(Double var1);

    public abstract Double getAmount();

    public abstract void setAmount(Double var1);

    @Nullable
    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract AccountManager getAccountManager();

    public abstract CreditSourceManager getCreditSourceManager();

    public abstract UserManager getUserManager();

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public String getPageTitle() {
        String title = ExtnCBORDDX.getCBORDDXPlugin().getManualTransferPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public String getHeading() {
        return ExtnCBORDDX.getCBORDDXPlugin().getManualTransferPageHeading();
    }

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public void pageBeginRender(PageEvent event) {
        this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(GatewayUtils.createAllowedAmountsModel("cbord-dx.manual-transfer.allowed-amounts", (BasePaperCutPage)this));
        }
        if (!this.getRequestCycle().isRewinding()) {
            String configError;
            if (!ExtnCBORDDX.getCBORDDXPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = ExtnCBORDDX.getCBORDDXPlugin().getIsConfigured()) != null) {
                this.addWarningMessage(configError);
                logger.error(configError);
                return;
            }
            BalanceResponse response = ExtnCBORDDX.getCBORDDXPlugin().getBalance(this.getUser(), null, null);
            if (response.isSuccess()) {
                this.setCBORDBalance(response.getBalance());
                if (GatewayUtils.compareCredit(response.getBalance(), response.getAvailableCredit()) != 0) {
                    this.setCBORDAvailableCredit(response.getAvailableCredit());
                }
            } else if (this.getErrorMessages().isEmpty()) {
                this.addErrorMessage(ExtnCBORDDX.getCBORDDXPlugin().getManualTransferUserErrorMessage() + " (Error retrieving CBORD balance: " + response.getStatusMessage() + ")");
            }
        }
    }

    public void doTransaction(IRequestCycle cycle) {
        ValidationDelegate delegate = (ValidationDelegate)this.getBeans().getBean("delegate");
        if (delegate.getHasErrors()) {
            this.addErrorMessage(delegate.getFirstError().toString());
            return;
        }
        if (!this.isAccessibleByUser()) {
            this.addErrorMessage("You do not have permission to access this feature.");
            return;
        }
        if (this.getAmount() == null || this.getAmount() <= 0.0) {
            this.addErrorMessage("Please select the amount to transfer to your account.");
            return;
        }
        double amount = this.getAmount();
        boolean success = false;
        Object errorSuffix = "";
        try {
            DebitResponse response = ExtnCBORDDX.getCBORDDXPlugin().performDebit(this.getUser(), amount, null, null);
            if (response.isSuccess()) {
                String txnComment = ExtnCBORDDX.getCBORDDXPlugin().getManualTransferTransactionComment().replaceAll("%(?i)transactionId%", response.getTransactionId() != null ? response.getTransactionId() : "Couldn't get transaction Id");
                GatewayUtils.addCreditToUser(this.getAccountManager(), this.getCreditSourceManager(), this.getUser(), amount, txnComment);
                this.addStatusMessage(this.formatBalance(amount) + " was successfully added to your account.");
                cycle.activate("UserSummary");
                success = true;
            } else {
                errorSuffix = (String)errorSuffix + " (Transaction declined by CBORD: " + response.getStatusMessage() + ")";
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error performing CBORD debit transaction for user: {}", (Object)this.getUser().getUserName(), (Object)e);
        }
        if (!success) {
            this.addErrorMessage(ExtnCBORDDX.getCBORDDXPlugin().getManualTransferUserErrorMessage() + (String)errorSuffix);
        }
    }

    public boolean isAccessibleByUser() {
        return ExtnCBORDDX.getCBORDDXPlugin().isManualTransferAccessibleByUser(this.getPaperCutVisit().getUserName());
    }

    public String getNoAccessMsg() {
        return ExtnCBORDDX.getGatewayConfig().getNoAccessMessage();
    }

    public String getUserAndFullName() {
        StringBuilder s = new StringBuilder();
        s.append(this.getUser().getUserName());
        if (StringUtils.isNotBlank((String)this.getUser().getFullName())) {
            s.append(" (");
            s.append(this.getUser().getFullName());
            s.append(")");
        }
        return s.toString();
    }

    public String getCBORDBalanceLabel() {
        return ExtnCBORDDX.getCBORDDXPlugin().getBalanceDisplayLabel();
    }

    public String getCBORDAvailableCreditLabel() {
        return ExtnCBORDDX.getCBORDDXPlugin().getBalanceDisplayAvailableCreditLabel();
    }

    public String getPageMessage() {
        return ExtnCBORDDX.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return ExtnCBORDDX.getGatewayConfig().getPageMessageAvailable();
    }

    private static GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    private static CBORDDXPlugin getCBORDDXPlugin() {
        return (CBORDDXPlugin)PluginManager.getInstance().getPluginByClass(CBORDDXPlugin.class);
    }
}

