/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cbord.dx;

import biz.papercut.pcng.ext.paymentgateway.cbord.dx.CBORDDXPlugin;
import biz.papercut.pcng.util.ObjectUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.znerd.xmlenc.XMLOutputter;

public class RequestMessage {
    private static final String CODE_FROM_SVC = "99";
    private static final String CODE_TO_SVC = "99";
    private static final String TRANSACTION_AMOUNT_CREDIT = "C";
    private static final String TRANSACTION_CLASS_SEND = "0200";
    private static final Format TIMESTAMP_FORMATTER = new SimpleDateFormat("MMddHHmmss");
    private static final Format LOCALDATE_FORMATTER = new SimpleDateFormat("MMdd");
    private static final Format LOCALTIME_FORMATTER = new SimpleDateFormat("HHmmss");
    private static final Format YEAR_FORMATTER = new SimpleDateFormat("yyyy");
    private final CBORDDXPlugin.ServerType _serverType;
    private final TransactionType _transactionType;
    private final String _provider;
    @Nullable
    private final String _cardOrId;
    @Nullable
    private final CardOrIdType _cardOrIdType;
    @Nullable
    private final String _currency;
    @Nullable
    private final Integer _amountCents;
    @Nullable
    private final String _orderId;
    @Nullable
    private final String _location;
    @Nullable
    private final String _codeMap;
    private final int _sequenceNumber;
    @Nullable
    private final String _timestamp;
    @Nullable
    private final String _localDate;
    @Nullable
    private final String _localTime;
    @Nullable
    private final String _year;
    @Nullable
    private final String _transactionId;
    @Nullable
    private final String _operator;

    public RequestMessage(CBORDDXPlugin.ServerType serverType, TransactionType transactionType, String provider, @Nullable String cardOrId, @Nullable CardOrIdType cardOrIdType, @Nullable String location, @Nullable String codeMap, int sequenceNumber, @Nullable String currency, @Nullable Integer amountCents, @Nullable String orderId, @Nullable Date transmissionDate, @Nullable String transactionId, @Nullable String operator) {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        if (cardOrId != null && cardOrId.length() > 37) {
            throw new IllegalArgumentException("mediaValue must be <= 37 characters");
        }
        if (String.valueOf(sequenceNumber).length() > 6) {
            throw new IllegalArgumentException("sequenceNumber must be 6 digits or less");
        }
        if (transactionType == TransactionType.Sale) {
            if (location == null) {
                throw new IllegalArgumentException("Location must be provided for sale transactions.");
            }
            if (location.length() > 15) {
                throw new IllegalArgumentException("location must be <= 15 characters");
            }
            if (currency == null) {
                throw new IllegalArgumentException("Currency must be provided for sale transactions.");
            }
            if (currency.length() != 3) {
                throw new IllegalArgumentException("Currency must be 3 digits (ISO 4217), e.g. \"USD\"");
            }
            if (amountCents == null || amountCents <= 0) {
                throw new IllegalArgumentException("Sale transaction amount must be > 0");
            }
            if (orderId == null) {
                throw new IllegalArgumentException("Order id must be provided for sale transactions.");
            }
        }
        this._serverType = serverType;
        this._transactionType = transactionType;
        this._provider = provider;
        this._cardOrId = cardOrId;
        this._cardOrIdType = cardOrIdType;
        this._location = location;
        this._codeMap = codeMap;
        this._sequenceNumber = sequenceNumber;
        this._currency = currency;
        this._amountCents = amountCents;
        this._orderId = orderId;
        this._timestamp = transmissionDate == null ? null : TIMESTAMP_FORMATTER.format(transmissionDate);
        this._localDate = transmissionDate == null ? null : LOCALDATE_FORMATTER.format(transmissionDate);
        this._localTime = transmissionDate == null ? null : LOCALTIME_FORMATTER.format(transmissionDate);
        this._year = transmissionDate == null ? null : YEAR_FORMATTER.format(transmissionDate);
        this._transactionId = transactionId;
        this._operator = operator;
    }

    public TransactionType getTransactionType() {
        return this._transactionType;
    }

    public String getProvider() {
        return this._provider;
    }

    @Nullable
    public String getCardOrId() {
        return this._cardOrId;
    }

    @Nullable
    public CardOrIdType getCardOrIdType() {
        return this._cardOrIdType;
    }

    @Nullable
    public String getLocation() {
        return this._location;
    }

    public String getCodeMap() {
        return this._codeMap;
    }

    public int getSequenceNumber() {
        return this._sequenceNumber;
    }

    @Nullable
    public String getCurrency() {
        return this._currency;
    }

    @Nullable
    public Integer getAmountCents() {
        return this._amountCents;
    }

    @Nullable
    public String getOrderId() {
        return this._orderId;
    }

    @CheckForNull
    public String getTimestamp() {
        return this._timestamp;
    }

    @CheckForNull
    public String getLocalDate() {
        return this._localDate;
    }

    @CheckForNull
    public String getLocalTime() {
        return this._localTime;
    }

    @CheckForNull
    public String getYear() {
        return this._year;
    }

    @Nullable
    public String getTransactionId() {
        return this._transactionId;
    }

    @CheckForNull
    public String getOperator() {
        return this._operator;
    }

    public String toXML() {
        String code = this.getTransactionType() == TransactionType.Commit ? this.getTransactionType().getCode() + "0000" : this.getTransactionType().getCode() + "9999";
        String tranAmount = this.getCurrency() + TRANSACTION_AMOUNT_CREDIT + StringUtils.leftPad((String)String.valueOf(this.getAmountCents()), (int)12, (String)"0");
        StringWriter sw = new StringWriter();
        try {
            XMLOutputter outputter = new XMLOutputter((Writer)sw, "UTF-8");
            outputter.startTag("Message");
            outputter.startTag("CSGoldMessages");
            outputter.startTag("Class");
            outputter.pcdata(TRANSACTION_CLASS_SEND);
            outputter.endTag();
            outputter.startTag("Code");
            outputter.pcdata(code);
            outputter.endTag();
            if (this.getLocation() != null) {
                outputter.startTag("Location");
                outputter.pcdata(this.getLocation());
                outputter.endTag();
            }
            if (this.getCodeMap() != null) {
                outputter.startTag("CodeMap");
                outputter.pcdata(this.getCodeMap());
                outputter.endTag();
            }
            if (this.getTransactionType() == TransactionType.Sale) {
                outputter.startTag("DupCheckID");
                outputter.pcdata(this.getOrderId());
                outputter.endTag();
            }
            if (this.getLocalDate() != null) {
                outputter.startTag("LocalDate");
                outputter.pcdata(this.getLocalDate());
                outputter.endTag();
            }
            if (this.getLocalTime() != null) {
                outputter.startTag("LocalTime");
                outputter.pcdata(this.getLocalTime());
                outputter.endTag();
            }
            if (this.getCardOrIdType() != null) {
                outputter.startTag("MediaEntry");
                outputter.pcdata(this.getCardOrIdType().getCode());
                outputter.endTag();
            }
            if (this.getCardOrId() != null) {
                outputter.startTag("MediaValue");
                outputter.pcdata(this.getCardOrId());
                outputter.endTag();
            }
            if (this.getOperator() != null) {
                outputter.startTag("Operator");
                outputter.pcdata(this.getOperator());
                outputter.endTag();
            }
            outputter.startTag("Provider");
            outputter.pcdata(this.getProvider());
            outputter.endTag();
            outputter.startTag("SysTraceAuditNumber");
            outputter.pcdata(String.valueOf(this.getSequenceNumber()));
            outputter.endTag();
            if (this.getTimestamp() != null) {
                outputter.startTag("TransmissionDateTime");
                outputter.pcdata(this.getTimestamp());
                outputter.endTag();
            }
            if (this.getTransactionType() == TransactionType.Sale) {
                outputter.startTag("TranAmount");
                outputter.pcdata(tranAmount);
                outputter.endTag();
            }
            if (this.getTransactionId() != null) {
                outputter.startTag("TransID");
                outputter.pcdata(this.getTransactionId());
                outputter.endTag();
            }
            if (this.getYear() != null) {
                outputter.startTag("Year");
                outputter.pcdata(this.getYear());
                outputter.endTag();
            }
            outputter.endTag();
            outputter.endTag();
            outputter.endDocument();
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return sw.toString();
    }

    public String toString() {
        return ObjectUtils.createToStringBuilder((Object)this).append("serverType", (Object)this._serverType).append("transactionType", (Object)this._transactionType).append("provider", (Object)this._provider).append("cardOrId", (Object)this._cardOrId).append("cardOrIdType", (Object)this._cardOrIdType).append("currency", (Object)this._currency).append("amountCents", (Object)this._amountCents).append("orderId", (Object)this._orderId).append("location", (Object)this._location).append("codeMap", (Object)this._codeMap).append("sequenceNumber", this._sequenceNumber).append("timestamp", (Object)this._timestamp).append("localDate", (Object)this._localDate).append("localTime", (Object)this._localTime).append("year", (Object)this._year).append("transactionId", (Object)this._transactionId).append("operator", (Object)this._operator).toString();
    }

    protected static enum TransactionType {
        BalanceInquiry("31"),
        Sale("00"),
        Commit("90");

        private final String _code;

        private TransactionType(String code) {
            this._code = code;
        }

        public String getCode() {
            return this._code;
        }
    }

    protected static enum CardOrIdType {
        Card("020"),
        Id("010");

        private final String _code;

        private CardOrIdType(String code) {
            this._code = code;
        }

        public String getCode() {
            return this._code;
        }
    }
}

