/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cbord.dx;

import biz.papercut.pcng.ext.paymentgateway.cbord.dx.ProtocolException;
import biz.papercut.pcng.ext.paymentgateway.util.XMLUtils;
import biz.papercut.pcng.util.ObjectUtils;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

final class ResponseMessage {
    private static final String AMOUNT_DEBIT = "D";
    private final Status _status;
    @CheckForNull
    private final Integer _newBalanceCents;
    @CheckForNull
    private final Integer _newAvailableCreditCents;
    private final String _transactionId;
    private final String _statusMessage;
    private final String _patron;
    private final int _sequenceNumber;
    private final String _receipt;

    private ResponseMessage(Status status, @Nullable Integer newBalanceCents, @Nullable Integer newAvailableCreditCents, String transactionId, String statusMessage, String patron, int sequenceNumber, String receipt) {
        this._status = status;
        this._newBalanceCents = newBalanceCents;
        this._newAvailableCreditCents = newAvailableCreditCents;
        this._transactionId = transactionId;
        this._statusMessage = statusMessage;
        this._patron = patron;
        this._sequenceNumber = sequenceNumber;
        this._receipt = receipt;
    }

    public Status getStatus() {
        return this._status;
    }

    @CheckForNull
    public Integer getNewBalanceCents() {
        return this._newBalanceCents;
    }

    @CheckForNull
    public Integer getNewAvailableCreditCents() {
        return this._newAvailableCreditCents;
    }

    public String getTransactionId() {
        return this._transactionId;
    }

    public String getStatusMessage() {
        return this._statusMessage;
    }

    public String getPatron() {
        return this._patron;
    }

    public int getSequenceNumber() {
        return this._sequenceNumber;
    }

    public String getReceipt() {
        return this._receipt;
    }

    public static ResponseMessage valueOf(String xml) throws ProtocolException {
        int sequenceNumber;
        Document doc;
        try {
            doc = XMLUtils.parse(xml);
        }
        catch (SAXException saxe) {
            throw new ProtocolException("Unexpected response from CBORD", saxe);
        }
        Status status = Status.valueOfCode(ResponseMessage.getFieldValue(doc, Field.ResponseCode));
        Integer newBalanceCents = null;
        String s = ResponseMessage.getFieldValue(doc, Field.BalanceCents);
        if (StringUtils.isNotBlank((String)s)) {
            newBalanceCents = Integer.valueOf(s);
        }
        if (newBalanceCents != null && ResponseMessage.getFieldValue(doc, Field.BalanceCreditDebit).equals(AMOUNT_DEBIT)) {
            newBalanceCents = -newBalanceCents.intValue();
        }
        Integer newAvailableCreditCents = null;
        String s2 = ResponseMessage.getFieldValue(doc, Field.AvailableCreditCents);
        if (StringUtils.isNotBlank((String)s2)) {
            newAvailableCreditCents = Integer.valueOf(s2);
        }
        if (newAvailableCreditCents != null && ResponseMessage.getFieldValue(doc, Field.AvailableCreditCreditDebit).equals(AMOUNT_DEBIT)) {
            newAvailableCreditCents = -newAvailableCreditCents.intValue();
        }
        String transactionId = ResponseMessage.getFieldValue(doc, Field.TransactionId);
        String statusMessage = ResponseMessage.getFieldValue(doc, Field.StatusMessage);
        String userFullName = ResponseMessage.getFieldValue(doc, Field.UserFullName);
        String sequenceNumberStr = ResponseMessage.getFieldValue(doc, Field.SequenceNumber);
        try {
            sequenceNumber = Integer.parseInt(sequenceNumberStr);
        }
        catch (NumberFormatException nfe) {
            throw new ProtocolException("Invalid sequence number: " + sequenceNumberStr);
        }
        String receipt = ResponseMessage.getFieldValue(doc, Field.Receipt);
        return new ResponseMessage(status, newBalanceCents, newAvailableCreditCents, transactionId, statusMessage, userFullName, sequenceNumber, receipt);
    }

    private static String getFieldValue(Document document, Field field) {
        try {
            return field.getXpathExpression().evaluate(document);
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException(xpee);
        }
    }

    public String toString() {
        return ObjectUtils.createToStringBuilder((Object)this).append("status", (Object)this._status).append("newBalanceCents", (Object)this._newBalanceCents).append("newAvailableCreditCents", (Object)this._newAvailableCreditCents).append("transactionId", (Object)this._transactionId).append("statusMessage", (Object)this._statusMessage).append("patron", (Object)this._patron).append("sequenceNumber", this._sequenceNumber).append("receipt", (Object)this._receipt).toString();
    }

    protected static enum Status {
        Approved("00"),
        Denied("05"),
        SystemError("06"),
        PartialAmountApproved("10");

        private final String _code;

        private Status(String code) {
            this._code = code;
        }

        public static Status valueOfCode(String code) {
            for (Status rc : Status.values()) {
                if (!rc._code.equals(code)) continue;
                return rc;
            }
            throw new IllegalArgumentException("Unknown CBORD response code: " + code);
        }
    }

    private static enum Field {
        BalanceCurrency("substring(//Message/CSGoldMessages/ActualSVCbalance, 1, 3)"),
        BalanceCreditDebit("substring(//Message/CSGoldMessages/ActualSVCbalance, 4, 1)"),
        BalanceCents("substring(//Message/CSGoldMessages/ActualSVCbalance, 5)"),
        AvailableCreditCurrency("substring(//Message/CSGoldMessages/EndSVCbalance, 1, 3)"),
        AvailableCreditCreditDebit("substring(//Message/CSGoldMessages/EndSVCbalance, 4, 1)"),
        AvailableCreditCents("substring(//Message/CSGoldMessages/EndSVCbalance, 5)"),
        Receipt("//Message/CSGoldMessages/HostReceipt"),
        ResponseCode("//Message/CSGoldMessages/ResponseCode"),
        SequenceNumber("//Message/CSGoldMessages/SysTraceAuditNumber"),
        StatusMessage("//Message/CSGoldMessages/HostMessage"),
        TransactionId("//Message/CSGoldMessages/TransID"),
        TransactionTypeCode("substring(//Message/CSGoldMessages/Code, 1, 2)"),
        UserFullName("//Message/CSGoldMessages/Patron");

        private final XPathExpression _xpathExpression;

        private Field(String xpathExpression) {
            XPath xp = XPathFactory.newInstance().newXPath();
            try {
                this._xpathExpression = xp.compile(xpathExpression);
            }
            catch (XPathExpressionException xpee) {
                throw new RuntimeException(xpee);
            }
        }

        public XPathExpression getXpathExpression() {
            return this._xpathExpression;
        }
    }
}

