/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.commweb;

import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.BasePaymentGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.ParameterMapValuesStringBuilder;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.util.Checksum;
import com.papercut.server.lang.service.ApplicationLogLevelEnum;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommWebPlugin
extends BasePaymentGatewayPlugin {
    protected static final Logger logger = LoggerFactory.getLogger(CommWebPlugin.class);
    public static final String CONFIG_PREFIX = "commweb.";
    @AESProperty
    public static final String CONFIG_ACCESS_CODE = "commweb.access-code";
    public static final String CONFIG_MERCHANT_ID = "merchant-id";
    public static final String CONFIG_MERCHANT_NAME = "merchant-name";
    public static final String CONFIG_LOCALE = "locale";
    @AESProperty
    public static final String CONFIG_SECRET_KEY = "commweb.secret-key";
    public static final String CONFIG_PAGE_CONTENT_ABOVE = "page-content-above";
    public static final String CONFIG_PAGE_CONTENT_BELOW = "page-content-below";
    public static final String CONFIG_HOSTED_PAYMENT_PAGE_URL = "hosted-payment-page-url";
    @AESProperty
    public static final String CONFIG_COMMWEB_ACCOUNT2 = "commweb.account-with-api-password";
    @AESProperty
    public static final String CONFIG_COMMWEB_API_PASSWORD = "commweb.api-password";
    public static final String CONFIG_CURRENCY = "currency";
    public static final String CONFIG_ORDER_DESC = "order-desc";
    public static final String DEFAULT_MERCHANT_NAME = "PaperCut";
    public static final String DEFAULT_ORDER_DESC = "PaperCut transfer";
    public static final String DEFAULT_CURRENCY = "AUD";
    static final char[] HEX_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final List<String> PAGES = List.of("ExtnCommWeb");
    private final Map<String, CommWebOrder> commWebOrders = Collections.synchronizedMap(new HashMap());
    public static final String REQUIRED_RESPONSE_PARAMS = "vpc_Version,vpc_Command,vpc_MerchTxnRef,vpc_Merchant,vpc_OrderInfo,vpc_Amount,vpc_Locale,vpc_TxnResponseCode,vpc_TransactionNo";

    @Override
    public String getConfigPrefix() {
        return CONFIG_PREFIX;
    }

    @Override
    public boolean isLicensed() {
        LicenseManager lm = (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
        return GatewayUtils.isLicensed(lm, "payment-gateways-commweb");
    }

    public String createNewOrder(String username, double amount) {
        return this.getCreditCardGatewayPlugin().createNewOrder(username, amount);
    }

    public String getIsConfigured() {
        String errorSuffix = "  Please check the payment gateway config file.";
        if (this.getMerchantId() == null) {
            EventLog.getInstance().logEvent("Merchant ID not provided.");
            return "Merchant ID not provided." + errorSuffix;
        }
        if (this.isCommWebAccount2()) {
            if (this.getAPIPassword() == null) {
                EventLog.getInstance().logEvent("API password is not provided.");
                return "API password is not provided." + errorSuffix;
            }
        } else {
            if (this.getSecretKey() == null) {
                EventLog.getInstance().logEvent("Secret key not provided.");
                return "Secret key not provided." + errorSuffix;
            }
            if (this.getAccessCode() == null) {
                EventLog.getInstance().logEvent("Access Code not provided.");
                return "Access Code not provided." + errorSuffix;
            }
            if (this.getHostedPaymentPageURL() == null) {
                EventLog.getInstance().logEvent("Invalid hosted payment page URL: " + this.getGatewayConfig().getString("commweb.hosted-payment-page-url") + ".");
                return "Invalid hosted payment page URL." + errorSuffix;
            }
        }
        if (this.getAllowedAmounts() == null) {
            EventLog.getInstance().logEvent("Must specify at least one allowed payment amount.");
            return "Must specify at least one allowed payment amount." + errorSuffix;
        }
        return null;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return PAGES;
        }
        return null;
    }

    public String getAccessCode() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_ACCESS_CODE));
    }

    public String getMerchantId() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString("commweb.merchant-id"));
    }

    public String getSecretKey() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_SECRET_KEY));
    }

    public String getLocale() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString("commweb.locale"));
    }

    public String getPageContentAbove() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString("commweb.page-content-above"));
    }

    public String getPageContentBelow() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString("commweb.page-content-below"));
    }

    public String getHostedPaymentPageURL() {
        try {
            return this.getGatewayConfig().getURL("commweb.hosted-payment-page-url").toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isCommWebAccount2() {
        Boolean isCommWebAcct2 = this.getGatewayConfig().getBoolean(CONFIG_COMMWEB_ACCOUNT2);
        if (isCommWebAcct2 == null) {
            return false;
        }
        return isCommWebAcct2;
    }

    public String getAPIPassword() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_COMMWEB_API_PASSWORD));
    }

    public String getCurrency() {
        String currency = StringUtils.trimToNull((String)this.getGatewayConfig().getString("commweb.currency"));
        return currency == null ? DEFAULT_CURRENCY : currency;
    }

    public String getMerchantName() {
        String merchantName = this.getGatewayConfig().getString("commweb.merchant-name");
        return merchantName == null ? DEFAULT_MERCHANT_NAME : merchantName;
    }

    public String getOrderDescription() {
        String orderDesc = this.getGatewayConfig().getString("commweb.order-desc");
        return orderDesc == null ? DEFAULT_ORDER_DESC : orderDesc;
    }

    public Map<String, CommWebOrder> getCommWebOrder() {
        return this.commWebOrders;
    }

    public Boolean finalize(String orderId) {
        CommWebOrder commWebOrder = this.commWebOrders.get(orderId);
        if (commWebOrder != null) {
            this.commWebOrders.remove(orderId);
            return true;
        }
        return false;
    }

    public String convertMapToMD5(Map<String, String> parameters, String secret) {
        StringBuilder hashData = new StringBuilder();
        ArrayList<String> sortParamKeys = new ArrayList<String>(parameters.keySet());
        Collections.sort(sortParamKeys);
        hashData.append(secret);
        for (String key : sortParamKeys) {
            hashData.append(parameters.get(key));
        }
        return Checksum.getMD5Sum((String)hashData.toString());
    }

    public String convertMapToHashedValue(Map<String, String> parameters, String secret) {
        ArrayList<String> fieldNames = new ArrayList<String>(parameters.keySet());
        StringBuilder buf = new StringBuilder();
        Iterator itr = fieldNames.iterator();
        while (itr.hasNext()) {
            String fieldName = (String)itr.next();
            String fieldValue = parameters.get(fieldName);
            if (fieldValue == null || fieldValue.isEmpty()) continue;
            buf.append(fieldName).append("=").append(fieldValue);
            if (!itr.hasNext()) continue;
            buf.append('&');
        }
        return this.hashToHmacSHA256(buf, secret);
    }

    public String hashToHmacSHA256(StringBuilder buf, String secret) {
        byte[] mac = null;
        try {
            byte[] b = CommWebPlugin.fromHexString(secret, 0, secret.length());
            SecretKeySpec key = new SecretKeySpec(b, "HmacSHA256");
            Mac m = Mac.getInstance("HmacSHA256");
            m.init(key);
            m.update(buf.toString().getBytes(StandardCharsets.ISO_8859_1));
            mac = m.doFinal();
        }
        catch (Exception e) {
            logger.error("Error while generating Hashing HMacSHA256: {}", (Object)e.getMessage());
            return "";
        }
        return CommWebPlugin.toHexString(mac);
    }

    public static byte[] fromHexString(String s, int offset, int length) {
        if (length % 2 != 0) {
            return null;
        }
        byte[] byteArray = new byte[length / 2];
        int j = 0;
        int end = offset + length;
        for (int i = offset; i < end; i += 2) {
            int high_nibble = Character.digit(s.charAt(i), 16);
            int low_nibble = Character.digit(s.charAt(i + 1), 16);
            if (high_nibble == -1 || low_nibble == -1) {
                return null;
            }
            byteArray[j++] = (byte)(high_nibble << 4 & 0xF0 | low_nibble & 0xF);
        }
        return byteArray;
    }

    static String toHexString(byte[] input) {
        StringBuilder sb = new StringBuilder(input.length * 2);
        for (byte inputByte : input) {
            sb.append(HEX_TABLE[inputByte >> 4 & 0xF]);
            sb.append(HEX_TABLE[inputByte & 0xF]);
        }
        return sb.toString();
    }

    private String validateResponseParams(Map<String, String> parameters) {
        String[] requiredParams;
        for (String reqParam : requiredParams = REQUIRED_RESPONSE_PARAMS.split(",")) {
            if (parameters.containsKey(reqParam)) continue;
            return "parameter: " + reqParam + " is missing";
        }
        String vpcSecureHash = parameters.remove("vpc_SecureHash");
        parameters.remove("vpc_SecureHashType");
        parameters.remove("service");
        String hashDigest = this.convertMapToHashedValue(parameters, this.getSecretKey());
        if (!hashDigest.equalsIgnoreCase(vpcSecureHash)) {
            return "hash mismatch: " + hashDigest + " vs " + vpcSecureHash;
        }
        return null;
    }

    public String processCallbackResponse(Map<String, String> parameters) {
        String status = StringUtils.trimToEmpty((String)parameters.get("STATUS"));
        String orderId = StringUtils.trimToEmpty((String)parameters.get("ORDERID"));
        String resultIndicator = StringUtils.trimToEmpty((String)parameters.get("RESULTINDICATOR"));
        String errorDesc = StringUtils.trimToEmpty((String)parameters.get("ERRORDESC"));
        CommWebOrder commWebOrder = this.getCommWebOrder().get(orderId);
        if (commWebOrder != null) {
            this.finalize(orderId);
            String amount = commWebOrder.get_amount();
            String logSuffix = " Order id: " + orderId + ", payment amount: " + amount;
            String fullDetails = " Reported transaction details: " + String.valueOf(commWebOrder);
            if (status.equalsIgnoreCase("CANCEL")) {
                String msg = "Warning: Transaction was cancelled by user.";
                logger.info("{}{}{}", new Object[]{msg, logSuffix, fullDetails});
                EventLog.getInstance().logEvent(msg + fullDetails);
                this.getCreditCardGatewayPlugin().cancelOrder(orderId);
                return msg;
            }
            if (status.equalsIgnoreCase("ERROR")) {
                String msg = "Transaction was declined by CommWeb with error:" + errorDesc + logSuffix;
                this.cancelOrder(orderId, msg, fullDetails);
                return msg;
            }
            if (status.equalsIgnoreCase("COMPLETE")) {
                String successIndicator = commWebOrder.get_successIndicator();
                logger.debug("ResultIndicator ={}{}", (Object)resultIndicator, (Object)logSuffix);
                if (successIndicator.equals(resultIndicator)) {
                    CreditCardGatewayPlugin.OrderResponse response = this.getCreditCardGatewayPlugin().confirmOrder(orderId, Double.parseDouble(amount));
                    if (!response.isSuccess()) {
                        String msg = "Could not confirm CommWeb order. Message: " + response.getMessage() + ". Manual reconciliation may be required." + logSuffix;
                        this.cancelOrder(orderId, msg, fullDetails);
                        return msg;
                    }
                    String msg = "Order confirmed." + logSuffix;
                    logger.info(msg);
                    EventLog.getInstance().logEvent(msg);
                    return null;
                }
                String msg = "Transaction Result Indicator is not matched.Order will not be confirmed." + logSuffix;
                this.cancelOrder(orderId, msg, fullDetails);
                return msg;
            }
            String msg = "CommWeb transaction response contains invalid status : " + status;
            this.cancelOrder(orderId, msg, fullDetails);
            return msg;
        }
        String msg = "CommWeb transaction response contains invalid OrderID : " + orderId;
        logger.error(msg);
        EventLog.getInstance().logEvent("ERROR: " + msg);
        this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg);
        return msg;
    }

    public void cancelOrder(String orderId, String msg, String fullDetails) {
        logger.error("{}{}", (Object)msg, (Object)fullDetails);
        EventLog.getInstance().logEvent("ERROR: " + msg + fullDetails);
        this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg);
        this.getCreditCardGatewayPlugin().cancelOrder(orderId);
    }

    public String processTransaction(Map<String, String> parameters) {
        CreditCardGatewayPlugin.OrderResponse response = null;
        String transactionId = StringUtils.trimToEmpty((String)parameters.get("vpc_TransactionNo"));
        String orderId = StringUtils.trimToEmpty((String)parameters.get("vpc_OrderInfo"));
        String amount = StringUtils.trimToEmpty((String)parameters.get("vpc_Amount"));
        String errorMsg = StringUtils.trimToEmpty((String)parameters.get("vpc_Message"));
        String logSuffix = " Transaction id: " + transactionId + ", order id: " + orderId + ", payment amount: " + amount + ", error message: " + errorMsg + ".";
        String fullDetails = " Reported transaction details: " + this.buildLogMessageFromParameters(parameters);
        String errString = this.validateResponseParams(parameters);
        if (errString != null) {
            String msg = "CommWeb transaction response contains invalid payment response data. Detected error: \"" + errString + "\" Order will not be confirmed." + logSuffix;
            logger.error("{}{}", (Object)msg, (Object)fullDetails);
            EventLog.getInstance().logEvent("ERROR: " + msg + fullDetails);
            this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg);
            this.getCreditCardGatewayPlugin().cancelOrder(orderId);
            return msg;
        }
        if (!this.isTransactionApproved(parameters)) {
            String msg = "Order was canceled or declined by CommWeb: " + errorMsg + logSuffix;
            logger.info(msg);
            EventLog.getInstance().logEvent(msg);
            this.getCreditCardGatewayPlugin().cancelOrder(orderId);
            return msg;
        }
        Double paymentAmount = null;
        try {
            paymentAmount = Double.valueOf(amount);
            paymentAmount = paymentAmount / 100.0;
        }
        catch (Exception e) {
            String msg = "Invalid transaction amount." + logSuffix;
            logger.error(msg);
            EventLog.getInstance().logEvent("ERROR: " + msg);
            this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg);
            this.getCreditCardGatewayPlugin().cancelOrder(orderId);
            return msg;
        }
        response = this.getCreditCardGatewayPlugin().confirmOrder(orderId, paymentAmount);
        if (!response.isSuccess()) {
            String msg = "Could not confirm CommWeb order. Message: " + response.getMessage() + ". Manual reconciliation may be required." + logSuffix;
            logger.error("{}{}", (Object)msg, (Object)fullDetails);
            EventLog.getInstance().logEvent("ERROR: " + msg + fullDetails);
            this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg);
            return msg;
        }
        String msg = "Order confirmed." + logSuffix;
        logger.info(msg);
        EventLog.getInstance().logEvent(msg);
        return null;
    }

    String buildLogMessageFromParameters(Map<String, String> parameters) {
        ParameterMapValuesStringBuilder stringBuilder = new ParameterMapValuesStringBuilder(parameters);
        this.getParametersToLog().forEach(stringBuilder::add);
        return stringBuilder.build();
    }

    private List<String> getParametersToLog() {
        return List.of("STATUS", "ORDERID", "RESULTINDICATOR", "ERRORDESC", "vpc_TransactionNo", "vpc_OrderInfo", "vpc_Amount", "vpc_Message", "vpc_TxnResponseCode");
    }

    private boolean isTransactionApproved(Map<String, String> parameters) {
        int transactionCode;
        try {
            transactionCode = Integer.parseInt(parameters.get("vpc_TxnResponseCode"));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return transactionCode == 0;
    }

    public static class CommWebOrder {
        private final String _successIndicator;
        private final String _sessionId;
        private final String _amount;

        public CommWebOrder(String successIndicator, String sessionId, String amount) {
            this._successIndicator = successIndicator;
            this._sessionId = sessionId;
            this._amount = amount;
        }

        public String get_sessionId() {
            return this._sessionId;
        }

        public String get_amount() {
            return this._amount;
        }

        public String get_successIndicator() {
            return this._successIndicator;
        }

        public String toString() {
            return "sessionId=" + this.get_sessionId() + " amount=" + this.get_amount() + " successIndicator=" + this.get_successIndicator();
        }
    }
}

