/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.commweb;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.commweb.CommWebPlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;

public abstract class CommWebRedirect
extends BasePaperCutPage
implements PageRenderListener {
    public static final String PAGE_NAME = "CommWebRedirect";

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract void setAmount(String var1);

    public abstract void setOrderId(String var1);

    public abstract void setSessionID(String var1);

    public abstract void setInternalRedirect(boolean var1);

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public void pageBeginRender(PageEvent event) {
        String orderId;
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if ((orderId = this.getRequestCycle().getRequestContext().getParameter("orderID")) == null) {
            throw new PageRedirectException("ExtnCommWeb");
        }
        this.setOrderId(orderId);
        CommWebPlugin.CommWebOrder commWebOrder = this.getCommWebPlugin().getCommWebOrder().get(orderId);
        if (commWebOrder == null) {
            throw new PageRedirectException("ExtnCommWeb");
        }
        this.setSessionID(commWebOrder.get_sessionId());
        this.setAmount(commWebOrder.get_amount());
        String url = this.getRequest().getHeader("Referer");
        this.setInternalRedirect(url != null && !url.isEmpty());
    }

    public String getReturnURL() {
        HttpServletRequest r = this.getRequest();
        StringBuffer returnURL = r.getRequestURL();
        returnURL.append("?service=external/");
        returnURL.append("ExtnCommWeb");
        return returnURL.toString();
    }

    public String getMerchantName() {
        return this.getCommWebPlugin().getMerchantName();
    }

    public String getMerchantID() {
        return this.getCommWebPlugin().getMerchantId();
    }

    public String getLanguage() {
        return GatewayConfig.getInstance().getString("locale");
    }

    public String getCurrency() {
        return this.getCommWebPlugin().getCurrency();
    }

    public String getOrderDescription() {
        return this.getCommWebPlugin().getOrderDescription();
    }

    public abstract UserManager getUserManager();

    private CommWebPlugin getCommWebPlugin() {
        return (CommWebPlugin)PluginManager.getInstance().getPluginByClass(CommWebPlugin.class);
    }
}

