/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.commweb;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.BasePaymentGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.ParameterMapValuesStringBuilder;
import biz.papercut.pcng.ext.paymentgateway.commweb.CommWebPlugin;
import biz.papercut.pcng.ext.paymentgateway.pages.BasePaymentGatewayPage;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.web.util.WebUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnCommWeb
extends BasePaymentGatewayPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(ExtnCommWeb.class);
    public static final String PAGE_NAME = "ExtnCommWeb";

    @Override
    public abstract AccountManager getAccountManager();

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(this.createAmountsModel());
        }
        if (!this.getRequestCycle().isRewinding()) {
            String configError;
            if (!this.getCommWebPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = this.getCommWebPlugin().getIsConfigured()) != null) {
                this.addErrorMessage(configError);
                logger.error(configError);
            }
        }
    }

    private StringBuffer convertMapToURLParams(Map<String, String> parameters) {
        StringBuffer str = new StringBuffer();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (str.isEmpty()) {
                str.append("?");
            } else {
                str.append("&");
            }
            str.append(entry.getKey());
            str.append("=");
            str.append(this.encode(entry.getValue()));
        }
        return str;
    }

    public void formSubmit(IRequestCycle cycle) {
        Double amount = this.getAmount();
        if (amount == null || amount <= 0.0) {
            this.addErrorMessage("Please select an amount to add");
            return;
        }
        if (this.getCommWebPlugin().getIsConfigured() != null) {
            return;
        }
        String orderId = this.getCommWebPlugin().createNewOrder(this.getPaperCutVisit().getUserName(), this.getAmount());
        if (this.getCommWebPlugin().isCommWebAccount2()) {
            HashMap<String, String> response = this.getSessionData(orderId, amount.toString(), this.getCommWebPlugin().getCurrency());
            String successIndicator = response.get("successIndicator");
            String sessionID = response.get("session.id");
            if (successIndicator == null || sessionID == null) {
                this.addErrorMessage("Transaction failed: Unable to fetch SessionID");
                return;
            }
            CommWebPlugin.CommWebOrder commWebOrder = new CommWebPlugin.CommWebOrder(successIndicator, sessionID, amount.toString());
            this.getCommWebPlugin().getCommWebOrder().put(orderId, commWebOrder);
            logger.debug("Setting order:{} with data-{}", (Object)orderId, (Object)commWebOrder);
            HttpServletRequest r = this.getRequest();
            WebUtils.redirectToURL((IRequestCycle)cycle, (String)(String.valueOf(r.getRequestURL()) + "?service=page/CommWebRedirect&orderID=" + orderId));
            return;
        }
        String merchTransRef = this.getPaperCutVisit().getUserName();
        String command = "pay";
        String locale = this.getCommWebPlugin().getLocale();
        if (locale.isEmpty()) {
            locale = "en";
        }
        String amountStr = GatewayUtils.formatNumber(this.getAmount() * 100.0, 0, Locale.US, false);
        HttpServletRequest r = this.getRequest();
        StringBuffer returnURL = r.getRequestURL();
        returnURL.append("?service=external/");
        returnURL.append(PAGE_NAME);
        String version = "1";
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("vpc_AccessCode", this.getCommWebPlugin().getAccessCode());
        params.put("vpc_Amount", amountStr);
        params.put("vpc_Command", command);
        params.put("vpc_Locale", locale);
        params.put("vpc_Merchant", this.getCommWebPlugin().getMerchantId());
        params.put("vpc_MerchTxnRef", merchTransRef);
        params.put("vpc_OrderInfo", orderId);
        params.put("vpc_ReturnURL", returnURL.toString());
        params.put("vpc_Version", version);
        String hash = this.getCommWebPlugin().convertMapToHashedValue(params, this.getCommWebPlugin().getSecretKey());
        StringBuffer url = new StringBuffer();
        url.append(this.getCommWebPlugin().getHostedPaymentPageURL());
        url.append(this.convertMapToURLParams(params));
        url.append("&vpc_SecureHash=").append(hash);
        url.append("&vpc_SecureHashType=").append("SHA256");
        logger.debug("HPP URL: {}", (Object)url);
        WebUtils.redirectToURL((IRequestCycle)cycle, (String)url.toString());
    }

    private String encode(String s) {
        if (s == null) {
            return "";
        }
        return URLEncoder.encode(s, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public HashMap<String, String> getSessionData(String orderid, String amount, String currency) {
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            String line;
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, null, null);
            SSLSocketFactory factory = context.getSocketFactory();
            SSLSocket socket = (SSLSocket)factory.createSocket("paymentgateway.commbank.com.au", 443);
            HashMap<String, Object> nameValue = new HashMap<String, Object>();
            nameValue.put("apiOperation", "CREATE_CHECKOUT_SESSION");
            nameValue.put("apiPassword", this.getCommWebPlugin().getAPIPassword());
            nameValue.put("apiUsername", "merchant." + this.getCommWebPlugin().getMerchantId());
            nameValue.put("merchant", this.getCommWebPlugin().getMerchantId());
            nameValue.put("order.id", orderid);
            nameValue.put("order.amount", amount);
            nameValue.put("order.currency", currency);
            StringBuilder data = new StringBuilder();
            for (Map.Entry entry : nameValue.entrySet()) {
                if (!data.isEmpty()) {
                    data.append("&");
                }
                data.append(URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8));
            }
            String path = "/api/nvp/version/40";
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8));
            wr.write("POST " + path + " HTTP/1.0\r\n");
            wr.write("Content-Length: " + data.length() + "\r\n");
            wr.write("Content-Type: application/x-www-form-urlencoded\r\n");
            wr.write("\r\n");
            wr.write(data.toString());
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((line = rd.readLine()) != null) {
                String[] responseMap;
                if (!line.contains("session.id")) continue;
                for (String res : responseMap = StringUtils.split((String)line, (String)"&")) {
                    String[] resSplit = StringUtils.split((String)res, (String)"=");
                    response.put(resSplit[0], resSplit[1]);
                }
            }
            wr.close();
            rd.close();
        }
        catch (Exception e) {
            logger.error("Error while doing CREATE_CHECKOUT_SESSION {}", (Object)e.getMessage());
        }
        return response;
    }

    public void redirectToSummaryPage(IRequestCycle cycle) {
        cycle.activate("UserSummary");
    }

    @Override
    public BasePaymentGatewayPlugin getPlugin() {
        return this.getCommWebPlugin();
    }

    private Map<String, String> normalizeParameterValues(Map<String, String[]> parameters) {
        TreeMap<String, String> normalizedParameters = new TreeMap<String, String>();
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            normalizedParameters.put(entry.getKey(), StringUtils.join((Object[])entry.getValue(), (String)","));
        }
        return normalizedParameters;
    }

    private String getResponseDescription(String vResponseCode) {
        String result = "";
        if (vResponseCode.length() == 1) {
            char input = vResponseCode.charAt(0);
            result = switch (input) {
                case '0' -> "Transaction Successful";
                case '1' -> "Unknown Error";
                case '2' -> "Bank Declined Transaction";
                case '3' -> "No Reply from Bank";
                case '4' -> "Expired Card";
                case '5' -> "Insufficient Funds";
                case '6' -> "Error Communicating with Bank";
                case '7' -> "Payment Server System Error";
                case '8' -> "Transaction Type Not Supported";
                case '9' -> "Bank declined transaction (Do not contact Bank)";
                case 'A' -> "Transaction Aborted";
                case 'C' -> "Transaction Cancelled";
                case 'D' -> "Deferred transaction has been received and is awaiting processing";
                case 'F' -> "3D Secure Authentication failed";
                case 'I' -> "Card Security Code verification failed";
                case 'L' -> "Shopping Transaction Locked (Please try the transaction again later)";
                case 'N' -> "Cardholder is not enrolled in Authentication Scheme";
                case 'P' -> "Transaction has been received by the Payment Adaptor and is being processed";
                case 'R' -> "Transaction was not processed - Reached limit of retry attempts allowed";
                case 'S' -> "Duplicate SessionID (OrderInfo)";
                case 'T' -> "Address Verification Failed";
                case 'U' -> "Card Security Code Failed";
                case 'V' -> "Address Verification and Card Security Code Failed";
                case '?' -> "Transaction status is unknown";
                default -> "Unable to be determined";
            };
            return result;
        }
        return "No Value Returned";
    }

    public void activateExternalPage(Object[] arguments, IRequestCycle cycle) {
        HttpServletRequest request = this.getRequest();
        Map<String, String> parameters = this.normalizeParameterValues(request.getParameterMap());
        logger.debug("Return URL params: {}", (Object)this.buildLogMessageFromParameters(parameters));
        String transactionErrorMsg = "";
        String responseCode = "";
        String commWebErrorMsg = "";
        if (this.getCommWebPlugin().isCommWebAccount2()) {
            transactionErrorMsg = this.getCommWebPlugin().processCallbackResponse(parameters);
        } else {
            transactionErrorMsg = this.getCommWebPlugin().processTransaction(parameters);
            responseCode = request.getParameter("vpc_TxnResponseCode");
            commWebErrorMsg = this.getResponseDescription(responseCode);
        }
        if (transactionErrorMsg == null) {
            this.addStatusMessage("Funds have been added to your account");
        } else if (transactionErrorMsg.startsWith("Warning")) {
            this.addWarningMessage(transactionErrorMsg);
        } else if (!StringUtils.isBlank((String)commWebErrorMsg)) {
            this.addErrorMessage("Transaction failed: " + commWebErrorMsg + " (error code:" + responseCode + ")");
        } else {
            this.addErrorMessage("Transaction failed: " + transactionErrorMsg);
        }
    }

    String buildLogMessageFromParameters(Map<String, String> parameters) {
        ParameterMapValuesStringBuilder stringBuilder = new ParameterMapValuesStringBuilder(parameters);
        this.getParametersToLog().forEach(stringBuilder::add);
        return stringBuilder.build();
    }

    private List<String> getParametersToLog() {
        return List.of("STATUS", "ORDERID", "RESULTINDICATOR", "ERRORDESC", "vpc_TransactionNo", "vpc_OrderInfo", "vpc_Amount", "vpc_Message", "vpc_TxnResponseCode");
    }

    public String getPageContentAbove() {
        return this.getCommWebPlugin().getPageContentAbove();
    }

    public String getPageContentBelow() {
        return this.getCommWebPlugin().getPageContentBelow();
    }

    private CommWebPlugin getCommWebPlugin() {
        return (CommWebPlugin)PluginManager.getInstance().getPluginByClass(CommWebPlugin.class);
    }
}

