/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cybersource;

import biz.papercut.pcng.ext.paymentgateway.BasePaymentGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.ParameterMapValuesStringBuilder;
import biz.papercut.pcng.ext.paymentgateway.PaymentGatewayRequestLogMessageBuilder;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.WebServerPlugin;
import biz.papercut.pcng.service.LicenseManager;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyberSourcePlugin
extends BasePaymentGatewayPlugin
implements WebServerPlugin {
    protected static final Logger logger = LoggerFactory.getLogger(CyberSourcePlugin.class);
    public static final String POSTBACK_URL_PATH = "/rpc/gateway/cybersource";
    public static final String CONFIG_PREFIX = "cybersource.";
    public static final String CONFIG_MERCHANT_ID = "merchant-id";
    public static final String CONFIG_PUBLIC_KEY = "public-key";
    public static final String CONFIG_SERIAL_NUMBER = "serial-number";
    public static final String CONFIG_CURRENCY = "currency";
    public static final String CONFIG_IGNORE_AVS = "ignore-avs";
    public static final String CONFIG_PAYMENT_DESCRIPTION = "payment-description";
    public static final String CONFIG_HOSTED_ORDER_PAGE_URL = "hosted-order-page-url";
    public static final String CONFIG_RECEIPT_HEADER = "receipt-header";
    public static final String CONFIG_POSTBACK_ALLOWED_IP = "postback-allowed-ip";
    public static final String FIELD_USER_NAME = "billTo_customerID";
    public static final String FIELD_ORDER_NUMBER = "orderNumber";
    public static final String REQUEST_FIELD_TRANSACTION_TYPE_SALE = "sale";
    public static final String RESPONSE_FIELD_SIGNED_FIELDS = "signedFields";
    public static final String RESPONSE_FIELD_TRANSACTION_SIGNATURE = "transactionSignature";
    public static final String RESPONSE_FIELD_ORDER_AMOUNT = "orderAmount";
    public static final String RESPONSE_FIELD_DECISION = "decision";
    public static final String RESPONSE_FIELD_DECISION_ACCEPT = "accept";
    public static final String RESPONSE_FIELD_REQUEST_ID = "requestID";
    public static final String RESPONSE_FIELD_RECONCILIATION_ID = "reconciliationID";
    public static final String RESPONSE_FIELD_TIMESTAMP = "ccAuthReply_authorizedDateTime";
    public static final String RESPONSE_FIELD_ENVIRONMENT = "orderPage_environment";
    public static final String CUSTOM_FIELD_RETURN_REDIRECT_URL = "return-redirect-url";
    private static final String PATH_TRANSACTION = "/transaction";
    private static final String PATH_USER = "/user";
    private static final String ALGORITHM_NAME_HMAC_SHA1 = "HmacSHA1";
    private static final List<String> PAGES = List.of("ExtnCyberSource");
    private static final String ENVIRONMENT_TEST = "TEST";
    private static final String HOP_URL_TEST = "https://orderpagetest.ic3.com/hop/orderform.jsp";

    @Override
    public String getConfigPrefix() {
        return CONFIG_PREFIX;
    }

    @Override
    public boolean isLicensed() {
        LicenseManager lm = (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
        return GatewayUtils.isLicensed(lm, "payment-gateways-cybersource");
    }

    public String createNewOrder(String username, double amount) {
        return this.getCreditCardGatewayPlugin().createNewOrder(username, amount);
    }

    @CheckForNull
    public String getIsConfigured() {
        String errorSuffix = "  Please check the payment gateway config file.";
        try {
            Mac.getInstance(ALGORITHM_NAME_HMAC_SHA1);
        }
        catch (NoSuchAlgorithmException nsae) {
            String error = "Required cryptography functionality is not present.  Contact support for assistance.";
            GatewayUtils.LogHelper.logError(logger, error, nsae);
            return error;
        }
        if (this.getMerchantId() == null) {
            GatewayUtils.LogHelper.logError(logger, "Merchant id not provided.");
            return "Merchant id not provided." + errorSuffix;
        }
        if (this.getPublicKey() == null) {
            GatewayUtils.LogHelper.logError(logger, "Public key not provided.");
            return "Public key not provided." + errorSuffix;
        }
        if (this.getSerialNumber() == null) {
            GatewayUtils.LogHelper.logError(logger, "Serial number not provided.");
            return "Serial number not provided." + errorSuffix;
        }
        if (this.getCurrency() == null) {
            GatewayUtils.LogHelper.logError(logger, "Currency not provided.");
            return "Currency not provided." + errorSuffix;
        }
        if (this.getAllowedAmounts() == null) {
            GatewayUtils.LogHelper.logError(logger, "Must specify at least one allowed payment amount.");
            return "Must specify at least one allowed payment amount." + errorSuffix;
        }
        URL orderPageURL = null;
        try {
            orderPageURL = this.getHostedOrderPageURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (orderPageURL == null) {
            GatewayUtils.LogHelper.logError(logger, "Invalid hosted order page URL: " + this.getGatewayConfig().getString("cybersource.hosted-order-page-url") + ".");
            return "Invalid hosted order page URL." + errorSuffix;
        }
        return null;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return PAGES;
        }
        return null;
    }

    public void preStartupHook(WebServerPlugin.WebServer server) {
        if (!this.isPluginEnabled()) {
            return;
        }
        server.addServlet(CyberSourcePOSTBackServlet.class, "/rpc/gateway/cybersource/*");
    }

    public String getMerchantId() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString("cybersource.merchant-id"));
    }

    public String getPublicKey() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString("cybersource.public-key"));
    }

    public String getSerialNumber() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString("cybersource.serial-number"));
    }

    public String getCurrency() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString("cybersource.currency"));
    }

    public String getPaymentDescription() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString("cybersource.payment-description"));
    }

    public URL getHostedOrderPageURL() throws MalformedURLException {
        return this.getGatewayConfig().getURL("cybersource.hosted-order-page-url");
    }

    public String getReceiptHeader() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString("cybersource.receipt-header"));
    }

    @CheckForNull
    public String getTransactionSignature(String amount, String currency, String timestamp) {
        String data = this.getMerchantId() + amount + currency + timestamp + REQUEST_FIELD_TRANSACTION_TYPE_SALE;
        return this.digest(data);
    }

    public boolean isIgnoreAvs() {
        return BooleanUtils.isTrue((Boolean)this.getGatewayConfig().getBoolean("cybersource.ignore-avs"));
    }

    @CheckForNull
    private String digest(String data) {
        String publicKey = this.getPublicKey();
        String publicDigest = null;
        try {
            Mac sha1Mac = Mac.getInstance(ALGORITHM_NAME_HMAC_SHA1);
            SecretKeySpec publicKeySpec = new SecretKeySpec(publicKey.getBytes(), ALGORITHM_NAME_HMAC_SHA1);
            sha1Mac.init(publicKeySpec);
            byte[] publicBytes = sha1Mac.doFinal(data.getBytes());
            publicDigest = new String(Base64.encodeBase64((byte[])publicBytes));
            publicDigest = publicDigest.replaceAll("[\r\n\t]", "");
        }
        catch (Exception e) {
            GatewayUtils.LogHelper.logError(logger, "Unable to calculate signature: " + e.getMessage());
        }
        return publicDigest;
    }

    protected void processTransaction(Map<String, String> parameters) {
        this.verifyAndConfirmOrder(parameters);
    }

    protected String processUserReturn(Map<String, String> parameters) {
        CreditCardGatewayPlugin.OrderResponse response = this.verifyAndConfirmOrder(parameters);
        StringBuilder url = new StringBuilder();
        url.append(parameters.get(CUSTOM_FIELD_RETURN_REDIRECT_URL));
        url.append("&success=").append(response.isSuccess());
        if (StringUtils.isNotBlank((String)response.getMessage())) {
            url.append("&message=").append(response.getMessage());
        }
        url.append("&").append(FIELD_ORDER_NUMBER);
        url.append("=").append(parameters.get(FIELD_ORDER_NUMBER));
        url.append("&").append(RESPONSE_FIELD_ORDER_AMOUNT);
        url.append("=").append(parameters.get(RESPONSE_FIELD_ORDER_AMOUNT));
        url.append("&").append(RESPONSE_FIELD_REQUEST_ID);
        url.append("=").append(parameters.get(RESPONSE_FIELD_REQUEST_ID));
        url.append("&").append(RESPONSE_FIELD_RECONCILIATION_ID);
        url.append("=").append(parameters.get(RESPONSE_FIELD_RECONCILIATION_ID));
        url.append("&").append(RESPONSE_FIELD_TIMESTAMP);
        url.append("=").append(parameters.get(RESPONSE_FIELD_TIMESTAMP));
        try {
            new URL(url.toString());
            return url.toString();
        }
        catch (Exception e) {
            GatewayUtils.LogHelper.logError(logger, "Could not return user to correct page as URL is invalid: " + String.valueOf(url) + ". Sending user to login page.");
            return "/";
        }
    }

    private CreditCardGatewayPlugin.OrderResponse verifyAndConfirmOrder(Map<String, String> parameters) {
        CreditCardGatewayPlugin.OrderResponse response = null;
        String userName = parameters.get(FIELD_USER_NAME);
        String orderId = parameters.get(FIELD_ORDER_NUMBER);
        String amountParam = parameters.get(RESPONSE_FIELD_ORDER_AMOUNT);
        String logSuffix = " User: " + userName + ", payment amount: " + amountParam;
        String fullDetails = "CyberSource reported transaction details: " + CyberSourcePlugin.buildStringFromParameters(parameters);
        String environment = parameters.get(RESPONSE_FIELD_ENVIRONMENT);
        if (environment != null) {
            try {
                URL hopUrl = this.getHostedOrderPageURL();
                if (environment.equals(ENVIRONMENT_TEST) && !hopUrl.toExternalForm().equals(HOP_URL_TEST)) {
                    GatewayUtils.LogHelper.logError(logger, "Received a transaction from the CyberSource test environment but we are not running in test mode. Failing transaction.");
                    response = new CreditCardGatewayPlugin.OrderResponse(false, "Order failed validation.");
                }
            }
            catch (MalformedURLException murle) {
                GatewayUtils.LogHelper.logError(logger, "Unable to parse hosted order page URL: " + murle.getMessage());
                response = new CreditCardGatewayPlugin.OrderResponse(false, "Invalid configuration (HOP URL).");
            }
        }
        if (response == null && !this.verifyTransaction(parameters)) {
            GatewayUtils.LogHelper.logError(logger, "CyberSource order " + orderId + " failed validation and will not be confirmed." + logSuffix, null, this.getApplicationLogManager());
            GatewayUtils.LogHelper.logError(logger, fullDetails);
            response = new CreditCardGatewayPlugin.OrderResponse(false, "Order failed validation.");
        }
        if (response == null && !this.isTransactionApproved(parameters)) {
            GatewayUtils.LogHelper.logInfo(logger, "Order " + orderId + " was declined by CyberSource." + logSuffix);
            response = new CreditCardGatewayPlugin.OrderResponse(false, "Order declined by processor.");
        }
        if (response == null) {
            Double amount = null;
            try {
                amount = Double.valueOf(amountParam);
            }
            catch (NumberFormatException nfe) {
                GatewayUtils.LogHelper.logError(logger, "CyberSource order " + orderId + " has invalid transaction amount." + logSuffix, null, this.getApplicationLogManager());
                response = new CreditCardGatewayPlugin.OrderResponse(false, "Invalid order amount: " + amountParam);
            }
            if (amount != null) {
                response = this.getCreditCardGatewayPlugin().confirmOrderReentrant(orderId, amount);
                if (response.isAlreadyProcessed()) {
                    GatewayUtils.LogHelper.logDebug(logger, "Order " + orderId + " was already processed.");
                } else if (response.isSuccess()) {
                    GatewayUtils.LogHelper.logInfo(logger, "Order " + orderId + " confirmed.");
                } else {
                    GatewayUtils.LogHelper.logError(logger, "Could not confirm CyberSource order " + orderId + ", message: " + response.getMessage() + ". Manual reconciliation may be required." + logSuffix, null, this.getApplicationLogManager());
                    GatewayUtils.LogHelper.logError(logger, fullDetails);
                }
            }
        }
        return response;
    }

    private boolean verifyTransaction(Map<String, String> parameters) {
        String transactionSignatureCalculated;
        String transactionSignature = parameters.get(RESPONSE_FIELD_TRANSACTION_SIGNATURE);
        String transactionSignatureFields = parameters.get(RESPONSE_FIELD_SIGNED_FIELDS);
        if (transactionSignature == null || transactionSignatureFields == null) {
            return false;
        }
        StringBuilder transactionData = new StringBuilder();
        for (String field : StringUtils.split((String)transactionSignatureFields, (String)",")) {
            transactionData.append(parameters.get(field));
        }
        try {
            transactionSignatureCalculated = this.digest(transactionData.toString());
        }
        catch (Exception e) {
            GatewayUtils.LogHelper.logError(logger, "Unable to calculate signature: " + e.getMessage(), e, null);
            return false;
        }
        if (transactionSignatureCalculated == null) {
            GatewayUtils.LogHelper.logError(logger, "Unable to calculate signature.");
            return false;
        }
        if (!transactionSignatureCalculated.equals(transactionSignature)) {
            GatewayUtils.LogHelper.logError(logger, "Transaction signature does not validate (provided: " + transactionSignature + ", calculated: " + transactionSignatureCalculated + "). Order will not be finalized.");
            return false;
        }
        return true;
    }

    private boolean isTransactionApproved(Map<String, String> parameters) {
        String decision = parameters.get(RESPONSE_FIELD_DECISION);
        return decision != null && decision.equalsIgnoreCase(RESPONSE_FIELD_DECISION_ACCEPT);
    }

    private static String buildStringFromParameters(Map<String, ?> parameterMap) {
        ParameterMapValuesStringBuilder stringBuilder = new ParameterMapValuesStringBuilder(parameterMap);
        CyberSourcePlugin.getParametersToLog().forEach(stringBuilder::add);
        return stringBuilder.build();
    }

    private static List<String> getParametersToLog() {
        return List.of(FIELD_USER_NAME, FIELD_ORDER_NUMBER, RESPONSE_FIELD_ORDER_AMOUNT, RESPONSE_FIELD_ENVIRONMENT, RESPONSE_FIELD_TRANSACTION_SIGNATURE, RESPONSE_FIELD_SIGNED_FIELDS, RESPONSE_FIELD_DECISION, CUSTOM_FIELD_RETURN_REDIRECT_URL, RESPONSE_FIELD_REQUEST_ID, RESPONSE_FIELD_RECONCILIATION_ID, RESPONSE_FIELD_TIMESTAMP);
    }

    public static class CyberSourcePOSTBackServlet
    extends HttpServlet {
        private final PaymentGatewayRequestLogMessageBuilder logMessageBuilder = new PaymentGatewayRequestLogMessageBuilder("CyberSource POSTback").withSelectedParameters(CyberSourcePlugin.getParametersToLog());

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.debugLogRequest(request);
            Map<String, String> parameters = this.normalizeParameterValues(request.getParameterMap());
            String pathInfo = request.getPathInfo().toLowerCase();
            if (pathInfo.startsWith(CyberSourcePlugin.PATH_TRANSACTION)) {
                this.getCyberSourcePlugin().processTransaction(parameters);
            } else if (pathInfo.startsWith(CyberSourcePlugin.PATH_USER)) {
                String returnRedirectURL = this.getCyberSourcePlugin().processUserReturn(parameters);
                GatewayUtils.LogHelper.logDebug(logger, "Redirecting to: " + returnRedirectURL);
                response.sendRedirect(returnRedirectURL);
            } else {
                response.setStatus(404);
            }
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.debugLogRequest(request);
            response.getWriter().write("<html><body><h1>The CyberSource POSTback URL is accessible as of " + String.valueOf(new Date()) + "</h1><p>Remember to ensure that the URL is externally accessible (i.e. that the CyberSource server has access)</p></body></html>");
        }

        private Map<String, String> normalizeParameterValues(Map<String, String[]> parameters) {
            HashMap<String, String> normalizedParameters = new HashMap<String, String>(parameters.size());
            for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                normalizedParameters.put(entry.getKey(), StringUtils.join((Object[])entry.getValue(), (String)","));
            }
            return normalizedParameters;
        }

        private CyberSourcePlugin getCyberSourcePlugin() {
            return (CyberSourcePlugin)PluginManager.getInstance().getPluginByClass(CyberSourcePlugin.class);
        }

        private void debugLogRequest(HttpServletRequest request) {
            GatewayUtils.LogHelper.logDebug(logger, this.buildLogMessageFromRequest(request));
        }

        String buildLogMessageFromRequest(HttpServletRequest request) {
            return this.logMessageBuilder.buildFrom(request);
        }
    }
}

