/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cybersource;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cybersource.CyberSourcePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.ConfigManager;
import biz.papercut.pcng.service.NotificationUtils;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CyberSourceRedirect
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(CyberSourceRedirect.class);
    public static final String PAGE_NAME = "CyberSourceRedirect";

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract double getAmount();

    public abstract void setAmount(double var1);

    public abstract String getOrderId();

    public abstract void setOrderId(String var1);

    public abstract String getTimestamp();

    public abstract void setTimestamp(String var1);

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public void activate(IRequestCycle cycle, User user, double amount) {
        this.setUser(user);
        this.setAmount(amount);
        String orderId = this.getCyberSourcePlugin().createNewOrder(user.getUserName(), amount);
        this.setOrderId(orderId);
        logger.debug("Created order {} for user {}. Redirecting user to CyberSource HOP.", (Object)orderId, (Object)user.getUserName());
        cycle.activate((IPage)this);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            throw new PageRedirectException("ExtnCyberSource");
        }
        this.setTimestamp(String.valueOf(System.currentTimeMillis()));
    }

    public String getHostedOrderPageURL() {
        try {
            return this.getCyberSourcePlugin().getHostedOrderPageURL().toString();
        }
        catch (Exception e) {
            String errorMsg = "Unable to parse hosted order page URL: " + e.getMessage();
            logger.error(errorMsg, (Throwable)e);
            this.returnToAddCreditPageAndLogError(errorMsg);
            throw new RuntimeException();
        }
    }

    public String getFingerprintSequence() {
        return this.getOrderId();
    }

    public String getRequestIP() {
        return this.getRequest().getRemoteAddr();
    }

    public String getFormattedAmount() {
        return GatewayUtils.formatNumber(this.getAmount(), 2, Locale.US, false);
    }

    public String getTransactionType() {
        return "sale";
    }

    public String getCurrency() {
        return this.getCyberSourcePlugin().getCurrency();
    }

    public String getMerchantId() {
        return this.getCyberSourcePlugin().getMerchantId();
    }

    public String getSerialNumber() {
        return this.getCyberSourcePlugin().getSerialNumber();
    }

    public String getSignature() {
        try {
            return this.getCyberSourcePlugin().getTransactionSignature(this.getFormattedAmount(), this.getCurrency(), this.getTimestamp());
        }
        catch (Exception e) {
            String errorMsg = "Unable to generate CyberSource signature: " + e.getMessage();
            logger.error(errorMsg, (Throwable)e);
            this.returnToAddCreditPageAndLogError(errorMsg);
            throw new RuntimeException();
        }
    }

    public String getPaymentDescription() {
        return this.getCyberSourcePlugin().getPaymentDescription();
    }

    public String getOrderNumberFieldName() {
        return "orderNumber";
    }

    public String getUserNameFieldName() {
        return "billTo_customerID";
    }

    public String getUserEmailAddress() {
        return NotificationUtils.getUserEmailAddress((ConfigManager)this.getConfigManager(), (User)this.getUser());
    }

    public String getReturnRedirectURLFieldName() {
        return "return-redirect-url";
    }

    public String getReturnRedirectURL() {
        HttpServletRequest r = this.getRequest();
        String returnRedirectURL = r.getScheme() + "://" + r.getServerName() + ":" + r.getServerPort() + "/app?service=external/ExtnCyberSource&order-id=" + this.getOrderId();
        logger.debug("Building redirect URL: {}", (Object)returnRedirectURL);
        return returnRedirectURL;
    }

    public boolean isIgnoreAvs() {
        return this.getCyberSourcePlugin().isIgnoreAvs();
    }

    protected void returnToAddCreditPageAndLogError(String errorMsg) {
        EventLog.getInstance().logEvent(errorMsg);
        this.addErrorMessage(this.getCyberSourcePlugin().getUserErrorMessage());
        this.getRequestCycle().activate("ExtnCyberSource");
    }

    private CyberSourcePlugin getCyberSourcePlugin() {
        return (CyberSourcePlugin)PluginManager.getInstance().getPluginByClass(CyberSourcePlugin.class);
    }
}

