/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cybersource;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.BasePaymentGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cybersource.CyberSourcePlugin;
import biz.papercut.pcng.ext.paymentgateway.cybersource.CyberSourceRedirect;
import biz.papercut.pcng.ext.paymentgateway.pages.BasePaymentGatewayPage;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnCyberSource
extends BasePaymentGatewayPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(ExtnCyberSource.class);
    public static final String PAGE_NAME = "ExtnCyberSource";

    public abstract void setShowReceipt(boolean var1);

    public abstract void setReceiptOrderId(String var1);

    public abstract void setReceiptAmount(String var1);

    public abstract void setReceiptRequestId(String var1);

    public abstract void setReceiptReconciliationId(String var1);

    public abstract void setReceiptTimestamp(String var1);

    @Override
    public abstract AccountManager getAccountManager();

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(this.createAmountsModel());
        }
        if (!this.getRequestCycle().isRewinding()) {
            String configError;
            if (!this.getCyberSourcePlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = this.getCyberSourcePlugin().getIsConfigured()) != null) {
                this.addWarningMessage(configError);
                logger.error(configError);
            }
        }
    }

    public void formSubmit(IRequestCycle cycle) {
        Double amount = this.getAmount();
        if (amount == null || amount <= 0.0) {
            this.addErrorMessage("Please select an amount to add");
            return;
        }
        CyberSourceRedirect redirectPage = (CyberSourceRedirect)cycle.getPage("CyberSourceRedirect");
        redirectPage.activate(cycle, this.getUser(), amount);
    }

    public void redirectToSummaryPage(IRequestCycle cycle) {
        cycle.activate("UserSummary");
    }

    @Override
    public BasePaymentGatewayPlugin getPlugin() {
        return this.getCyberSourcePlugin();
    }

    public void activateExternalPage(Object[] arguments, IRequestCycle cycle) {
        HttpServletRequest r = this.getRequest();
        String success = r.getParameter("success");
        String message = r.getParameter("message");
        if (Boolean.parseBoolean(success)) {
            Object statusMessage = "Funds have been added to your account";
            if (StringUtils.isNotBlank((String)message)) {
                statusMessage = (String)statusMessage + ". " + message;
            }
            this.addStatusMessage((String)statusMessage);
            this.setShowReceipt(true);
            this.setReceiptOrderId(r.getParameter("orderNumber"));
            String receiptAmount = r.getParameter("orderAmount");
            try {
                double ra = Double.parseDouble(receiptAmount);
                this.setReceiptAmount(this.formatCost(ra));
            }
            catch (Exception e) {
                this.setReceiptAmount(receiptAmount);
            }
            this.setReceiptRequestId(r.getParameter("requestID"));
            this.setReceiptReconciliationId(r.getParameter("reconciliationID"));
            this.setReceiptTimestamp(r.getParameter("ccAuthReply_authorizedDateTime"));
        } else {
            this.addErrorMessage(message);
        }
    }

    public String getReceiptHeader() {
        return this.getCyberSourcePlugin().getReceiptHeader();
    }

    public String getReceiptPaymentDescription() {
        return this.getCyberSourcePlugin().getPaymentDescription();
    }

    private CyberSourcePlugin getCyberSourcePlugin() {
        return (CyberSourcePlugin)PluginManager.getInstance().getPluginByClass(CyberSourcePlugin.class);
    }
}

