/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cybersource.sa;

import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.BasePaymentGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.ParameterMapValuesStringBuilder;
import biz.papercut.pcng.ext.paymentgateway.PaymentGatewayRequestLogMessageBuilder;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.WebServerPlugin;
import biz.papercut.pcng.service.LicenseManager;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyberSourceSAPlugin
extends BasePaymentGatewayPlugin
implements WebServerPlugin {
    protected static final Logger logger = LoggerFactory.getLogger(CyberSourceSAPlugin.class);
    public static final String POSTBACK_URL_PATH = "/rpc/gateway/cybersource-sa";
    public static final String CONFIG_PREFIX = "cybersource-sa.";
    public static final String CONFIG_PROFILE_ID = "profile-id";
    @AESProperty
    public static final String CONFIG_ACCESS_KEY = "cybersource-sa.access-key";
    @AESProperty
    public static final String CONFIG_SECRET_KEY = "cybersource-sa.secret-key";
    public static final String CONFIG_SITE_LOCALE = "site-locale";
    public static final String CONFIG_CURRENCY = "currency";
    public static final String CONFIG_IGNORE_AVS = "ignore-avs";
    public static final String CONFIG_PAYMENT_DESCRIPTION = "payment-description";
    public static final String CONFIG_SITE_URL = "site-url";
    public static final String CONFIG_RECEIPT_HEADER = "receipt-header";
    public static final String CONFIG_POSTBACK_ALLOWED_IP = "postback-allowed-ip";
    public static final String REQUEST_FIELD_PREFIX = "req_";
    public static final String FIELD_VALUE_TRANSACTION_TYPE_SALE = "sale";
    public static final String FIELD_VALUE_DECISION_ACCEPT = "accept";
    public static final String FIELD_USER_NAME = "bill_to_company_name";
    public static final int SIZE_FIELD_USER_NAME = 40;
    public static final String FIELD_ORDER_ID = "reference_number";
    public static final String FIELD_TRANSACTION_UUID = "transaction_uuid";
    public static final int SIZE_FIELD_TRANSACTION_UUID = 50;
    public static final String FIELD_RETURN_REDIRECT_URL = "merchant_secure_data4";
    public static final String FIELD_SIGNED_FIELD_NAMES = "signed_field_names";
    public static final String FIELD_CURRENCY = "currency";
    public static final String FIELD_ORDER_AMOUNT = "amount";
    public static final String FIELD_TIMESTAMP = "signed_date_time";
    public static final String RESPONSE_FIELD_USER_NAME = "req_bill_to_company_name";
    public static final String RESPONSE_FIELD_ORDER_ID = "req_reference_number";
    public static final String RESPONSE_FIELD_RETURN_REDIRECT_URL = "req_merchant_secure_data4";
    public static final String RESPONSE_FIELD_SIGNED_FIELD_NAMES = "signed_field_names";
    public static final String RESPONSE_FIELD_SIGNATURE = "signature";
    public static final String RESPONSE_FIELD_ORDER_AMOUNT = "req_amount";
    public static final String RESPONSE_FIELD_DECISION = "decision";
    public static final String RESPONSE_FIELD_REQUEST_ID = "transaction_id";
    public static final String RESPONSE_FIELD_RECONCILIATION_ID = "auth_trans_ref_no";
    public static final String RESPONSE_FIELD_TIMESTAMP = "signed_date_time";
    private static final String PATH_TRANSACTION = "/transaction";
    private static final String PATH_USER = "/user";
    private static final String ALGORITHM_NAME_HMAC_SHA256 = "HmacSHA256";
    private static final List<String> PAGES = List.of("ExtnCyberSourceSA");
    private static final String UNDERSCORE_PLACEHOLDER = "@";
    Map<String, SignedValue> signedFields = new HashMap<String, SignedValue>(){
        {
            this.put("access_key", () -> CyberSourceSAPlugin.this.getAccessKey());
            this.put("profile_id", () -> CyberSourceSAPlugin.this.getProfileId());
            this.put(CyberSourceSAPlugin.FIELD_ORDER_ID, null);
            this.put("transaction_type", () -> CyberSourceSAPlugin.FIELD_VALUE_TRANSACTION_TYPE_SALE);
            this.put("currency", null);
            this.put(CyberSourceSAPlugin.FIELD_ORDER_AMOUNT, null);
            this.put("locale", () -> CyberSourceSAPlugin.this.getSiteLocale());
            this.put(CyberSourceSAPlugin.FIELD_TRANSACTION_UUID, null);
            this.put("item_0_name", () -> CyberSourceSAPlugin.this.getPaymentDescription());
            this.put(CyberSourceSAPlugin.FIELD_USER_NAME, null);
            this.put("ignore_avs", () -> CyberSourceSAPlugin.this.isIgnoreAvs() ? "true" : "false");
            this.put("signed_field_names", () -> CyberSourceSAPlugin.this.getSignedFieldNames());
            this.put("unsigned_field_names", () -> "");
            this.put("signed_date_time", null);
            this.put(CyberSourceSAPlugin.FIELD_RETURN_REDIRECT_URL, null);
        }
    };

    @Override
    public String getConfigPrefix() {
        return CONFIG_PREFIX;
    }

    @Override
    public boolean isLicensed() {
        LicenseManager lm = (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
        return GatewayUtils.isLicensed(lm, "payment-gateways-cybersource-sa");
    }

    public String createNewOrder(String username, double amount) {
        return this.getCreditCardGatewayPlugin().createNewOrder(username, amount, 50);
    }

    @CheckForNull
    public String getIsConfigured() {
        String errorSuffix = "  Please check the payment gateway config file.";
        try {
            Mac.getInstance(ALGORITHM_NAME_HMAC_SHA256);
        }
        catch (NoSuchAlgorithmException nsae) {
            String error = "Required cryptography functionality is not present.  Contact support for assistance.";
            GatewayUtils.LogHelper.logError(logger, error, nsae);
            return error;
        }
        if (this.getProfileId() == null) {
            GatewayUtils.LogHelper.logError(logger, "Profile id not provided.");
            return "Profile id not provided." + errorSuffix;
        }
        if (this.getSecretKey() == null) {
            GatewayUtils.LogHelper.logError(logger, "Secret key not provided.");
            return "Secret key not provided." + errorSuffix;
        }
        if (this.getAccessKey() == null) {
            GatewayUtils.LogHelper.logError(logger, "Access key not provided.");
            return "Access key not provided." + errorSuffix;
        }
        if (this.getSiteLocale() == null) {
            GatewayUtils.LogHelper.logError(logger, "Site locale not provided.");
            return "Site locale not provided." + errorSuffix;
        }
        if (this.getCurrency() == null) {
            GatewayUtils.LogHelper.logError(logger, "Currency not provided.");
            return "Currency not provided." + errorSuffix;
        }
        if (this.getAllowedAmounts() == null) {
            GatewayUtils.LogHelper.logError(logger, "Must specify at least one allowed payment amount.");
            return "Must specify at least one allowed payment amount." + errorSuffix;
        }
        URL siteURL = null;
        try {
            siteURL = this.getSiteURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (siteURL == null) {
            GatewayUtils.LogHelper.logError(logger, "Invalid site URL: " + this.getGatewayConfig().getString("cybersource-sa.site-url") + ".");
            return "Invalid site URL." + errorSuffix;
        }
        return null;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return PAGES;
        }
        return null;
    }

    public void preStartupHook(WebServerPlugin.WebServer server) {
        if (!this.isPluginEnabled()) {
            return;
        }
        server.addServlet(CyberSourceSAPOSTBackServlet.class, "/rpc/gateway/cybersource-sa/*");
    }

    public String getProfileId() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString("cybersource-sa.profile-id"));
    }

    public String getSecretKey() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_SECRET_KEY));
    }

    public String getAccessKey() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_ACCESS_KEY));
    }

    public String getSiteLocale() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString("cybersource-sa.site-locale"));
    }

    public String getCurrency() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString("cybersource-sa.currency"));
    }

    public String getPaymentDescription() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString("cybersource-sa.payment-description"));
    }

    public URL getSiteURL() throws MalformedURLException {
        return this.getGatewayConfig().getURL("cybersource-sa.site-url");
    }

    public String getReceiptHeader() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString("cybersource-sa.receipt-header"));
    }

    public static String getCyberSourceValidUserName(String origUserName) {
        return CyberSourceSAPlugin.removeRestoreUnderscores(origUserName, false);
    }

    public static String restoreOriginalUserName(String cyberSourceValidUserName) {
        return CyberSourceSAPlugin.removeRestoreUnderscores(cyberSourceValidUserName, true);
    }

    private static String removeRestoreUnderscores(String inputUserName, boolean restoreUnderscore) {
        String convertedUserName = inputUserName;
        String removedChar = "_";
        String insertedChar = UNDERSCORE_PLACEHOLDER;
        if (restoreUnderscore) {
            removedChar = UNDERSCORE_PLACEHOLDER;
            insertedChar = "_";
        }
        if (inputUserName.contains(insertedChar)) {
            GatewayUtils.LogHelper.logError(logger, "Username " + inputUserName + " contains unexpected char " + insertedChar + ". Cannot convert chars unsupported by CyberSource SA.");
        } else {
            convertedUserName = inputUserName.replaceAll(removedChar, insertedChar);
            if (inputUserName.compareTo(convertedUserName) != 0) {
                if (restoreUnderscore) {
                    GatewayUtils.LogHelper.logDebug(logger, "Restored unsupported chars to username. Before: " + inputUserName + " , After: " + convertedUserName);
                } else {
                    GatewayUtils.LogHelper.logDebug(logger, "Removed unsupported chars from username. Before: " + inputUserName + " , After: " + convertedUserName);
                }
            }
        }
        return convertedUserName;
    }

    @CheckForNull
    public String getTransactionSignature(String orderId, String userName, String currency, String amount, String timestamp, String redirectUrl) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, SignedValue> entry : this.signedFields.entrySet()) {
            String key = entry.getKey();
            SignedValue value = entry.getValue();
            if (!sb.isEmpty()) {
                sb.append(",");
            }
            sb.append(key).append("=");
            if (value != null) {
                sb.append(value.run());
                continue;
            }
            if (key.equals(FIELD_ORDER_ID) || key.equals(FIELD_TRANSACTION_UUID)) {
                sb.append(orderId);
                continue;
            }
            if (key.equals("currency")) {
                sb.append(currency);
                continue;
            }
            if (key.equals(FIELD_ORDER_AMOUNT)) {
                sb.append(amount);
                continue;
            }
            if (key.equals(FIELD_USER_NAME)) {
                sb.append(StringUtils.left((String)userName, (int)40));
                continue;
            }
            if (key.equals("signed_date_time")) {
                sb.append(timestamp);
                continue;
            }
            if (!key.equals(FIELD_RETURN_REDIRECT_URL)) continue;
            sb.append(redirectUrl);
        }
        return this.digest(sb.toString());
    }

    public String getSignedFieldNames() {
        return StringUtils.join(this.signedFields.keySet(), (String)",");
    }

    public boolean isIgnoreAvs() {
        return BooleanUtils.isTrue((Boolean)this.getGatewayConfig().getBoolean("cybersource-sa.ignore-avs"));
    }

    @CheckForNull
    private String digest(String data) {
        String secretKey = this.getSecretKey();
        String publicDigest = null;
        try {
            Mac sha256Mac = Mac.getInstance(ALGORITHM_NAME_HMAC_SHA256);
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getBytes(), ALGORITHM_NAME_HMAC_SHA256);
            sha256Mac.init(secretKeySpec);
            byte[] publicBytes = sha256Mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
            publicDigest = new String(Base64.encodeBase64((byte[])publicBytes));
            publicDigest = publicDigest.replaceAll("[\r\n\t]", "");
        }
        catch (Exception e) {
            GatewayUtils.LogHelper.logError(logger, "Unable to calculate signature: " + e.getMessage());
        }
        return publicDigest;
    }

    protected void processTransaction(Map<String, String> parameters) {
        this.verifyAndConfirmOrder(parameters);
    }

    protected String processUserReturn(Map<String, String> parameters) {
        CreditCardGatewayPlugin.OrderResponse response = this.verifyAndConfirmOrder(parameters);
        StringBuilder url = new StringBuilder();
        url.append(parameters.get(RESPONSE_FIELD_RETURN_REDIRECT_URL));
        url.append("&success=").append(response.isSuccess());
        if (StringUtils.isNotBlank((String)response.getMessage())) {
            url.append("&message=").append(response.getMessage());
        }
        url.append("&").append(RESPONSE_FIELD_ORDER_ID);
        url.append("=").append(parameters.get(RESPONSE_FIELD_ORDER_ID));
        url.append("&").append(RESPONSE_FIELD_ORDER_AMOUNT);
        url.append("=").append(parameters.get(RESPONSE_FIELD_ORDER_AMOUNT));
        url.append("&").append(RESPONSE_FIELD_REQUEST_ID);
        url.append("=").append(parameters.get(RESPONSE_FIELD_REQUEST_ID));
        url.append("&").append(RESPONSE_FIELD_RECONCILIATION_ID);
        url.append("=").append(parameters.get(RESPONSE_FIELD_RECONCILIATION_ID));
        url.append("&").append("signed_date_time");
        url.append("=").append(parameters.get("signed_date_time"));
        try {
            new URL(url.toString());
            return url.toString();
        }
        catch (Exception e) {
            GatewayUtils.LogHelper.logError(logger, "Could not return user to correct page as URL is invalid: " + String.valueOf(url) + ". Sending user to login page.");
            return "/";
        }
    }

    private CreditCardGatewayPlugin.OrderResponse verifyAndConfirmOrder(Map<String, String> parameters) {
        CreditCardGatewayPlugin.OrderResponse response = null;
        String userName = CyberSourceSAPlugin.restoreOriginalUserName(parameters.get(RESPONSE_FIELD_USER_NAME));
        String orderId = parameters.get(RESPONSE_FIELD_ORDER_ID);
        String amountParam = parameters.get(RESPONSE_FIELD_ORDER_AMOUNT);
        String logSuffix = " User: " + userName + ", payment amount: " + amountParam;
        String fullDetails = "CyberSource SA reported transaction details: " + CyberSourceSAPlugin.buildStringFromParameters(parameters);
        if (!this.verifyTransaction(parameters)) {
            GatewayUtils.LogHelper.logError(logger, "CyberSource SA order " + orderId + " failed validation and will not be confirmed." + logSuffix, null, this.getApplicationLogManager());
            GatewayUtils.LogHelper.logError(logger, fullDetails);
            response = new CreditCardGatewayPlugin.OrderResponse(false, "Order failed validation.");
        }
        if (response == null && !this.isTransactionApproved(parameters)) {
            GatewayUtils.LogHelper.logInfo(logger, "Order " + orderId + " was declined by CyberSource SA." + logSuffix);
            response = new CreditCardGatewayPlugin.OrderResponse(false, "Order declined by processor.");
        }
        if (response == null) {
            Double amount = null;
            try {
                amount = Double.valueOf(amountParam);
            }
            catch (NumberFormatException nfe) {
                GatewayUtils.LogHelper.logError(logger, "CyberSource SA order " + orderId + " has invalid transaction amount." + logSuffix, null, this.getApplicationLogManager());
                response = new CreditCardGatewayPlugin.OrderResponse(false, "Invalid order amount: " + amountParam);
            }
            if (amount != null) {
                response = this.getCreditCardGatewayPlugin().confirmOrderReentrant(orderId, amount);
                if (response.isAlreadyProcessed()) {
                    GatewayUtils.LogHelper.logDebug(logger, "Order " + orderId + " was already processed.");
                } else if (response.isSuccess()) {
                    GatewayUtils.LogHelper.logInfo(logger, "Order " + orderId + " confirmed.");
                } else {
                    GatewayUtils.LogHelper.logError(logger, "Could not confirm CyberSource SA order " + orderId + ", message: " + response.getMessage() + ". Manual reconciliation may be required." + logSuffix, null, this.getApplicationLogManager());
                    GatewayUtils.LogHelper.logError(logger, fullDetails);
                }
            }
        }
        return response;
    }

    private boolean verifyTransaction(Map<String, String> parameters) {
        String transactionSignatureCalculated;
        String transactionSignature = parameters.get(RESPONSE_FIELD_SIGNATURE);
        String transactionSignatureFields = parameters.get("signed_field_names");
        if (transactionSignature == null || transactionSignatureFields == null) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (String field : StringUtils.split((String)transactionSignatureFields, (String)",")) {
            if (!sb.isEmpty()) {
                sb.append(",");
            }
            sb.append(field).append("=").append(parameters.get(field));
        }
        try {
            transactionSignatureCalculated = this.digest(sb.toString());
        }
        catch (Exception e) {
            GatewayUtils.LogHelper.logError(logger, "Unable to calculate signature: " + e.getMessage(), e, null);
            return false;
        }
        if (transactionSignatureCalculated == null) {
            GatewayUtils.LogHelper.logError(logger, "Unable to calculate signature.");
            return false;
        }
        if (!transactionSignatureCalculated.equals(transactionSignature)) {
            GatewayUtils.LogHelper.logError(logger, "Transaction signature does not validate (provided: " + transactionSignature + ", calculated: " + transactionSignatureCalculated + "). Order will not be finalized.");
            return false;
        }
        return true;
    }

    private boolean isTransactionApproved(Map<String, String> parameters) {
        String decision = parameters.get(RESPONSE_FIELD_DECISION);
        return decision != null && decision.equalsIgnoreCase(FIELD_VALUE_DECISION_ACCEPT);
    }

    private static String buildStringFromParameters(Map<String, ?> parameterMap) {
        ParameterMapValuesStringBuilder stringBuilder = new ParameterMapValuesStringBuilder(parameterMap);
        CyberSourceSAPlugin.getParametersToLog().forEach(stringBuilder::add);
        return stringBuilder.build();
    }

    private static List<String> getParametersToLog() {
        return List.of(RESPONSE_FIELD_USER_NAME, RESPONSE_FIELD_ORDER_ID, RESPONSE_FIELD_ORDER_AMOUNT, RESPONSE_FIELD_SIGNATURE, "signed_field_names", RESPONSE_FIELD_DECISION, RESPONSE_FIELD_RETURN_REDIRECT_URL, RESPONSE_FIELD_REQUEST_ID, RESPONSE_FIELD_RECONCILIATION_ID, "signed_date_time");
    }

    public static class CyberSourceSAPOSTBackServlet
    extends HttpServlet {
        private final PaymentGatewayRequestLogMessageBuilder logMessageBuilder = new PaymentGatewayRequestLogMessageBuilder("CyberSource SA POSTback").withSelectedParameters(CyberSourceSAPlugin.getParametersToLog());

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.debugLogRequest(request);
            Map<String, String> parameters = this.normalizeParameterValues(request.getParameterMap());
            String pathInfo = request.getPathInfo().toLowerCase();
            if (pathInfo.startsWith(CyberSourceSAPlugin.PATH_TRANSACTION)) {
                this.getCyberSourceSAPlugin().processTransaction(parameters);
            } else if (pathInfo.startsWith(CyberSourceSAPlugin.PATH_USER)) {
                String returnRedirectURL = this.getCyberSourceSAPlugin().processUserReturn(parameters);
                GatewayUtils.LogHelper.logDebug(logger, "Redirecting to: " + returnRedirectURL);
                response.sendRedirect(returnRedirectURL);
            } else {
                response.setStatus(404);
            }
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.debugLogRequest(request);
            response.getWriter().write("<html><body><h1>The CyberSource SA POSTback URL is accessible as of " + String.valueOf(new Date()) + "</h1><p>Remember to ensure that the URL is externally accessible (i.e. that the CyberSource SA server has access)</p></body></html>");
        }

        private Map<String, String> normalizeParameterValues(Map<String, String[]> parameters) {
            HashMap<String, String> normalizedParameters = new HashMap<String, String>(parameters.size());
            for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                normalizedParameters.put(entry.getKey(), StringUtils.join((Object[])entry.getValue(), (String)","));
            }
            return normalizedParameters;
        }

        private CyberSourceSAPlugin getCyberSourceSAPlugin() {
            return (CyberSourceSAPlugin)PluginManager.getInstance().getPluginByClass(CyberSourceSAPlugin.class);
        }

        private void debugLogRequest(HttpServletRequest request) {
            GatewayUtils.LogHelper.logDebug(logger, this.buildLogMessageFromRequest(request));
        }

        String buildLogMessageFromRequest(HttpServletRequest request) {
            return this.logMessageBuilder.buildFrom(request);
        }
    }

    static interface SignedValue {
        public String run();
    }
}

