/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cybersource.sa;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cybersource.sa.CyberSourceSAPlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.ConfigManager;
import biz.papercut.pcng.service.NotificationUtils;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CyberSourceSARedirect
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(CyberSourceSARedirect.class);
    public static final String PAGE_NAME = "CyberSourceSARedirect";

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract double getAmount();

    public abstract void setAmount(double var1);

    public abstract String getOrderId();

    public abstract void setOrderId(String var1);

    public abstract String getTimestamp();

    public abstract void setTimestamp(String var1);

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public void activate(IRequestCycle cycle, User user, double amount) {
        this.setUser(user);
        this.setAmount(amount);
        String orderId = this.getCyberSourceSAPlugin().createNewOrder(user.getUserName(), amount);
        this.setOrderId(orderId);
        logger.debug("Created order {} for user {}. Redirecting user to CyberSource SA.", (Object)orderId, (Object)user.getUserName());
        cycle.activate((IPage)this);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            throw new PageRedirectException("ExtnCyberSourceSA");
        }
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(tz);
        this.setTimestamp(df.format(System.currentTimeMillis()));
    }

    public String getSiteURL() {
        try {
            return this.getCyberSourceSAPlugin().getSiteURL().toString();
        }
        catch (Exception e) {
            String errorMsg = "Unable to parse site URL: " + e.getMessage();
            logger.error(errorMsg, (Throwable)e);
            this.returnToAddCreditPageAndLogError(errorMsg);
            throw new RuntimeException();
        }
    }

    public String getFingerprintSequence() {
        return this.getOrderId();
    }

    public String getRequestIP() {
        return this.getRequest().getRemoteAddr();
    }

    public String getFormattedAmount() {
        return GatewayUtils.formatNumber(this.getAmount(), 2, Locale.US, false);
    }

    public String getTransactionType() {
        return "sale";
    }

    public String getCurrency() {
        return this.getCyberSourceSAPlugin().getCurrency();
    }

    public String getProfileId() {
        return this.getCyberSourceSAPlugin().getProfileId();
    }

    public String getAccessKey() {
        return this.getCyberSourceSAPlugin().getAccessKey();
    }

    public String getSiteLocale() {
        return this.getCyberSourceSAPlugin().getSiteLocale();
    }

    public String getSignature() {
        try {
            this.getCyberSourceSAPlugin();
            return this.getCyberSourceSAPlugin().getTransactionSignature(this.getOrderId(), CyberSourceSAPlugin.getCyberSourceValidUserName(this.getUser().getUserName()), this.getCurrency(), this.getFormattedAmount(), this.getTimestamp(), this.getReturnRedirectURL());
        }
        catch (Exception e) {
            String errorMsg = "Unable to generate CyberSource SA signature: " + e.getMessage();
            logger.error(errorMsg, (Throwable)e);
            this.returnToAddCreditPageAndLogError(errorMsg);
            throw new RuntimeException();
        }
    }

    public String getPaymentDescription() {
        return this.getCyberSourceSAPlugin().getPaymentDescription();
    }

    public String getTruncatedUserName() {
        return StringUtils.left((String)CyberSourceSAPlugin.getCyberSourceValidUserName(this.getUser().getUserName()), (int)40);
    }

    public String getUserEmailAddress() {
        return NotificationUtils.getUserEmailAddress((ConfigManager)this.getConfigManager(), (User)this.getUser());
    }

    public String getSignedFieldNames() {
        return this.getCyberSourceSAPlugin().getSignedFieldNames();
    }

    public String getReturnRedirectURL() {
        HttpServletRequest r = this.getRequest();
        String returnRedirectURL = r.getScheme() + "://" + r.getServerName() + ":" + r.getServerPort() + "/app?service=external/ExtnCyberSourceSA&order-id=" + this.getOrderId();
        logger.debug("Building redirect URL: {}", (Object)returnRedirectURL);
        return returnRedirectURL;
    }

    public boolean isIgnoreAvs() {
        return this.getCyberSourceSAPlugin().isIgnoreAvs();
    }

    protected void returnToAddCreditPageAndLogError(String errorMsg) {
        EventLog.getInstance().logEvent(errorMsg);
        this.addErrorMessage(this.getCyberSourceSAPlugin().getUserErrorMessage());
        this.getRequestCycle().activate("ExtnCyberSourceSA");
    }

    private CyberSourceSAPlugin getCyberSourceSAPlugin() {
        return (CyberSourceSAPlugin)PluginManager.getInstance().getPluginByClass(CyberSourceSAPlugin.class);
    }
}

