/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.heartland;

import biz.papercut.pcng.ext.paymentgateway.heartland.ProtocolException;
import biz.papercut.pcng.util.ObjectUtils;

final class DSNResponse {
    private final boolean _success;
    private final int _status;
    private final int _dsn;

    private DSNResponse(boolean success, int status, int dsn) {
        this._success = success;
        this._status = status;
        this._dsn = dsn;
    }

    public boolean isSuccess() {
        return this._success;
    }

    public int getStatus() {
        return this._status;
    }

    public int getDSN() {
        return this._dsn;
    }

    public static DSNResponse valueOf(String message) throws ProtocolException {
        boolean success;
        if (message.charAt(0) != '\u0002') {
            throw new ProtocolException("Missing start of text");
        }
        String[] split = message.split("\u001c|\u0002|\u0003");
        if (split.length != 4) {
            throw new ProtocolException("Wrong number of fields in response (expected 4 but got " + split.length + ")");
        }
        String resultStr = split[1];
        if (resultStr.charAt(0) == 'T') {
            success = true;
        } else if (resultStr.charAt(0) == 'F') {
            success = false;
        } else {
            throw new ProtocolException("Incorrect value for success field: " + resultStr);
        }
        String statusStr = split[2];
        int status = 0;
        try {
            status = Integer.parseInt(statusStr);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Non integer for status field: " + statusStr);
        }
        String dsnStr = split[3];
        int dsn = 0;
        try {
            dsn = Integer.parseInt(dsnStr);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Non integer for dsn field: " + dsnStr);
        }
        if (message.charAt(message.length() - 1) != '\u0003') {
            throw new ProtocolException("Missing end of text field");
        }
        return new DSNResponse(success, status, dsn);
    }

    public String toString() {
        return ObjectUtils.createToStringBuilder((Object)this).append("success", this._success).append("status", this._status).append("dsn", this._dsn).toString();
    }
}

