/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.heartland;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandPlugin;
import biz.papercut.pcng.ext.paymentgateway.heartland.TransactionResponse;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.CreditSourceManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.ValidationDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnHeartland
extends BasePaperCutPage
implements PageRenderListener {
    protected static final Logger logger = LoggerFactory.getLogger(ExtnHeartland.class);

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract Double getHeartlandBalance();

    public abstract void setHeartlandBalance(Double var1);

    public abstract Double getAmount();

    public abstract void setAmount(Double var1);

    @Nullable
    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract AccountManager getAccountManager();

    public abstract CreditSourceManager getCreditSourceManager();

    public abstract UserManager getUserManager();

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public String getPageTitle() {
        String title = ExtnHeartland.getHeartlandPlugin().getManualTransferPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public String getHeading() {
        return ExtnHeartland.getHeartlandPlugin().getManualTransferPageHeading();
    }

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public void pageBeginRender(PageEvent event) {
        this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(GatewayUtils.createAllowedAmountsModel("heartland.manual-transfer.allowed-amounts", (BasePaperCutPage)this));
        }
        if (!this.getRequestCycle().isRewinding()) {
            String configError;
            if (!ExtnHeartland.getHeartlandPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = ExtnHeartland.getHeartlandPlugin().getIsConfigured()) != null) {
                this.addWarningMessage(configError);
                logger.error(configError);
                return;
            }
            TransactionResponse response = ExtnHeartland.getHeartlandPlugin().getBalance(this.getUser());
            if (response.isSuccess()) {
                this.setHeartlandBalance(response.getBalance());
            } else {
                if (this.getErrorMessages().isEmpty()) {
                    this.addErrorMessage(ExtnHeartland.getHeartlandPlugin().getManualTransferUserErrorMessage() + " (Error retrieving Heartland balance: " + response.getMessage() + ")");
                }
                this.setHeartlandBalance(null);
            }
        }
    }

    public void doTransaction(IRequestCycle cycle) {
        double totalUserBalance;
        ValidationDelegate delegate = (ValidationDelegate)this.getBeans().getBean("delegate");
        if (delegate.getHasErrors()) {
            this.addErrorMessage(delegate.getFirstError().toString());
            return;
        }
        if (!this.isAccessibleByUser()) {
            this.addErrorMessage("You do not have permission to access this feature.");
            return;
        }
        if (this.getAmount() == null || this.getAmount() <= 0.0) {
            this.addErrorMessage("Please select the amount to transfer to your account.");
            return;
        }
        double amount = this.getAmount();
        User user = this.getUser();
        boolean success = false;
        Object errorSuffix = "";
        Double accumulationLimit = ExtnHeartland.getHeartlandPlugin().getOnlyAllowAccumulationUpTo();
        if (accumulationLimit != null && (totalUserBalance = GatewayUtils.getUserBalance(this.getAccountManager(), user)) + amount > accumulationLimit) {
            this.addErrorMessage(ExtnHeartland.getHeartlandPlugin().getOnlyAllowAccumulationUpToMessage());
            return;
        }
        try {
            TransactionResponse response = ExtnHeartland.getHeartlandPlugin().performDebit(this.getUser(), amount);
            if (response.isSuccess()) {
                String txnComment = ExtnHeartland.getHeartlandPlugin().getManualTransferTransactionComment();
                GatewayUtils.addCreditToUser(this.getAccountManager(), this.getCreditSourceManager(), this.getUser(), amount, txnComment);
                this.addStatusMessage(this.formatBalance(amount) + " was successfully added to your account.");
                cycle.activate("UserSummary");
                success = true;
            } else {
                errorSuffix = (String)errorSuffix + " (Transaction declined by Heartland: " + response.getMessage() + ")";
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error performing Heartland debit transaction for user: {}", (Object)this.getUser().getUserName(), (Object)e);
        }
        if (!success) {
            this.addErrorMessage(ExtnHeartland.getHeartlandPlugin().getManualTransferUserErrorMessage() + (String)errorSuffix);
        }
    }

    public boolean isAccessibleByUser() {
        return ExtnHeartland.getHeartlandPlugin().isManualTransferAccessibleByUser(this.getPaperCutVisit().getUserName());
    }

    public String getNoAccessMsg() {
        return ExtnHeartland.getGatewayConfig().getNoAccessMessage();
    }

    public String getUserAndFullName() {
        StringBuilder s = new StringBuilder();
        s.append(this.getUser().getUserName());
        if (StringUtils.isNotBlank((String)this.getUser().getFullName())) {
            s.append(" (");
            s.append(this.getUser().getFullName());
            s.append(")");
        }
        return s.toString();
    }

    public String getHeartlandBalanceLabel() {
        return ExtnHeartland.getHeartlandPlugin().getBalanceDisplayLabel();
    }

    public String getHeartlandAvailableCreditLabel() {
        return ExtnHeartland.getHeartlandPlugin().getBalanceDisplayAvailableCreditLabel();
    }

    private static GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public String getPageMessage() {
        return ExtnHeartland.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return ExtnHeartland.getGatewayConfig().getPageMessageAvailable();
    }

    private static HeartlandPlugin getHeartlandPlugin() {
        return (HeartlandPlugin)PluginManager.getInstance().getPluginByClass(HeartlandPlugin.class);
    }
}

