/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.heartland;

import biz.papercut.pcng.util.ObjectUtils;

public class HeartlandAccount {
    private static final char FILE_SEPARATOR = '\u001c';
    private final FormatType _formatType;
    private final String _track2Data;
    private final String _accountNumber;
    private final int _accountType;
    private final int _customerNumber;
    private final String _suffix;

    public HeartlandAccount(String track2Data) {
        this._formatType = FormatType.SwipeCard;
        this._track2Data = track2Data;
        this._accountNumber = null;
        this._accountType = 0;
        this._customerNumber = 0;
        this._suffix = null;
    }

    public HeartlandAccount(String accountNumber, int accountType, int customerNumber, String suffix) {
        this._formatType = FormatType.ManualCard;
        this._track2Data = null;
        this._accountNumber = accountNumber;
        this._accountType = accountType;
        this._customerNumber = customerNumber;
        this._suffix = suffix;
    }

    public String toMessage() {
        StringBuilder str = new StringBuilder();
        str.append(this._formatType.getCode());
        str.append('\u001c');
        if (this._formatType == FormatType.SwipeCard) {
            str.append(this._track2Data);
            str.append('\u001c');
        } else {
            str.append(this._accountNumber);
            str.append('\u001c');
            str.append(this._accountType);
            str.append('\u001c');
            str.append(this._customerNumber);
            str.append('\u001c');
            str.append(this._suffix);
            str.append('\u001c');
        }
        return str.toString();
    }

    public String toString() {
        if (this._formatType == FormatType.SwipeCard) {
            return ObjectUtils.createToStringBuilder((Object)this).append("track2Data", (Object)this._track2Data).toString();
        }
        return ObjectUtils.createToStringBuilder((Object)this).append("formatType", (Object)this._formatType).append("accountNumber", (Object)this._accountNumber).append("accountType", this._accountType).append("customerNumber", this._customerNumber).append("suffix", (Object)this._suffix).toString();
    }

    public static enum FormatType {
        ManualCard("1", "Manual"),
        SwipeCard("2", "Card");

        private final String _code;
        private final String _configName;

        private FormatType(String code, String configName) {
            this._code = code;
            this._configName = configName;
        }

        public String getCode() {
            return this._code;
        }

        public String getConfigName() {
            return this._configName;
        }

        public static FormatType fromString(String text) {
            if (text != null) {
                for (FormatType f : FormatType.values()) {
                    if (!text.equalsIgnoreCase(f._configName)) continue;
                    return f;
                }
            }
            return null;
        }
    }
}

