/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.heartland;

import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.heartland.DSNMessage;
import biz.papercut.pcng.ext.paymentgateway.heartland.DSNResponse;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandAccount;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandConnectionConfig;
import biz.papercut.pcng.ext.paymentgateway.heartland.ProtocolException;
import biz.papercut.pcng.ext.paymentgateway.heartland.RequestMessage;
import biz.papercut.pcng.ext.paymentgateway.heartland.ResponseMessage;
import biz.papercut.pcng.ext.paymentgateway.heartland.TransactionResponse;
import biz.papercut.pcng.util.NetworkUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartlandConnection {
    private static final Logger logger = LoggerFactory.getLogger(HeartlandConnection.class);
    private final HeartlandConnectionConfig _connectionConfig;
    private final Socket _socket;
    private final Reader _reader;
    private final Writer _writer;

    public HeartlandConnection(HeartlandConnectionConfig connectionConfig) throws IOException {
        SocketFactory socketFactory;
        logger.debug("Opening connection to Heartland server using: {}", (Object)connectionConfig);
        this._connectionConfig = connectionConfig;
        if (connectionConfig.isSsl()) {
            try {
                socketFactory = NetworkUtils.getTrustAllSSLSocketFactory();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } else {
            socketFactory = SocketFactory.getDefault();
        }
        this._socket = socketFactory.createSocket();
        this._socket.setSoTimeout(connectionConfig.getSocketReadTimeoutMS());
        this._socket.setKeepAlive(true);
        this._socket.connect(new InetSocketAddress(connectionConfig.getServerHost(), connectionConfig.getServerPort()), connectionConfig.getSocketConnectTimeoutMS());
        if (this._socket instanceof SSLSocket) {
            ((SSLSocket)this._socket).startHandshake();
        }
        this._reader = new InputStreamReader(this._socket.getInputStream(), StandardCharsets.UTF_8);
        this._writer = new BufferedWriter(new OutputStreamWriter(this._socket.getOutputStream(), StandardCharsets.UTF_8));
        logger.debug("Connection created: {}", (Object)this._socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TransactionResponse getBalance(HeartlandAccount account, String pin, int terminalId, int dsn) throws IOException, ProtocolException {
        ResponseMessage res;
        RequestMessage.TransactionType transactionType = RequestMessage.TransactionType.BalanceQuery;
        Date transmissionDate = new Date();
        boolean doBufferedTransactions = false;
        int amountInCents = 0;
        int units = 0;
        int billType = 0;
        int specialFieldQueryNumber = 0;
        boolean unitMode = false;
        try {
            RequestMessage req = new RequestMessage(account, transactionType, pin, transmissionDate, doBufferedTransactions, amountInCents, units, terminalId, billType, specialFieldQueryNumber, dsn, unitMode);
            res = this.sendAndReceive(req);
        }
        finally {
            this.close();
        }
        Integer balanceCents = res.getBalance();
        double balanceDollars = balanceCents == null ? -1.0 : (double)balanceCents.intValue() / 100.0;
        return new TransactionResponse(res.isSuccess(), res.getStatus(), res.getMessage(), balanceDollars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TransactionResponse performDebit(HeartlandAccount account, int amountInCents, String pin, int terminalId, int dsn, String orderId) throws IOException, ProtocolException {
        ResponseMessage res;
        RequestMessage.TransactionType transactionType = RequestMessage.TransactionType.RegularVend;
        Date transmissionDate = new Date();
        boolean doBufferedTransactions = false;
        int units = 0;
        int billType = 0;
        int specialFieldQueryNumber = 0;
        boolean unitMode = false;
        try {
            RequestMessage req = new RequestMessage(account, transactionType, pin, transmissionDate, doBufferedTransactions, amountInCents, units, terminalId, billType, specialFieldQueryNumber, dsn, unitMode);
            res = this.sendAndReceive(req);
        }
        finally {
            this.close();
        }
        Integer balanceCents = res.getBalance();
        double balanceDollars = balanceCents == null ? -1.0 : (double)balanceCents.intValue() / 100.0;
        String msg = "Order " + orderId + " status: " + res.getStatus();
        try {
            if (logger.isDebugEnabled()) {
                String debugMsg = msg + " " + String.valueOf(res);
                logger.debug(debugMsg);
                HeartlandConnection.getEventLog().logEvent(debugMsg);
            } else {
                logger.info(msg);
                HeartlandConnection.getEventLog().logEvent(msg);
            }
        }
        catch (Exception e) {
            logger.error("Unable to write to payment gateway event log: {}", (Object)e.getMessage());
            logger.error("Missed msg: {}", (Object)msg);
        }
        return new TransactionResponse(res.isSuccess(), res.getStatus(), res.getMessage(), balanceDollars);
    }

    private synchronized ResponseMessage sendAndReceive(RequestMessage requestMessage) throws IOException, ProtocolException {
        String response;
        String request = requestMessage.toMessage();
        try {
            this.send(request);
            response = this.receive();
        }
        catch (SocketTimeoutException ste) {
            throw new IOException("Timed out reading transaction response from Heartland.");
        }
        if (response == null) {
            throw new IOException("Received empty transaction response from Heartland.");
        }
        return ResponseMessage.valueOf(response);
    }

    public synchronized DSNResponse getCurrentDSNResponse(int terminalAddress) throws IOException, ProtocolException {
        String response;
        DSNMessage dsnMessage = new DSNMessage(terminalAddress);
        String request = dsnMessage.toMessage();
        try {
            this.send(request);
            response = this.receive();
        }
        catch (SocketTimeoutException ste) {
            throw new IOException("Timed out reading DSN response from Heartland.");
        }
        finally {
            this.close();
        }
        if (response == null) {
            throw new IOException("Received empty DSN response from Heartland.");
        }
        return DSNResponse.valueOf(response);
    }

    private synchronized void send(String requestMessage) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("> {}", (Object)requestMessage);
        }
        IOUtils.write((String)requestMessage, (Writer)this._writer);
        this._writer.flush();
    }

    @CheckForNull
    private synchronized String receive() throws IOException {
        int n;
        StringBuilder response = new StringBuilder();
        int n2 = -1;
        long startTime = System.currentTimeMillis();
        do {
            if (startTime + (long)this._connectionConfig.getMessageReceiveTimeoutMS() < System.currentTimeMillis()) {
                logger.warn("Timed out while reading a response from Heartland. Read so far: {}", (Object)response);
                throw new IOException("Heartland message receive timeout");
            }
            n = this._reader.read();
            if (n == -1) {
                logger.warn("Heartland closed connection before reading a full message. Read so far: {}", (Object)response);
                throw new IOException("Heartland connection closed while reading message");
            }
            response.append((char)n);
        } while (n != 3);
        char lrc = RequestMessage.calculateLRC(response.toString().getBytes());
        int n3 = this._reader.read();
        if (n3 == -1) {
            logger.warn("Heartland closed connection before reading LRC. Read so far: {}", (Object)response);
            throw new IOException("Heartland connection close while reading LRC");
        }
        if (n3 != lrc) {
            logger.warn("Heartland message received with LRC mismatch. Expected LRC: {} Got LRC: {}", (Object)Character.valueOf(lrc), (Object)n3);
            throw new IOException("Heartland message received with LRC mismatch");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("< {}", (Object)response);
        }
        return response.toString();
    }

    public synchronized void close() {
        if (!this._socket.isClosed()) {
            logger.debug("Closing connection to Heartland server : {}", (Object)this._socket);
            biz.papercut.pcng.util.io.IOUtils.closeQuietly((Socket)this._socket);
        }
    }

    private static EventLog getEventLog() {
        return EventLog.getInstance();
    }
}

