/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.heartland;

import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandAccount;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandConnection;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandConnectionConfig;
import biz.papercut.pcng.ext.paymentgateway.heartland.ProtocolException;
import biz.papercut.pcng.ext.paymentgateway.heartland.TransactionResponse;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HeartlandConnectionManagement {
    private static final Logger logger = LoggerFactory.getLogger(HeartlandConnectionManagement.class);
    static final int CONNECT_ATTEMPTS = 2;
    static final int RECONNECT_WAIT_MS = 1000;
    static final int TIMEOUT_MS = 10000;
    private static final int MAX_SEQUENCE_NUMBER = 99;
    private static final int MESSAGE_RESEND_ATTEMPTS = 3;
    @GuardedBy(value="this")
    protected int _sequenceNumber;
    private final HeartlandConnectionConfig _connectionConfig;
    private final int _terminalId;

    HeartlandConnectionManagement(HeartlandConnectionConfig connectionConfig, int terminalId) {
        this._connectionConfig = connectionConfig;
        this._terminalId = terminalId;
    }

    @CheckForNull
    <T> T doWithConnection(ConnectionRunnable<T> runnable) {
        T result = null;
        int sendAttempt = 0;
        while (result == null && sendAttempt++ < 3) {
            HeartlandConnection connection;
            try {
                connection = this.getConnection();
            }
            catch (Exception e) {
                return null;
            }
            try {
                result = runnable.run(connection);
            }
            catch (Exception e) {
                logger.debug("Error sending message to Heartland (attempt {} of 2): {}. ", (Object)sendAttempt, (Object)e.getMessage());
                connection.close();
            }
        }
        return result;
    }

    synchronized int getNextSequenceNumber() {
        int sequenceNumber = this._sequenceNumber++;
        if (this._sequenceNumber > 99) {
            this._sequenceNumber = 1;
        }
        return sequenceNumber;
    }

    public synchronized int getSequenceNumber() {
        return this._sequenceNumber;
    }

    HeartlandConnectionConfig getConnectionConfig() {
        return this._connectionConfig;
    }

    int getTerminalId() {
        return this._terminalId;
    }

    public abstract TransactionResponse getBalance(HeartlandAccount var1, String var2);

    public abstract TransactionResponse performDebit(HeartlandAccount var1, String var2, int var3, String var4);

    protected abstract HeartlandConnection getConnection() throws IOException;

    protected static interface ConnectionRunnable<T> {
        public T run(HeartlandConnection var1) throws ProtocolException, IOException;
    }
}

