/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.heartland;

import biz.papercut.pcng.ext.paymentgateway.heartland.DSNResponse;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandAccount;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandConnection;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandConnectionConfig;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandConnectionManagement;
import biz.papercut.pcng.ext.paymentgateway.heartland.TransactionResponse;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartlandConnectionManager
extends HeartlandConnectionManagement {
    private static final Logger logger = LoggerFactory.getLogger(HeartlandConnectionManager.class);
    @Nullable
    @GuardedBy(value="this")
    private HeartlandConnection _connection;

    public HeartlandConnectionManager(HeartlandConnectionConfig connectionConfig, int terminalId) throws Exception {
        super(connectionConfig, terminalId);
        this.getConnection();
        try {
            DSNResponse response = this._connection.getCurrentDSNResponse(terminalId);
            if (response == null || !response.isSuccess()) {
                logger.debug("Failed to get current DSN and so start from 1");
                this._sequenceNumber = 1;
            } else {
                this._sequenceNumber = response.getDSN();
            }
            this.getNextSequenceNumber();
            logger.debug("Start connection using dsn of {}", (Object)this._sequenceNumber);
        }
        catch (Exception e) {
            logger.debug("Unable to get current DSN: {}", (Object)e.getMessage());
            throw e;
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionResponse getBalance(HeartlandAccount account, String pin) {
        long startTime = System.currentTimeMillis();
        int sequenceNumber = this.getNextSequenceNumber();
        try {
            this.getConnection();
        }
        catch (Exception e) {
            return new TransactionResponse(false, -1, "Timed out connecting to Heartland", 0.0);
        }
        HeartlandConnectionManager heartlandConnectionManager = this;
        synchronized (heartlandConnectionManager) {
            if (System.currentTimeMillis() - startTime > 10000L) {
                this.disconnect();
                return new TransactionResponse(false, -1, "Timed out waiting to connect to Heartland", 0.0);
            }
            TransactionResponse response = this.doWithConnection(connection -> connection.getBalance(account, pin, this.getTerminalId(), sequenceNumber));
            this.disconnect();
            return Objects.requireNonNullElseGet(response, () -> new TransactionResponse(false, -1, "Unable to connect to Heartland", 0.0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionResponse performDebit(HeartlandAccount account, String pin, int amountInCents, String orderId) {
        long startTime = System.currentTimeMillis();
        int sequenceNumber = this.getNextSequenceNumber();
        try {
            this.getConnection();
        }
        catch (Exception e) {
            return new TransactionResponse(false, -1, "Timed out connecting to Heartland", 0.0);
        }
        HeartlandConnectionManager heartlandConnectionManager = this;
        synchronized (heartlandConnectionManager) {
            if (System.currentTimeMillis() - startTime > 10000L) {
                this.disconnect();
                return new TransactionResponse(false, -1, "Timed out waiting to connect to Heartland", 0.0);
            }
            TransactionResponse response = this.doWithConnection(connection -> connection.performDebit(account, amountInCents, pin, this.getTerminalId(), sequenceNumber, orderId));
            this.disconnect();
            return Objects.requireNonNullElseGet(response, () -> new TransactionResponse(false, -1, "Unable to connect to Heartland", 0.0));
        }
    }

    private synchronized void disconnect() {
        if (this._connection != null) {
            this.setConnection(null);
        }
    }

    @Override
    @CheckForNull
    protected synchronized HeartlandConnection getConnection() throws IOException {
        if (this._connection == null) {
            int connectAttempt = 0;
            do {
                if (++connectAttempt > 1) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                try {
                    this.setConnection(new HeartlandConnection(this.getConnectionConfig()));
                }
                catch (Exception e) {
                    logger.debug("Unable to connect to Heartland: {}", (Object)String.valueOf(e));
                }
            } while (this._connection == null && connectAttempt < 2);
            if (this._connection == null) {
                logger.error("Unable to connect to Heartland at {}:{} after {} attempts.", new Object[]{this.getConnectionConfig().getServerHost(), this.getConnectionConfig().getServerPort(), connectAttempt});
                throw new IOException("Unable to connect to Heartland");
            }
        }
        return this._connection;
    }

    private void setConnection(@Nullable HeartlandConnection connection) {
        this._connection = connection;
    }
}

