/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.heartland;

import biz.papercut.pcng.ext.paymentgateway.heartland.DSNResponse;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandAccount;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandConnection;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandConnectionConfig;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandConnectionManagement;
import biz.papercut.pcng.ext.paymentgateway.heartland.TransactionResponse;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartlandMultiConnectionManager
extends HeartlandConnectionManagement {
    private static final Logger logger = LoggerFactory.getLogger(HeartlandMultiConnectionManager.class);

    public HeartlandMultiConnectionManager(HeartlandConnectionConfig connectionConfig, int terminalId) {
        super(connectionConfig, terminalId);
        try {
            DSNResponse response = this.doWithConnection(connection -> connection.getCurrentDSNResponse(terminalId));
            if (response == null || !response.isSuccess()) {
                logger.debug("Failed to get current DSN and so start from 1");
                this._sequenceNumber = 1;
            } else {
                this._sequenceNumber = response.getDSN();
            }
            this.getNextSequenceNumber();
            logger.debug("Start connection using dsn of {}", (Object)this._sequenceNumber);
        }
        catch (Exception e) {
            logger.debug("Unable to get current DSN: {}", (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public TransactionResponse getBalance(HeartlandAccount account, String pin) {
        int sequenceNumber = this.getNextSequenceNumber();
        TransactionResponse response = this.doWithConnection(connection -> connection.getBalance(account, pin, this.getTerminalId(), sequenceNumber));
        return Objects.requireNonNullElseGet(response, () -> new TransactionResponse(false, -1, "Unable to connect to Heartland", 0.0));
    }

    @Override
    public TransactionResponse performDebit(HeartlandAccount account, String pin, int amountInCents, String orderId) {
        int sequenceNumber = this.getNextSequenceNumber();
        TransactionResponse response = this.doWithConnection(connection -> connection.performDebit(account, amountInCents, pin, this.getTerminalId(), sequenceNumber, orderId));
        return Objects.requireNonNullElseGet(response, () -> new TransactionResponse(false, -1, "Unable to connect to Heartland", 0.0));
    }

    @Override
    @CheckForNull
    protected synchronized HeartlandConnection getConnection() throws IOException {
        HeartlandConnection connection = null;
        int connectAttempt = 0;
        do {
            if (++connectAttempt > 1) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            try {
                connection = new HeartlandConnection(this.getConnectionConfig());
            }
            catch (Exception e) {
                logger.debug("Unable to connect to Heartland: {}", (Object)String.valueOf(e));
            }
        } while (connection == null && connectAttempt < 2);
        if (connection == null) {
            logger.error("Unable to connect to Heartland at {}:{} after {} attempts.", new Object[]{this.getConnectionConfig().getServerHost(), this.getConnectionConfig().getServerPort(), connectAttempt});
            throw new IOException("Unable to connect to Heartland");
        }
        return connection;
    }
}

