/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.heartland;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.ConfigurationException;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandAccount;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandCardLookup;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandConnectionConfig;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandConnectionManagement;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandConnectionManager;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandMultiConnectionManager;
import biz.papercut.pcng.ext.paymentgateway.heartland.TransactionResponse;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import com.papercut.server.lang.service.ServiceException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class HeartlandPlugin
implements EnableablePlugin,
SpringContextPlugin,
UserLinkPlugin {
    private static final Logger logger = LoggerFactory.getLogger(HeartlandPlugin.class);
    private static final String PAYMENT_GATEWAY_PAGE_NAME = "ExtnHeartland";
    private static final double ROUNDING_TOLERANCE = 1.0E-5;
    private static final String TRANSACTION_SOURCE_NAME = "Heartland";
    private static final String CONFIG_PREFIX = "heartland.";
    private static final String CONFIG_ENABLED = "heartland.enabled";
    private static final String CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO = "heartland.only-allow-accumulation-up-to";
    private static final String CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO_MESSAGE = "heartland.only-allow-accumulation-up-to-message";
    private static final String CONFIG_BALANCE_DISPLAY_PREFIX = "heartland.balance-display.";
    private static final String CONFIG_BALANCE_DISPLAY_ENABLED = "heartland.balance-display.enabled";
    private static final String CONFIG_BALANCE_DISPLAY_LABEL = "heartland.balance-display.label";
    private static final String CONFIG_BALANCE_DISPLAY_AVAILABLE_CREDIT_PREFIX = "heartland.balance-display.available-credit.";
    private static final String CONFIG_BALANCE_DISPLAY_AVAILABLE_CREDIT_LABEL = "heartland.balance-display.available-credit.label";
    private static final String CONFIG_SERVER_PREFIX = "heartland.server.";
    private static final String CONFIG_SERVER_HOST = "heartland.server.host";
    private static final String CONFIG_SERVER_PORT = "heartland.server.port";
    private static final String CONFIG_SERVER_SSL = "heartland.server.ssl";
    private static final String CONFIG_SERVER_LOAD_BALANCER = "heartland.server.load-balancer";
    private static final String CONFIG_SERVER_CONNECT_TIMEOUT = "heartland.server.connect-timeout";
    private static final String CONFIG_SERVER_READ_TIMEOUT = "heartland.server.read-timeout";
    private static final String CONFIG_SERVER_RECEIVE_TIMEOUT = "heartland.server.receive-timeout";
    private static final String CONFIG_NO_ID_DEFINED_MESSAGE = "heartland.no-id-defined";
    private static final String CONFIG_TERMINAL_ADDRESS = "heartland.terminal-id";
    private static final String CONFIG_MANUAL_PREFIX = "heartland.manual-transfer.";
    private static final String CONFIG_MANUAL_TRANSFER_ENABLED = "heartland.manual-transfer.enabled";
    private static final String CONFIG_MANUAL_TRANSFER_PAGE_TITLE = "heartland.manual-transfer.page.title";
    private static final String CONFIG_MANUAL_TRANSFER_PAGE_HEADING = "heartland.manual-transfer.page.heading";
    private static final String CONFIG_MANUAL_TRANSFER_TRANSACTION_COMMENT = "heartland.manual-transfer.transaction-comment";
    protected static final String CONFIG_MANUAL_TRANSFER_ALLOWED_AMOUNTS = "heartland.manual-transfer.allowed-amounts";
    private static final String CONFIG_MANUAL_TRANSFER_ALLOWED_GROUPS = "heartland.manual-transfer.allowed-groups";
    private static final String CONFIG_MANUAL_TRANSFER_USER_ERROR_MESSAGE = "heartland.manual-transfer.user-error-message";
    private static final String CONFIG_ON_DEMAND_PREFIX = "heartland.on-demand-transfer.";
    private static final String CONFIG_ON_DEMAND_TRANSFER_ENABLED = "heartland.on-demand-transfer.enabled";
    private static final String CONFIG_ON_DEMAND_TRANSFER_DEFAULT_TRANSFER_AMOUNT = "heartland.on-demand-transfer.default-transfer-amount";
    private static final String CONFIG_ON_DEMAND_TRANSFER_MAX_TRANSFER_AMOUNT = "heartland.on-demand-transfer.max-transfer-amount";
    private static final String CONFIG_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT = "heartland.on-demand-transfer.transaction-comment";
    private static final String CONFIG_ON_DEMAND_TRANSFER_ENABLED_GROUPS = "heartland.on-demand-transfer.enabled-groups";
    private static final String DEFAULT_MANUAL_TRANSFER_TRANSACTION_COMMENT = "Funds added from Heartland";
    private static final String DEFAULT_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT = "Automatic transfer from Heartland";
    private static final int DEFAULT_SERVER_CONNECT_TIMEOUT = 3000;
    private static final int DEFAULT_SERVER_READ_TIMEOUT = 2000;
    private static final int DEFAULT_SERVER_RECEIVE_TIMEOUT = 4000;
    @AESProperty
    public static final String NOT_USE_CONFIG_CARD_ID_LOOKUP_DB_PASSWORD = "heartland.account-id-lookup.db-password";
    @Nullable
    private final HeartlandCardLookup _cardLookup = new HeartlandCardLookup();
    @Nullable
    private volatile HeartlandConnectionManagement _connectionManager;
    @Nullable
    private volatile ApplicationContext _ctx;

    @CheckForNull
    public String getIsConfigured() {
        String errorPrefix = "Configuration problem: ";
        String errorSuffix = "  Please check the payment gateway config file.";
        try {
            HeartlandPlugin.getConnectionConfig();
        }
        catch (Exception e) {
            return errorPrefix + e.getMessage() + errorSuffix;
        }
        try {
            this.getManualTransferAllowedAmounts();
        }
        catch (Exception e) {
            String errorMsg = "Allowed amounts setting uses the wrong format.";
            EventLog.getInstance().logEvent(errorMsg);
            return errorPrefix + errorMsg + errorSuffix;
        }
        if (this.getManualTransferAllowedAmounts().isEmpty()) {
            String errorMsg = "Must specify at least one allowed payment amount.";
            EventLog.getInstance().logEvent(errorMsg);
            return errorPrefix + errorMsg + errorSuffix;
        }
        if (this.isOnDemandTransferEnabled()) {
            if (this.getOnDemandTransferDefaultTransferAmount() == null) {
                String errorMsg = "If on-demand transfers is enabled a default transfer amount must be specified.";
                EventLog.getInstance().logEvent(errorMsg);
                return errorPrefix + errorMsg + errorSuffix;
            }
            if (this.getOnDemandTransferMaxTransferAmount() == null) {
                String errorMsg = "If on-demand transfers is enabled a max transfer amount must be specified.";
                EventLog.getInstance().logEvent(errorMsg);
                return errorPrefix + errorMsg + errorSuffix;
            }
        }
        try {
            this._cardLookup.checkConfiguration();
        }
        catch (ConfigurationException ce) {
            logger.error(ce.getMessage());
            EventLog.getInstance().logEvent(ce.getMessage());
            return ce.getMessage();
        }
        return null;
    }

    public TransactionResponse getBalance(User user) {
        HeartlandAccount account = this.getCardLookup().getAccount(user);
        if (account == null) {
            return new TransactionResponse(false, -1, "Heartland Account number is not present", 0.0);
        }
        String pin = this.getCardLookup().getPin(user);
        return this.getBalance(account, pin);
    }

    protected TransactionResponse getBalance(HeartlandAccount account, String pin) {
        TransactionResponse response;
        String msg = "Attempting balance inquiry for account: " + String.valueOf(account) + ", pin: " + pin;
        logger.debug(msg);
        HeartlandPlugin.getEventLog().logEvent(msg);
        int attempts = 1;
        int maxAttempts = 5;
        int dupBalanceDelayMillis = 1000;
        try {
            while (!(response = this.getConnectionManager().getBalance(account, pin)).isSuccess() && "DUP TRANS".equalsIgnoreCase(response.getMessage())) {
                try {
                    logger.debug("Received Duplicate Transaction for balance query  (attempt {} with new transaction) - sleep for 1000 millis before retrying", (Object)attempts);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                if (++attempts <= 5) continue;
                break;
            }
        }
        catch (Exception e) {
            return new TransactionResponse(false, -1, e.getMessage(), 0.0);
        }
        String msg2 = "Balance inquiry for account " + String.valueOf(account) + ", pin " + pin + ": " + String.valueOf(response);
        if (response.isSuccess()) {
            logger.debug(msg2);
        } else {
            logger.error(msg2);
        }
        HeartlandPlugin.getEventLog().logEvent(msg2);
        return response;
    }

    public TransactionResponse performDebit(User user, double amount) {
        HeartlandAccount account = this.getCardLookup().getAccount(user);
        if (account == null) {
            return new TransactionResponse(false, -1, "Heartland Account number is not present", 0.0);
        }
        String pin = this.getCardLookup().getPin(user);
        return this.performDebit(account, pin, amount);
    }

    protected TransactionResponse performDebit(HeartlandAccount account, String pin, double amount) {
        TransactionResponse response;
        int amountCents = HeartlandPlugin.roundDoubleDollarsToCents(amount);
        String orderId = this.getNextOrderId();
        String msg = "Attempting debit transaction for account: " + String.valueOf(account) + ", pin: " + pin + ", amount: " + amountCents;
        logger.debug(msg);
        HeartlandPlugin.getEventLog().logEvent(msg);
        try {
            response = this.getConnectionManager().performDebit(account, pin, amountCents, orderId);
        }
        catch (Exception e) {
            return new TransactionResponse(false, -1, e.getMessage(), 0.0);
        }
        String msg2 = "Transaction for account " + String.valueOf(account) + ", pin " + pin + ": " + String.valueOf(response);
        if (response.isSuccess()) {
            logger.debug(msg2);
        } else {
            logger.error(msg2);
        }
        HeartlandPlugin.getEventLog().logEvent(msg2);
        if (response.isSuccess()) {
            HeartlandPlugin.getEventLog().logTransaction(account.toString(), orderId, amount, TRANSACTION_SOURCE_NAME);
        }
        return response;
    }

    public boolean isBalanceDisplayEnabled() {
        return BooleanUtils.isTrue((Boolean)HeartlandPlugin.getGatewayConfig().getBoolean(CONFIG_BALANCE_DISPLAY_ENABLED));
    }

    public String getBalanceDisplayLabel() {
        return StringUtils.trimToEmpty((String)HeartlandPlugin.getGatewayConfig().getString(CONFIG_BALANCE_DISPLAY_LABEL));
    }

    public String getBalanceDisplayAvailableCreditLabel() {
        return StringUtils.trimToEmpty((String)HeartlandPlugin.getGatewayConfig().getString(CONFIG_BALANCE_DISPLAY_AVAILABLE_CREDIT_LABEL));
    }

    private static HeartlandConnectionConfig getConnectionConfig() throws Exception {
        Integer serverPort;
        GatewayConfig gc = HeartlandPlugin.getGatewayConfig();
        String serverHost = StringUtils.trimToNull((String)gc.getString(CONFIG_SERVER_HOST));
        try {
            serverPort = gc.getInteger(CONFIG_SERVER_PORT);
        }
        catch (Exception e) {
            throw new Exception("Heartland server port is required and must be a port number (heartland.server.port)");
        }
        boolean ssl = BooleanUtils.isTrue((Boolean)gc.getBoolean(CONFIG_SERVER_SSL));
        int socketConnectTimeoutMS = NumberUtils.toInt((String)gc.getString(CONFIG_SERVER_CONNECT_TIMEOUT), (int)3000);
        int socketReadTimeoutMS = NumberUtils.toInt((String)gc.getString(CONFIG_SERVER_READ_TIMEOUT), (int)2000);
        int messageReceiveTimeoutMS = NumberUtils.toInt((String)gc.getString(CONFIG_SERVER_RECEIVE_TIMEOUT), (int)4000);
        boolean isLoadBalancer = BooleanUtils.isTrue((Boolean)gc.getBoolean(CONFIG_SERVER_LOAD_BALANCER));
        return new HeartlandConnectionConfig(serverHost, serverPort, ssl, socketConnectTimeoutMS, socketReadTimeoutMS, messageReceiveTimeoutMS, isLoadBalancer);
    }

    private static int getTerminalId() {
        return HeartlandPlugin.getGatewayConfig().getInteger(CONFIG_TERMINAL_ADDRESS);
    }

    public boolean isManualTransferEnabled() {
        return BooleanUtils.isTrue((Boolean)HeartlandPlugin.getGatewayConfig().getBoolean(CONFIG_MANUAL_TRANSFER_ENABLED));
    }

    @CheckForNull
    public String getManualTransferPageTitle() {
        return HeartlandPlugin.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFER_PAGE_TITLE);
    }

    public String getManualTransferPageHeading() {
        return StringUtils.trimToEmpty((String)HeartlandPlugin.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFER_PAGE_HEADING));
    }

    public String getManualTransferTransactionComment() {
        Object txnComment = StringUtils.trimToNull((String)HeartlandPlugin.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFER_TRANSACTION_COMMENT));
        if (txnComment == null) {
            txnComment = DEFAULT_MANUAL_TRANSFER_TRANSACTION_COMMENT;
        }
        if (!this.isLicensed()) {
            txnComment = (String)txnComment + " (" + GatewayUtils.getNotLicensedUserMessage() + ")";
        }
        return txnComment;
    }

    public List<Double> getManualTransferAllowedAmounts() {
        return HeartlandPlugin.getGatewayConfig().getDoubleList(CONFIG_MANUAL_TRANSFER_ALLOWED_AMOUNTS);
    }

    public boolean isManualTransferAccessibleByUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        return GatewayUtils.isAccessibleByUser(username, CONFIG_MANUAL_TRANSFER_ALLOWED_GROUPS, this.getUserManager());
    }

    public String getManualTransferUserErrorMessage() {
        String userError = StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_MANUAL_TRANSFER_USER_ERROR_MESSAGE));
        if (userError == null) {
            userError = "An error has occurred, please try again. If you continue to receive this error please contact a network administrator for assistance.";
        }
        return userError;
    }

    public String getNoIdDefinedMessage() {
        String noIdError = StringUtils.trimToEmpty((String)GatewayConfig.getInstance().getString(CONFIG_NO_ID_DEFINED_MESSAGE));
        if (noIdError == null) {
            noIdError = "This service is currently not available as your login is not yet associated with a Heartland account. Please contact a network administrator for assistance. (Reason: no card/id defined.)";
        }
        return noIdError;
    }

    public Double getOnlyAllowAccumulationUpTo() {
        Double amount = null;
        try {
            amount = HeartlandPlugin.getGatewayConfig().getDouble(CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO);
        }
        catch (Exception e) {
            logger.error("Invalid accumulation up to amount.", (Throwable)e);
        }
        return amount;
    }

    public String getOnlyAllowAccumulationUpToMessage() {
        return HeartlandPlugin.getGatewayConfig().getString(CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO_MESSAGE);
    }

    public boolean isOnDemandTransferEnabled() {
        return BooleanUtils.isTrue((Boolean)HeartlandPlugin.getGatewayConfig().getBoolean(CONFIG_ON_DEMAND_TRANSFER_ENABLED));
    }

    @Nullable
    public Double getOnDemandTransferDefaultTransferAmount() {
        Double amount = null;
        try {
            amount = HeartlandPlugin.getGatewayConfig().getDouble(CONFIG_ON_DEMAND_TRANSFER_DEFAULT_TRANSFER_AMOUNT);
        }
        catch (Exception e) {
            logger.error("Invalid on-demand transfer default transfer amount.", (Throwable)e);
        }
        return amount;
    }

    @Nullable
    public Double getOnDemandTransferMaxTransferAmount() {
        Double amount = null;
        try {
            amount = HeartlandPlugin.getGatewayConfig().getDouble(CONFIG_ON_DEMAND_TRANSFER_MAX_TRANSFER_AMOUNT);
        }
        catch (Exception e) {
            logger.error("Invalid on-demand transfer max transfer amount.", (Throwable)e);
        }
        return amount;
    }

    public String getOnDemandTransferTransactionComment() {
        Object txnComment = StringUtils.trimToNull((String)HeartlandPlugin.getGatewayConfig().getString(CONFIG_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT));
        if (txnComment == null) {
            txnComment = DEFAULT_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT;
        }
        if (!this.isLicensed()) {
            txnComment = (String)txnComment + " (" + GatewayUtils.getNotLicensedUserMessage() + ")";
        }
        return txnComment;
    }

    public boolean isOnDemandTransferEnabledForUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        if (!this.isOnDemandTransferEnabled()) {
            return false;
        }
        return GatewayUtils.isAccessibleByUser(username, CONFIG_ON_DEMAND_TRANSFER_ENABLED_GROUPS, this.getUserManager());
    }

    private String getNextOrderId() {
        return String.valueOf(CreditCardGatewayPlugin.getUniqueOrderID());
    }

    public static int roundDoubleDollarsToCents(double dollars) {
        double dollarsToRound = dollars - 1.0E-5;
        return (int)Math.ceil(dollarsToRound * 100.0);
    }

    public boolean isLicensed() {
        return GatewayUtils.isLicensed(this.getLicenceManager(), "payment-gateways-heartland");
    }

    public boolean isPluginEnabled() {
        Boolean enabled = GatewayConfig.getInstance().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isManualTransferEnabled() && this.isManualTransferAccessibleByUser(username)) {
            return List.of(PAYMENT_GATEWAY_PAGE_NAME);
        }
        return null;
    }

    @CheckForNull
    public String getPageTitle() {
        return this.getManualTransferPageTitle();
    }

    public synchronized ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
        this.getCardLookup().setApplicationContext(ctx);
    }

    private HeartlandCardLookup getCardLookup() {
        if (this._cardLookup == null) {
            throw new ServiceException("Heartland payment gateway not fully configured");
        }
        return this._cardLookup;
    }

    private synchronized HeartlandConnectionManagement getConnectionManager() throws Exception {
        if (this._connectionManager == null) {
            HeartlandConnectionConfig config;
            String configError = this.getIsConfigured();
            if (configError != null) {
                logger.error(configError);
                throw new ConfigurationException(configError);
            }
            try {
                config = HeartlandPlugin.getConnectionConfig();
            }
            catch (Exception e) {
                String errorMsg = "Heartland plugin not fully configured: " + e.getMessage();
                logger.error(errorMsg, (Throwable)e);
                throw new ConfigurationException(errorMsg);
            }
            this._connectionManager = config.isLoadBalancer() ? new HeartlandMultiConnectionManager(config, HeartlandPlugin.getTerminalId()) : new HeartlandConnectionManager(config, HeartlandPlugin.getTerminalId());
        }
        return this._connectionManager;
    }

    private static EventLog getEventLog() {
        return EventLog.getInstance();
    }

    private static GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    private LicenseManager getLicenceManager() {
        return (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }
}

