/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.heartland;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandPlugin;
import biz.papercut.pcng.ext.paymentgateway.heartland.TransactionResponse;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin3;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin4;
import biz.papercut.pcng.service.UserManager;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class HeartlandTopupAccountOnDemandPlugin
implements TopupAccountOnDemandPlugin4,
SpringContextPlugin {
    private static final Logger logger = LoggerFactory.getLogger(HeartlandTopupAccountOnDemandPlugin.class);
    @Nullable
    @GuardedBy(value="this")
    private ApplicationContext _ctx;

    public Map<String, Double> getBalance(Map<String, String> userDetails) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        HeartlandPlugin cp = HeartlandTopupAccountOnDemandPlugin.getHeartlandPlugin();
        if (!cp.isBalanceDisplayEnabled()) {
            logger.debug("Heartland balance display disabled.");
            return null;
        }
        String username = userDetails.get("username");
        User user = this.getUserManager().getUser(username);
        if (user == null) {
            logger.error("Unknown user: {}", (Object)username);
            return null;
        }
        TransactionResponse tr = cp.getBalance(user);
        if (!tr.isSuccess()) {
            if (logger.isDebugEnabled()) {
                logger.error("Unable to retrieve Heartland balance for user \"{}\": {} {}", new Object[]{username, tr.getMessage(), tr});
            } else {
                logger.error("Unable to retrieve Heartland balance for user \"{}\": {}", (Object)username, (Object)tr.getMessage());
            }
            return null;
        }
        HashMap<String, Double> balances = new HashMap<String, Double>();
        balances.put(cp.getBalanceDisplayLabel(), tr.getBalance());
        return balances;
    }

    @Nullable
    public TopupAccountOnDemandPlugin3.AvailableCredit getAvailableCreditForTopUp(String username, @Nullable String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            return null;
        }
        HeartlandPlugin cp = HeartlandTopupAccountOnDemandPlugin.getHeartlandPlugin();
        if (!cp.isOnDemandTransferEnabledForUser(username)) {
            logger.debug("Heartland top-up on demand plugin not enabled for user '{}'.", (Object)username);
            return null;
        }
        User user = this.getUserManager().getUser(username);
        if (user == null) {
            logger.error("Unknown user: {}", (Object)username);
            return null;
        }
        TransactionResponse response = cp.getBalance(user);
        if (!response.isSuccess()) {
            logger.error("Error retrieving available credit for user '{}', response: {}", (Object)username, (Object)response);
            return null;
        }
        return new TopupAccountOnDemandPlugin3.AvailableCredit(false, response.getBalance());
    }

    public TopupAccountOnDemandPlugin.TopupResponse getTopup(double amountRequired, String username, String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged, Map<String, String> usageDetails) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            logger.debug("Heartland top-up on demand plugin not enabled for shared accounts.");
            return null;
        }
        double topupAmount = HeartlandTopupAccountOnDemandPlugin.calcTopUpAmount(amountRequired);
        if (topupAmount <= 0.0) {
            return null;
        }
        User user = this.getUserManager().getUser(username);
        if (user == null) {
            logger.debug("Unknown user: {}", (Object)username);
            return null;
        }
        HeartlandPlugin cp = HeartlandTopupAccountOnDemandPlugin.getHeartlandPlugin();
        if (!cp.isOnDemandTransferEnabledForUser(username)) {
            logger.debug("Heartland top-up on demand plugin not enabled for user '{}'.", (Object)username);
            return null;
        }
        String txnComment = cp.getOnDemandTransferTransactionComment();
        return GatewayUtils.performTopupDebit((TopupAccountOnDemandPlugin3)this, amount -> {
            TransactionResponse r = cp.performDebit(user, amount);
            logger.debug("Result: {}", (Object)r);
            return r.isSuccess() ? Double.valueOf(amount) : null;
        }, topupAmount, amountRequired, username, sharedAccount, accountCharged, usageDetails, txnComment);
    }

    private static double calcTopUpAmount(double amountRequired) {
        if (amountRequired <= 0.0) {
            return 0.0;
        }
        HeartlandPlugin cp = HeartlandTopupAccountOnDemandPlugin.getHeartlandPlugin();
        Double defaultAmount = cp.getOnDemandTransferDefaultTransferAmount();
        Double maxAmount = cp.getOnDemandTransferMaxTransferAmount();
        if (defaultAmount == null || maxAmount == null) {
            return 0.0;
        }
        int cents = HeartlandPlugin.roundDoubleDollarsToCents(amountRequired);
        double topupAmount = (double)cents / 100.0;
        if (defaultAmount > 0.0 && maxAmount > 0.0 && defaultAmount > maxAmount) {
            logger.warn("Heartland default transfer amount is greater than the max transfer amount.  Using default transfer amount as max amount.");
            maxAmount = defaultAmount;
        }
        if (defaultAmount > 0.0 && amountRequired < defaultAmount) {
            logger.debug("Using default transfer amount of {}", (Object)defaultAmount);
            topupAmount = defaultAmount;
        }
        if (maxAmount > 0.0 && topupAmount > maxAmount) {
            logger.debug("Transfer amount of {} exceeds maximum of {}", (Object)topupAmount, (Object)maxAmount);
            topupAmount = 0.0;
        }
        return topupAmount;
    }

    public boolean isPluginEnabled() {
        HeartlandPlugin cp = HeartlandTopupAccountOnDemandPlugin.getHeartlandPlugin();
        return cp.isPluginEnabled() && cp.isOnDemandTransferEnabled();
    }

    public synchronized ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public synchronized void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    private static HeartlandPlugin getHeartlandPlugin() {
        return (HeartlandPlugin)PluginManager.getInstance().getPluginByClass(HeartlandPlugin.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }
}

