/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.heartland;

import biz.papercut.pcng.ext.paymentgateway.heartland.HeartlandAccount;
import biz.papercut.pcng.util.ObjectUtils;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RequestMessage {
    private static final Format TIME_FORMATTER = new SimpleDateFormat("HH:mm:ss");
    private static final Format DATE_FORMATTER = new SimpleDateFormat("yyyyMMdd");
    private final HeartlandAccount _account;
    private final TransactionType _transactionType;
    private final String _pin;
    private final String _transactionDate;
    private final String _transactionTime;
    private final boolean _doBufferedTransactions;
    private final int _amountInCents;
    private final int _units;
    private final int _terminalId;
    private final int _billType;
    private final int _specialFieldQueryNumber;
    private final int _dsn;
    private final boolean _unitMode;
    public static final char START_OF_TEXT = '\u0002';
    public static final char END_OF_TEXT = '\u0003';
    public static final String FILE_SEPARATOR = "\u001c";

    public RequestMessage(HeartlandAccount account, TransactionType transactionType, String pin, Date transmissionDate, boolean doBufferedTransactions, int amountInCents, int units, int terminalId, Integer billType, int specialFieldQueryNumber, int dsn, boolean unitMode) {
        if (pin != null && pin.length() > 4) {
            throw new IllegalArgumentException("PIN can be up to 4 chars");
        }
        if (0 > dsn || dsn > 99) {
            throw new IllegalArgumentException("dsn must be 2 digits or less");
        }
        if (transactionType == TransactionType.RegularVend) {
            if (amountInCents <= 0) {
                throw new IllegalArgumentException("Transaction amount must be > 0");
            }
            if (amountInCents > 9999999) {
                throw new IllegalArgumentException("Transaction amount must be up to 7 digits");
            }
        }
        this._account = account;
        this._transactionType = transactionType;
        this._pin = pin;
        this._transactionDate = transmissionDate == null ? null : DATE_FORMATTER.format(transmissionDate);
        this._transactionTime = transmissionDate == null ? null : TIME_FORMATTER.format(transmissionDate);
        this._doBufferedTransactions = doBufferedTransactions;
        this._amountInCents = amountInCents;
        this._units = units;
        this._terminalId = terminalId;
        this._billType = billType;
        this._specialFieldQueryNumber = specialFieldQueryNumber;
        this._dsn = dsn;
        this._unitMode = unitMode;
    }

    public TransactionType getTransactionType() {
        return this._transactionType;
    }

    public static Format getTimeFormatter() {
        return TIME_FORMATTER;
    }

    public static Format getDateFormatter() {
        return DATE_FORMATTER;
    }

    public String getPin() {
        return this._pin;
    }

    public String getTransactionDate() {
        return this._transactionDate;
    }

    public String getTransactionTime() {
        return this._transactionTime;
    }

    public boolean isDoBufferedTransactions() {
        return this._doBufferedTransactions;
    }

    public int getAmountInCents() {
        return this._amountInCents;
    }

    public int getUnits() {
        return this._units;
    }

    public int getTerminalId() {
        return this._terminalId;
    }

    public Integer getBillType() {
        return this._billType;
    }

    public int getSpecialFieldQueryNumber() {
        return this._specialFieldQueryNumber;
    }

    public int getDsn() {
        return this._dsn;
    }

    public boolean isUnitMode() {
        return this._unitMode;
    }

    public String toMessage() {
        StringBuilder str = new StringBuilder();
        str.append('\u0002');
        str.append(this._account.toMessage());
        str.append(this._transactionType.getCode());
        str.append(FILE_SEPARATOR);
        str.append(this._pin);
        str.append(FILE_SEPARATOR);
        str.append(this._transactionDate);
        str.append(FILE_SEPARATOR);
        str.append(this._transactionTime);
        str.append(FILE_SEPARATOR);
        str.append(this._doBufferedTransactions ? (char)'T' : 'F');
        str.append(FILE_SEPARATOR);
        str.append(this._amountInCents);
        str.append(FILE_SEPARATOR);
        str.append(this._units);
        str.append(FILE_SEPARATOR);
        str.append(String.format("%05d", this._terminalId));
        str.append(FILE_SEPARATOR);
        str.append(this._billType);
        str.append(FILE_SEPARATOR);
        str.append(this._specialFieldQueryNumber);
        str.append(FILE_SEPARATOR);
        str.append(this._dsn);
        str.append(FILE_SEPARATOR);
        str.append(this._unitMode ? (char)'T' : 'F');
        str.append('\u0003');
        char lrc = RequestMessage.calculateLRC(str.toString().getBytes());
        str.append(lrc);
        return str.toString();
    }

    public String toString() {
        return ObjectUtils.createToStringBuilder((Object)this).append((Object)this._account.toString()).append("transactionType", (Object)this._transactionType).append("pin", (Object)this._pin).append("transactionDate", (Object)this._transactionDate).append("transactionTime", (Object)this._transactionTime).append("doBufferedTransactions", this._doBufferedTransactions).append("amountInCents", this._amountInCents).append("units", this._units).append("terminalId", this._terminalId).append("billType", this._billType).append("specialFieldQueryNumber", this._specialFieldQueryNumber).append("dsn", this._dsn).append("unitMode", this._unitMode).toString();
    }

    public static char calculateLRC(byte[] data) {
        int checksum = 0;
        for (int i = 1; i < data.length; ++i) {
            checksum ^= data[i];
        }
        return (char)checksum;
    }

    public static enum TransactionType {
        BalanceQuery("12"),
        RegularVend("4");

        private final String _code;

        private TransactionType(String code) {
            this._code = code;
        }

        public String getCode() {
            return this._code;
        }
    }
}

