/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.heartland;

import biz.papercut.pcng.ext.paymentgateway.heartland.ProtocolException;
import biz.papercut.pcng.util.ObjectUtils;

final class ResponseMessage {
    private final boolean _success;
    private final int _status;
    private final String _message;
    private final int _balance;
    private final String _units;
    private final String _specialHeader;
    private String _specialResponse;
    private final boolean _isAmount;

    private ResponseMessage(boolean success, int status, String message, int balance, String units, String specialHeader, String specialResponse, boolean isAmount) {
        this._success = success;
        this._status = status;
        this._message = message;
        this._balance = balance;
        this._units = units;
        this._specialHeader = specialHeader;
        this._isAmount = isAmount;
    }

    public boolean isSuccess() {
        return this._success;
    }

    public int getStatus() {
        return this._status;
    }

    public String getMessage() {
        return this._message;
    }

    public int getBalance() {
        return this._balance;
    }

    public String getUnits() {
        return this._units;
    }

    public String getSpecialHeader() {
        return this._specialHeader;
    }

    public String getSpecialResponse() {
        return this._specialResponse;
    }

    public boolean isAmount() {
        return this._isAmount;
    }

    public static ResponseMessage valueOf(String message) throws ProtocolException {
        boolean isAmount;
        boolean success;
        if (message.charAt(0) != '\u0002') {
            throw new ProtocolException("Missing start of text");
        }
        String[] split = message.split("\u001c|\u0002|\u0003");
        if (split.length != 9) {
            throw new ProtocolException("Wrong number of fields in response (expected 9 but got " + split.length + ")");
        }
        String resultStr = split[1];
        if (resultStr.charAt(0) == 'T') {
            success = true;
        } else if (resultStr.charAt(0) == 'F') {
            success = false;
        } else {
            throw new ProtocolException("Incorrect value for success field: " + resultStr);
        }
        String statusStr = split[2];
        int status = 0;
        try {
            status = Integer.parseInt(statusStr);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Non integer for status field: " + statusStr);
        }
        String messageStr = split[3].trim();
        String balanceStr = split[4];
        int balance = 0;
        try {
            balance = Integer.parseInt(balanceStr);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Non integer for balance field: " + balanceStr);
        }
        String unitsStr = split[5];
        String specialHeader = split[6];
        String specialResponse = split[7];
        String isAmountStr = split[8];
        if (isAmountStr.charAt(0) == 'T') {
            isAmount = true;
        } else if (isAmountStr.charAt(0) == 'F') {
            isAmount = false;
        } else {
            throw new ProtocolException("Incorrect value for isAmount field: " + isAmountStr);
        }
        if (message.charAt(message.length() - 1) != '\u0003') {
            throw new ProtocolException("Missing end of text field");
        }
        return new ResponseMessage(success, status, messageStr, balance, unitsStr, specialHeader, specialResponse, isAmount);
    }

    public String toString() {
        return ObjectUtils.createToStringBuilder((Object)this).append("success", this._success).append("status", this._status).append("message", (Object)this._message).append("balance", this._balance).append("units", (Object)this._units).append("specialHeader", (Object)this._specialHeader).append("specialResponse", (Object)this._specialResponse).append("isAmount", this._isAmount).toString();
    }
}

