/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.mock;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.plugin.ExtDevicePlugin;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin3;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin4;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.ApplicationException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class MockPaymentPlugin
implements TopupAccountOnDemandPlugin4,
ExtDevicePlugin,
SpringContextPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MockPaymentPlugin.class);
    private static final String EXT_DEVICE_PLUGIN_ID = "mock";
    private static final String CONFIG_PREFIX = "mock.";
    private final Random _random = new Random();
    @Nullable
    private volatile ApplicationContext _ctx;
    private final Map<String, Double> _userBalance = new HashMap<String, Double>();

    public MockPaymentPlugin() {
        logger.debug("Creating mock payment plugin");
    }

    private synchronized double getUserBalanceOrRandomInitialValue(String cardNo) {
        Double balance = this._userBalance.get(cardNo);
        if (balance == null) {
            balance = (double)this._random.nextInt(2000) / 100.0;
            this._userBalance.put(cardNo, balance);
            logger.debug("First time user. Balance: {}", (Object)balance);
        }
        return balance;
    }

    @Nullable
    @CheckForNull
    public TopupAccountOnDemandPlugin3.AvailableCredit getAvailableCreditForTopUp(String username, @Nullable String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            logger.debug("Shared accounts not supported");
            return null;
        }
        Double balance = this.getUserBalance(username);
        if (balance == null) {
            logger.debug("Cant find credit for user: {}", (Object)username);
            return null;
        }
        return new TopupAccountOnDemandPlugin3.AvailableCredit(false, balance.doubleValue());
    }

    private Double getUserBalance(String username) {
        User u = this.getUserManager().getUser(username);
        if (u == null) {
            logger.debug("Cannot find user: {}", (Object)username);
            return null;
        }
        String cardNo = u.getCardNumber();
        return this.getUserBalanceFromCardNo(cardNo, username);
    }

    private Double getUserBalanceFromCardNo(String cardNo, String userNameIfKnown) {
        if (StringUtils.isBlank((String)cardNo)) {
            logger.debug("Card number is blank for user: {}. Card number required for mock gateway", (Object)userNameIfKnown);
            return null;
        }
        Double balance = this.getUserBalanceOrRandomInitialValue(cardNo);
        if (balance == null) {
            logger.debug("No balance for card: {}, user: {}", (Object)cardNo, (Object)userNameIfKnown);
            return null;
        }
        logger.debug("Available balance for: {}, user: {}, balance: {}", new Object[]{cardNo, userNameIfKnown, balance});
        return balance;
    }

    private boolean performDebitWithCardNo(String cardNo, double amount) {
        if (StringUtils.isBlank((String)cardNo)) {
            logger.debug("Card no required to debit");
            return false;
        }
        Double balance = this.getUserBalanceOrRandomInitialValue(cardNo);
        if (balance == null) {
            logger.debug("No user, no debit");
            return false;
        }
        if (balance + 1.0E-5 < amount) {
            logger.debug("Not enough credit. Balance: {}, requested: {}", (Object)balance, (Object)amount);
            return false;
        }
        double newBalance = Math.max(0.0, balance - amount);
        logger.debug("Card: {}. Deducting: {} from balance: {}. New balance: {}", new Object[]{cardNo, amount, balance, newBalance});
        this._userBalance.put(cardNo, newBalance);
        return true;
    }

    public TopupAccountOnDemandPlugin.TopupResponse getTopup(double amountRequired, String username, String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged, Map<String, String> usageDetails) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            logger.debug("Shared accounts not supported");
            return null;
        }
        if (amountRequired <= 0.0) {
            return null;
        }
        return GatewayUtils.performTopupDebit((TopupAccountOnDemandPlugin3)this, amount -> {
            Double balance = this._userBalance.get(username);
            if (balance == null) {
                logger.debug("No user, no debit");
                return null;
            }
            if (balance + 1.0E-5 < amount) {
                logger.debug("Not enough credit. Balance: {}, requested: {}", (Object)balance, (Object)amount);
                return null;
            }
            double newBalance = Math.max(0.0, balance - amount);
            logger.debug("User: {}. Deducting: {} from balance: {}. New balance: {}", new Object[]{username, amount, balance, newBalance});
            this._userBalance.put(username, newBalance);
            return amount;
        }, amountRequired, amountRequired, username, sharedAccount, accountCharged, usageDetails, "mock gateway transaction");
    }

    public boolean isPluginEnabled() {
        return true;
    }

    public String getId() {
        return EXT_DEVICE_PLUGIN_ID;
    }

    public Hashtable<String, Object> call(Map<String, Object> args) {
        logger.debug("Call: {}", args);
        String action = (String)args.get("action");
        String cardNumber = (String)args.get("cardNumber");
        boolean success = false;
        Hashtable<String, Object> result = new Hashtable<String, Object>(5);
        if ("balance".equals(action) || "availableCredit".equals(action)) {
            Double balance = this.getUserBalanceFromCardNo(cardNumber, "");
            boolean bl = success = balance != null;
            if (balance != null) {
                result.put("balance", balance);
                result.put("availableCredit", balance);
            }
        } else if ("debit".equals(action)) {
            Double amount = (Double)args.get("amount");
            success = this.performDebitWithCardNo(cardNumber, amount);
            result.put("amount", success ? amount : -1.0);
        } else {
            throw new ApplicationException("Unknown action: " + action);
        }
        result.put("success", success);
        result.put("status", success ? "SUCCESS" : "FAILED");
        result.put("statusMessage", success ? "Succeeded" : "Failed");
        return result;
    }

    public Map<String, Double> getBalance(Map<String, String> userDetails) {
        logger.debug("Get balance: {}", userDetails);
        String username = userDetails.get("username");
        String card = userDetails.get("card");
        HashMap<String, Double> r = new HashMap<String, Double>();
        Double balance = StringUtils.isNotBlank((String)card) ? this.getUserBalanceFromCardNo(card, username) : (StringUtils.isNotBlank((String)username) ? this.getUserBalance(username) : null);
        if (balance == null) {
            logger.debug("No balance for user: {}", userDetails);
            return null;
        }
        logger.debug("Balance for user: {}: {}", (Object)username, (Object)balance);
        r.put("Upay credits", balance);
        return r;
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    public ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }
}

