/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.monerisCheckout;

import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.monerisCheckout.MonerisPreloadRequest;
import biz.papercut.pcng.ext.paymentgateway.monerisCheckout.MonerisPreloadResponse;
import biz.papercut.pcng.ext.paymentgateway.monerisCheckout.MonerisReceiptRequest;
import biz.papercut.pcng.ext.paymentgateway.monerisCheckout.MonerisReceiptResponse;
import biz.papercut.pcng.ext.paymentgateway.monerisCheckout.MonerisRequest;
import biz.papercut.pcng.ext.paymentgateway.monerisCheckout.MonerisResponseParser;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class MonerisCheckoutPlugin
implements UserLinkPlugin,
SpringContextPlugin,
EnableablePlugin {
    protected static final Logger logger = LoggerFactory.getLogger(MonerisCheckoutPlugin.class);
    private static final String CONFIG_PREFIX = "moneris-checkout.";
    public static final String CONFIG_ENABLED = "moneris-checkout.enabled";
    public static final String CONFIG_STORE_ID = "moneris-checkout.store-id";
    @AESProperty
    public static final String CONFIG_API_TOKEN = "moneris-checkout.api-token";
    @AESProperty
    public static final String CONFIG_CHECKOUT_ID = "moneris-checkout.checkout-id";
    public static final String CONFIG_ENVIRONMENT = "moneris-checkout.environment";
    public static final String CONFIG_PAYMENT_PAGE_URL = "moneris-checkout.payment-page-url";
    public static final String CONFIG_PAYMENT_PAGE_CLIENT_URL = "moneris-checkout.payment-page-client-url";
    public static final String CONFIG_LANGUAGE = "moneris-checkout.language";
    public static final String CONFIG_RECEIPT_PAGE_CURRENCY = "moneris-checkout.receipt-page-currency";
    public static final String CONFIG_PAGE_TITLE = "moneris-checkout.page-title";
    public static final String CONFIG_PAGE_HEADING = "moneris-checkout.page-heading";
    public static final String CONFIG_SUCCESS_MESSAGE = "moneris-checkout.success-message";
    public static final String CONFIG_DECLINED_MESSAGE = "moneris-checkout.declined-message";
    public static final String CONFIG_ALLOWED_GROUPS = "moneris-checkout.allowed-groups";
    public static final String CONFIG_ALLOWED_AMOUNTS = "moneris-checkout.allowed-amounts";
    private static final int READ_TIMEOUT_SECS = 60;
    private static final List<String> PAGES = List.of("ExtnMonerisCheckout");
    private ApplicationContext applicationContext;
    private final Map<String, MonerisOrder> monerisOrders = Collections.synchronizedMap(new HashMap());
    private final OkHttpClient httpClient = this.buildHttpClient();

    private OkHttpClient buildHttpClient() {
        return new OkHttpClient.Builder().readTimeout(60L, TimeUnit.SECONDS).build();
    }

    public boolean isPluginEnabled() {
        Boolean enabled = this.getGatewayConfig().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public boolean isLicensed() {
        LicenseManager lm = (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
        return GatewayUtils.isLicensed(lm, "payment-gateways-moneris");
    }

    public String getIsConfigured() {
        GatewayConfig conf = this.getGatewayConfig();
        String errorSuffix = "  Please check the payment gateway config file.";
        String errorContent = this.validateRequiredValues(conf);
        if (StringUtils.isNotBlank((String)errorContent)) {
            EventLog.getInstance().logEvent(errorContent);
            return errorContent + errorSuffix;
        }
        return null;
    }

    private String validateRequiredValues(GatewayConfig conf) {
        if (StringUtils.isBlank((String)conf.getString(CONFIG_STORE_ID))) {
            return "Store ID is not provided.";
        }
        if (StringUtils.isBlank((String)conf.getString(CONFIG_API_TOKEN))) {
            return "API Token is not provided.";
        }
        if (StringUtils.isBlank((String)conf.getString(CONFIG_CHECKOUT_ID))) {
            return "Checkout ID is not provided.";
        }
        String environment = conf.getString(CONFIG_ENVIRONMENT);
        if (StringUtils.isBlank((String)environment)) {
            return "Environment is not provided.";
        }
        if (!MonerisRequest.getSupportedEnvironment().contains(environment)) {
            return String.format("Environment, %s, is not supported.", environment);
        }
        String paymentUrlValue = conf.getString(CONFIG_PAYMENT_PAGE_URL);
        if (StringUtils.isBlank((String)paymentUrlValue)) {
            return "Payment page url is not provided";
        }
        URL paymentUrl = null;
        try {
            paymentUrl = this.getPaymentPayUrl();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (paymentUrl == null) {
            return String.format("Payment page url is invalid, %s", paymentUrlValue);
        }
        String clientUrlValue = conf.getString(CONFIG_PAYMENT_PAGE_CLIENT_URL);
        if (StringUtils.isBlank((String)clientUrlValue)) {
            return "Payment Javascript client url is not provided";
        }
        URL clientURL = null;
        try {
            clientURL = this.getPaymentPageJSClient();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (clientURL == null) {
            return String.format("Payment Javascript client url is invalid, %s", clientUrlValue);
        }
        if (StringUtils.isBlank((String)conf.getString(CONFIG_ALLOWED_AMOUNTS))) {
            return "Must specify at least one allowed payment amount.";
        }
        return null;
    }

    public boolean isAccessibleByUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        return GatewayUtils.isAccessibleByUser(username, CONFIG_ALLOWED_GROUPS, this.getUserManager());
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return PAGES;
        }
        return Collections.emptyList();
    }

    @CheckForNull
    public String getPageTitle() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PAGE_TITLE));
    }

    public String getReceiptPageCurrency() {
        return this.getGatewayConfig().getString(CONFIG_RECEIPT_PAGE_CURRENCY);
    }

    public String getEnvironment() {
        return this.getGatewayConfig().getString(CONFIG_ENVIRONMENT);
    }

    public URL getPaymentPayUrl() throws MalformedURLException {
        return this.getGatewayConfig().getURL(CONFIG_PAYMENT_PAGE_URL);
    }

    public URL getPaymentPageJSClient() throws MalformedURLException {
        return this.getGatewayConfig().getURL(CONFIG_PAYMENT_PAGE_CLIENT_URL);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public CreditCardGatewayPlugin getCreditCardGatewayPlugin() {
        return (CreditCardGatewayPlugin)PluginManager.getInstance().getPluginByClass(CreditCardGatewayPlugin.class);
    }

    public MonerisOrder createNewOrder(String username, double amount) {
        String orderID = this.getCreditCardGatewayPlugin().createNewOrder(username, amount);
        String ticketID = this.generateTicketID(orderID, amount);
        if (StringUtils.isBlank((String)ticketID)) {
            logger.error("Could not generate ticketID from Moneris server");
            return null;
        }
        MonerisOrder order = new MonerisOrder(orderID, ticketID);
        this.monerisOrders.put(orderID, order);
        return order;
    }

    public void cancelTransaction(String orderID) {
        this.monerisOrders.remove(orderID);
        this.getCreditCardGatewayPlugin().cancelOrder(orderID);
    }

    public MonerisReceiptResponse verifyTransaction(String orderID) {
        String infoMsg = String.format("Verifying Moneris payment with orderID %s", orderID);
        logger.info(infoMsg);
        EventLog.getInstance().logEvent(infoMsg);
        MonerisOrder order = this.monerisOrders.remove(orderID);
        if (order == null) {
            String msg = String.format("Moneris order not found with orderID, %s", orderID);
            logger.error(msg);
            EventLog.getInstance().logEvent(msg);
            return null;
        }
        MonerisReceiptResponse receipt = this.getMonerisReceipt(order.getTicketID());
        if (receipt == null) {
            String msg = String.format("Unable to get Moneris receipt with ticketID %s", order.getTicketID());
            logger.error(msg);
            EventLog.getInstance().logEvent(msg);
            return null;
        }
        if (!receipt.isSuccess() || receipt.getReceipt() == null || !receipt.getReceipt().isAccepted()) {
            String msg = String.format("Moneris payment with ticketID %s is not successful or not accepted.", order.getTicketID());
            logger.error(msg);
            EventLog.getInstance().logEvent(msg);
            return receipt;
        }
        CreditCardGatewayPlugin.OrderResponse orderResponse = this.getCreditCardGatewayPlugin().confirmOrder(orderID, receipt.getReceipt().getCreditCard().getTransactionNumber(), receipt.getRequest().getTransactionAmount());
        if (!orderResponse.isSuccess()) {
            String msg = "Could not confirm order " + orderID + ", message: " + orderResponse.getMessage() + ". Order was finalized but user has not received credit. Manual reconciliation is required.";
            logger.error(msg);
            EventLog.getInstance().logEvent(msg);
            return null;
        }
        return receipt;
    }

    private Request buildRequestData(Object data) throws MalformedURLException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)mapper.writeValueAsString(data));
        URL pageUrl = this.getPaymentPayUrl();
        return new Request.Builder().url(pageUrl).post(body).build();
    }

    public String generateTicketID(String orderID, double amount) {
        try {
            Request request = this.buildRequestData(this.buildMonerisPreloadRequest(orderID, amount));
            Response response = this.httpClient.newCall(request).execute();
            if (response.isSuccessful() && response.body() != null) {
                MonerisPreloadResponse preloadResponse = MonerisResponseParser.jsonToPreloadResponse(response.body().string());
                if (preloadResponse.isSuccess()) {
                    return preloadResponse.getTicket();
                }
                logger.error("Preload request {} received error messages {}", (Object)request, preloadResponse.getErrors());
                return null;
            }
            logger.error("Preload request {} not successful: {}", (Object)request, (Object)response);
        }
        catch (Exception e) {
            logger.error("Generate ticketID with orderID {} and amount {}: {}", new Object[]{orderID, amount, e});
        }
        return null;
    }

    public MonerisReceiptResponse getMonerisReceipt(String ticketID) {
        try {
            Request request = this.buildRequestData(this.buildMonerisReceiptRequest(ticketID));
            Response response = this.httpClient.newCall(request).execute();
            if (response.body() == null) {
                logger.error("Request receipt with ticketID {} received empty body with response: {}", (Object)ticketID, (Object)response);
                return null;
            }
            return MonerisResponseParser.jsonToReceiptResponse(response.body().string());
        }
        catch (Exception ex) {
            logger.error("Request receipt with ticketID {}: {}", (Object)ticketID, (Object)ex);
            return null;
        }
    }

    private MonerisPreloadRequest buildMonerisPreloadRequest(String orderID, double amount) {
        GatewayConfig conf = this.getGatewayConfig();
        return new MonerisPreloadRequest(conf.getString(CONFIG_STORE_ID), conf.getString(CONFIG_API_TOKEN), conf.getString(CONFIG_CHECKOUT_ID), conf.getString(CONFIG_ENVIRONMENT), amount, orderID, conf.getString(CONFIG_LANGUAGE));
    }

    private MonerisReceiptRequest buildMonerisReceiptRequest(String ticketID) {
        GatewayConfig conf = this.getGatewayConfig();
        return new MonerisReceiptRequest(conf.getString(CONFIG_STORE_ID), conf.getString(CONFIG_API_TOKEN), conf.getString(CONFIG_CHECKOUT_ID), conf.getString(CONFIG_ENVIRONMENT), ticketID);
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    public static String formatTransactionAmount(double amount) {
        return GatewayUtils.formatNumber(amount, 2, Locale.US, false);
    }

    public static class MonerisOrder {
        private final String orderID;
        private final String ticketID;

        public MonerisOrder(String orderID, String ticketID) {
            this.orderID = orderID;
            this.ticketID = ticketID;
        }

        public String getOrderID() {
            return this.orderID;
        }

        public String getTicketID() {
            return this.ticketID;
        }
    }
}

