/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.monerisCheckout;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MonerisReceiptCreditCardInformation {
    @JsonProperty(value="order_no")
    private String orderNumber;
    @JsonProperty(value="cust_id")
    private String customerID;
    @JsonProperty(value="transaction_no")
    private String transactionNumber;
    @JsonProperty(value="reference_no")
    private String referenceNumber;
    @JsonProperty(value="transaction_code")
    private String transactionCode;
    @JsonProperty(value="transaction_type")
    private String transactionType;
    @JsonProperty(value="transaction_date_time")
    private String transactionDate;
    @JsonProperty(value="amount")
    private double amount;
    @JsonProperty(value="response_code")
    private String responseCode;
    @JsonProperty(value="iso_response_code")
    private String isoResponseCode;
    @JsonProperty(value="approval_code")
    private String approvalCode;
    @JsonProperty(value="card_type")
    private String cardType;
    @JsonProperty(value="invoice_number")
    private String invoiceNumber;
    @JsonProperty(value="customer_code")
    private String customerCode;
    @JsonProperty(value="cvd_result_code")
    private String cvdResultCode;
    @JsonProperty(value="avs_result_code")
    private String avsResultCode;
    @JsonProperty(value="cavv_result_code")
    private String cavvResultCode;
    @JsonProperty(value="first6last4")
    private String first6last4;
    @JsonProperty(value="expiry_date")
    private String expiryDate;
    @JsonProperty(value="issuer_id")
    private String issuerID;
    @JsonProperty(value="is_debit")
    private boolean isDebit;
    @JsonProperty(value="batch_no")
    private String batchNumber;
    @JsonProperty(value="sequence_no")
    private String sequenceNumber;

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public String getCustomerID() {
        return this.customerID;
    }

    public String getTransactionNumber() {
        return this.transactionNumber;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public String getTransactionCode() {
        return this.transactionCode;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String getTransactionFinancialType() {
        return CreditCardFinancialTransactionType.getFinancialTypeName(this.transactionCode);
    }

    public String getTransactionDate() {
        return this.transactionDate;
    }

    public double getAmount() {
        return this.amount;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public String getIsoResponseCode() {
        return this.isoResponseCode;
    }

    public String getApprovalCode() {
        return this.approvalCode;
    }

    public String getCardType() {
        return this.cardType;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public String getCvdResultCode() {
        return this.cvdResultCode;
    }

    public String getAvsResultCode() {
        return this.avsResultCode;
    }

    public String getCavvResultCode() {
        return this.cavvResultCode;
    }

    public String getFirst6last4() {
        return this.first6last4;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public String getIssuerID() {
        return this.issuerID;
    }

    public boolean isDebit() {
        return this.isDebit;
    }

    public String getBatchNumber() {
        return this.batchNumber;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public static enum CreditCardFinancialTransactionType {
        PURCHASE("Purchase", "00"),
        PRE_AUTHORIZATION("Pre-Authorization", "01");

        private final String financialTypeName;
        private final String transactionCode;

        private CreditCardFinancialTransactionType(String financialTypeName, String transactionCode) {
            this.financialTypeName = financialTypeName;
            this.transactionCode = transactionCode;
        }

        public static String getFinancialTypeName(String transactionCode) {
            for (CreditCardFinancialTransactionType type : CreditCardFinancialTransactionType.values()) {
                if (!type.transactionCode.equals(transactionCode)) continue;
                return type.financialTypeName;
            }
            return "";
        }
    }
}

