/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.nelnet;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.BasePaymentGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.nelnet.NelnetPlugin;
import biz.papercut.pcng.ext.paymentgateway.pages.BasePaymentGatewayPage;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.util.Checksum;
import biz.papercut.pcng.web.util.WebUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnNelnet
extends BasePaymentGatewayPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(ExtnNelnet.class);
    public static final String PAGE_NAME = "ExtnNelnet";
    public static final String REDIRECT_PARAMS = "transactionType,transactionStatus,transactionId,transactionTotalAmount,transactionDate,transactionAcountType,transactionDescription,transactionResultCode,transactionResultMessage,orderNumber,orderAmount,payerType,payerIdentifier,payerFullName,userChoice8,userChoice9,userChoice10";

    @Override
    public abstract AccountManager getAccountManager();

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(this.createAmountsModel());
        }
        if (!this.getRequestCycle().isRewinding()) {
            String configError;
            if (!this.getNelnetPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = this.getNelnetPlugin().getIsConfigured()) != null) {
                this.addErrorMessage(configError);
                logger.error(configError);
            }
        }
    }

    public void formSubmit(IRequestCycle cycle) {
        if (this.getAmount() == null) {
            this.addErrorMessage("Please select an amount to add");
            return;
        }
        if (this.getNelnetPlugin().getIsConfigured() != null) {
            return;
        }
        String orderId = this.getNelnetPlugin().createNewOrder(this.getPaperCutVisit().getUserName(), this.getAmount());
        StringBuilder hashData = new StringBuilder();
        StringBuilder url = new StringBuilder();
        url.append(this.getNelnetPlugin().getHostedPaymentPageURL());
        url.append("?");
        hashData.append(this.getNelnetPlugin().getOrderType());
        url.append("orderType=").append(this.getNelnetPlugin().getOrderType());
        hashData.append(orderId);
        url.append("&orderNumber=").append(this.encode(orderId));
        String amountStr = GatewayUtils.formatNumber(this.getAmount() * 100.0, 0, Locale.US, false);
        hashData.append(amountStr);
        url.append("&").append(this.getNelnetPlugin().getAmountParamName()).append("=").append(amountStr);
        HttpServletRequest r = this.getRequest();
        hashData.append(r.getScheme());
        url.append("&userChoice8=").append(this.encode(r.getScheme()));
        hashData.append(r.getServerName());
        url.append("&userChoice9=").append(this.encode(r.getServerName()));
        hashData.append(r.getServerPort());
        url.append("&userChoice10=").append(r.getServerPort());
        String redirectURL = this.getNelnetPlugin().getRedirectPageURL();
        hashData.append(redirectURL);
        url.append("&redirectUrl=").append(this.encode(redirectURL));
        hashData.append(REDIRECT_PARAMS);
        url.append("&redirectUrlParameters=").append(REDIRECT_PARAMS);
        String retriesAllowedStr = Integer.toString(this.getNelnetPlugin().getRetriesAllowed());
        hashData.append(retriesAllowedStr);
        url.append("&retriesAllowed=").append(retriesAllowedStr);
        long timeStampMillis = System.currentTimeMillis();
        hashData.append(timeStampMillis);
        url.append("&timestamp=").append(timeStampMillis);
        hashData.append(this.getNelnetPlugin().getSecretKey());
        String hash = Checksum.getMD5Sum((String)hashData.toString());
        url.append("&hash=").append(hash);
        WebUtils.redirectToURL((IRequestCycle)cycle, (String)url.toString());
    }

    private String encode(String s) {
        if (s == null) {
            return "";
        }
        return URLEncoder.encode(s, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public void redirectToSummaryPage(IRequestCycle cycle) {
        cycle.activate("UserSummary");
    }

    @Override
    public BasePaymentGatewayPlugin getPlugin() {
        return this.getNelnetPlugin();
    }

    public void activateExternalPage(Object[] arguments, IRequestCycle cycle) {
        HttpServletRequest r = this.getRequest();
        String success = r.getParameter("success");
        String message = r.getParameter("message");
        if (Boolean.parseBoolean(success)) {
            Object statusMessage = "Funds have been added to your account";
            if (StringUtils.isNotBlank((String)message)) {
                statusMessage = (String)statusMessage + ". " + message;
            }
            this.addStatusMessage((String)statusMessage);
        } else if (StringUtils.isBlank((String)message)) {
            this.addErrorMessage(this.getNelnetPlugin().getUserErrorMessage());
        } else {
            this.addErrorMessage(message);
        }
    }

    public String getPageContentAbove() {
        return this.getNelnetPlugin().getPageContentAbove();
    }

    public String getPageContentBelow() {
        return this.getNelnetPlugin().getPageContentBelow();
    }

    private NelnetPlugin getNelnetPlugin() {
        return (NelnetPlugin)PluginManager.getInstance().getPluginByClass(NelnetPlugin.class);
    }
}

