/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.nelnet;

import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.BasePaymentGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.ParameterMapValuesStringBuilder;
import biz.papercut.pcng.ext.paymentgateway.PaymentGatewayRequestLogMessageBuilder;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.WebServerPlugin;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.util.Checksum;
import com.papercut.server.lang.service.ApplicationLogLevelEnum;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NelnetPlugin
extends BasePaymentGatewayPlugin
implements WebServerPlugin {
    protected static final Logger logger = LoggerFactory.getLogger(NelnetPlugin.class);
    public static final String BASE_SERVLET_PATH = "/rpc/gateway/nelnet";
    public static final String CONFIG_PREFIX = "nelnet.";
    public static final String CONFIG_ORDER_TYPE = "order-type";
    public static final String CONFIG_TEST_MODE = "test-mode";
    @AESProperty
    public static final String CONFIG_SECRET_KEY = "nelnet.secret-key";
    public static final String CONFIG_PAGE_CONTENT_ABOVE = "page-content-above";
    public static final String CONFIG_PAGE_CONTENT_BELOW = "page-content-below";
    public static final String CONFIG_HOSTED_PAYMENT_PAGE_URL = "hosted-payment-page-url";
    public static final String CONFIG_REDIRECT_PAGE_URL = "redirect-page-url";
    public static final String CONFIG_TIMEOUT_WINDOW_SECS = "timeout-window-secs";
    public static final String CONFIG_RETRIES_ALLOWED = "retries-allowed";
    public static final int TRANS_CREDIT_PAYMENT = 1;
    public static final int TRANS_ECHECK_PAYMENT = 3;
    public static final int CREDIT_ACCEPT = 1;
    public static final int ECHECK_ACCEPT = 5;
    private static final List<String> PAGES = List.of("ExtnNelnet");
    public static final String AMOUNT_PARAM_NAME = "amount-parameter-name";

    @Override
    public String getConfigPrefix() {
        return CONFIG_PREFIX;
    }

    @Override
    public boolean isLicensed() {
        LicenseManager lm = (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
        return GatewayUtils.isLicensed(lm, "payment-gateways-nelnet");
    }

    public String createNewOrder(String username, double amount) {
        return this.getCreditCardGatewayPlugin().createNewOrder(username, amount);
    }

    public String getIsConfigured() {
        String errorSuffix = "  Please check the payment gateway config file.";
        if (this.getOrderType() == null) {
            EventLog.getInstance().logEvent("Order Type not provided.");
            return "Order Type not provided." + errorSuffix;
        }
        if (this.getSecretKey() == null) {
            EventLog.getInstance().logEvent("Secret key not provided.");
            return "Secret key not provided." + errorSuffix;
        }
        if (this.getAllowedAmounts() == null) {
            EventLog.getInstance().logEvent("Must specify at least one allowed payment amount.");
            return "Must specify at least one allowed payment amount." + errorSuffix;
        }
        if (this.getHostedPaymentPageURL() == null) {
            EventLog.getInstance().logEvent("Invalid hosted payment page URL: " + this.getGatewayConfig().getString("nelnet.hosted-payment-page-url") + ".");
            return "Invalid hosted payment page URL." + errorSuffix;
        }
        if (this.getRedirectPageURL() == null) {
            EventLog.getInstance().logEvent("Invalid redirect page URL: " + this.getGatewayConfig().getString("nelnet.redirect-page-url") + ".");
            return "Invalid redirect page URL." + errorSuffix;
        }
        if (this.getTimeoutWindowSecs() < 0L) {
            EventLog.getInstance().logEvent("Invalid timeout window.");
            return "Invalid timeout window." + errorSuffix;
        }
        if (this.getRetriesAllowed() < 0) {
            EventLog.getInstance().logEvent("Invalid retries allowed parameter.");
            return "Invalid retries allowed parameter." + errorSuffix;
        }
        return null;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return PAGES;
        }
        return null;
    }

    public void preStartupHook(WebServerPlugin.WebServer server) {
        if (!this.isPluginEnabled()) {
            return;
        }
        server.addServlet(NelnetStatusServlet.class, "/rpc/gateway/nelnet/*");
    }

    public String getOrderType() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString("nelnet.order-type"));
    }

    public String getSecretKey() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_SECRET_KEY));
    }

    public String getPageContentAbove() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString("nelnet.page-content-above"));
    }

    public String getPageContentBelow() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString("nelnet.page-content-below"));
    }

    public String getHostedPaymentPageURL() {
        try {
            return this.getGatewayConfig().getURL("nelnet.hosted-payment-page-url").toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getRedirectPageURL() {
        try {
            return this.getGatewayConfig().getURL("nelnet.redirect-page-url").toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getTimeoutWindowSecs() {
        try {
            return this.getGatewayConfig().getInteger("nelnet.timeout-window-secs").intValue();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public int getRetriesAllowed() {
        try {
            return this.getGatewayConfig().getInteger("nelnet.retries-allowed");
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String getAmountParamName() {
        try {
            String amount_param_name = StringUtils.trimToEmpty((String)this.getGatewayConfig().getString("nelnet.amount-parameter-name"));
            if (!amount_param_name.isEmpty()) {
                EventLog.getInstance().logEvent("None standard name configured for amount: " + amount_param_name);
                return amount_param_name;
            }
            return "amount";
        }
        catch (Exception e) {
            return "amount";
        }
    }

    private String validateRedirectParams(Map<String, String> parameters) {
        String[] orderedParams = "transactionType,transactionStatus,transactionId,transactionTotalAmount,transactionDate,transactionAcountType,transactionDescription,transactionResultCode,transactionResultMessage,orderNumber,orderAmount,payerType,payerIdentifier,payerFullName,userChoice8,userChoice9,userChoice10".split(",");
        StringBuilder hashData = new StringBuilder();
        for (String ordParam : orderedParams) {
            if (!parameters.containsKey(ordParam)) {
                return ordParam;
            }
            hashData.append(parameters.get(ordParam));
        }
        if (!parameters.containsKey("timestamp")) {
            return "timestamp missing";
        }
        hashData.append(parameters.get("timestamp"));
        long currentTimeMillis = System.currentTimeMillis();
        long timeStampMillis = Long.parseLong(parameters.get("timestamp"));
        if (timeStampMillis + this.getTimeoutWindowSecs() * 1000L < currentTimeMillis) {
            return "timestamp too old: timestamp=" + timeStampMillis + " now=" + currentTimeMillis;
        }
        hashData.append(this.getSecretKey());
        if (!parameters.containsKey("hash")) {
            return "hash missing";
        }
        String hashDigest = Checksum.getMD5Sum((String)hashData.toString());
        if (!hashDigest.equals(parameters.get("hash"))) {
            return "hash mismatch: " + hashDigest + " vs " + parameters.get("hash");
        }
        return null;
    }

    protected void processTransaction(Map<String, String> parameters) {
        CreditCardGatewayPlugin.OrderResponse response = null;
        String transactionId = parameters.get("transactionId");
        String orderId = parameters.get("orderNumber");
        String amount = parameters.get("orderAmount");
        String logSuffix = " Transaction id: " + transactionId + ", order id: " + orderId + ", payment amount: " + amount + ".";
        String fullDetails = " Reported transaction details: " + NelnetPlugin.buildStringFromParameters(parameters);
        String errString = this.validateRedirectParams(parameters);
        if (errString != null) {
            String msg = "Nelnet transaction response contains invalid payment response data. Problem with parameter: \"" + errString + "\" Order will not be confirmed." + logSuffix;
            logger.error("{}{}", (Object)msg, (Object)fullDetails);
            EventLog.getInstance().logEvent("ERROR: " + msg + fullDetails);
            this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg);
            this.getCreditCardGatewayPlugin().cancelOrder(orderId);
            return;
        }
        if (!this.isTransactionApproved(parameters)) {
            String msg = "Order was canceled or declined by Nelnet." + logSuffix;
            logger.info(msg);
            EventLog.getInstance().logEvent(msg);
            this.getCreditCardGatewayPlugin().cancelOrder(orderId);
            return;
        }
        Double paymentAmount = null;
        try {
            paymentAmount = Double.valueOf(amount);
            paymentAmount = paymentAmount / 100.0;
        }
        catch (Exception e) {
            String msg = "Invalid transaction amount." + logSuffix;
            logger.error(msg);
            EventLog.getInstance().logEvent("ERROR: " + msg);
            this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg);
            this.getCreditCardGatewayPlugin().cancelOrder(orderId);
            return;
        }
        response = this.getCreditCardGatewayPlugin().confirmOrder(orderId, paymentAmount);
        if (response.isSuccess()) {
            String msg = "Order confirmed." + logSuffix;
            logger.info(msg);
            EventLog.getInstance().logEvent(msg);
        } else {
            String msg = "Could not confirm Nelnet order. Message: " + response.getMessage() + ". Manual reconciliation may be required." + logSuffix;
            logger.error("{}{}", (Object)msg, (Object)fullDetails);
            EventLog.getInstance().logEvent("ERROR: " + msg + fullDetails);
            this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg);
        }
    }

    protected String processUserReturn(HttpServletRequest request, Map<String, String> parameters) {
        String orderId = parameters.get("orderNumber");
        String message = parameters.get("transactionResultMessage");
        String scheme = parameters.get("userChoice8");
        String server = parameters.get("userChoice9");
        String port = parameters.get("userChoice10");
        CreditCardGatewayPlugin.OrderResponse response = this.getCreditCardGatewayPlugin().getExistingOrderReponse(orderId);
        if (response == null) {
            String msg = "Tried to send user back to the web interface but the provided order id does not exist or has not yet been processed.  Order id: " + orderId + ". Sending user to login page.";
            logger.error(msg);
            EventLog.getInstance().logEvent("ERROR: " + msg);
            return "/";
        }
        StringBuilder returnRedirectURL = new StringBuilder();
        returnRedirectURL.append(scheme);
        returnRedirectURL.append("://");
        returnRedirectURL.append(server);
        returnRedirectURL.append(":");
        returnRedirectURL.append(port);
        returnRedirectURL.append("/app?service=external/");
        returnRedirectURL.append("ExtnNelnet");
        returnRedirectURL.append("&success=");
        returnRedirectURL.append(response.isSuccess());
        if (StringUtils.isNotBlank((String)message)) {
            returnRedirectURL.append("&message=");
            returnRedirectURL.append(message);
        }
        String msg = "User returned from payment pages, redirecting to: " + String.valueOf(returnRedirectURL);
        logger.debug(msg);
        EventLog.getInstance().logEvent(msg);
        return returnRedirectURL.toString();
    }

    private boolean isTransactionApproved(Map<String, String> parameters) {
        int transactionType;
        int transactionStatus;
        try {
            transactionStatus = Integer.parseInt(parameters.get("transactionStatus"));
            transactionType = Integer.parseInt(parameters.get("transactionType"));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return transactionType == 1 && transactionStatus == 1 || transactionType == 3 && transactionStatus == 5;
    }

    private static String buildStringFromParameters(Map<String, ?> parameterMap) {
        ParameterMapValuesStringBuilder stringBuilder = new ParameterMapValuesStringBuilder(parameterMap);
        NelnetPlugin.getParametersToLog().forEach(stringBuilder::add);
        return stringBuilder.build();
    }

    private static List<String> getParametersToLog() {
        return List.of("transactionId", "orderNumber", "orderAmount", "transactionResultMessage", "userChoice8", "userChoice9", "userChoice10", "transactionStatus", "transactionType");
    }

    public static class NelnetStatusServlet
    extends HttpServlet {
        private final PaymentGatewayRequestLogMessageBuilder logMessageBuilder = new PaymentGatewayRequestLogMessageBuilder("Nelnet servlet").withSelectedParameters(NelnetPlugin.getParametersToLog());

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.debugLogRequest(request);
            Map<String, String> parameters = this.normalizeParameterValues(request.getParameterMap());
            this.getNelnetPlugin().processTransaction(parameters);
            String returnRedirectURL = this.getNelnetPlugin().processUserReturn(request, parameters);
            response.sendRedirect(returnRedirectURL);
        }

        private Map<String, String> normalizeParameterValues(Map<String, String[]> parameters) {
            HashMap<String, String> normalizedParameters = new HashMap<String, String>(parameters.size());
            for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                normalizedParameters.put(entry.getKey(), StringUtils.join((Object[])entry.getValue(), (String)","));
            }
            return normalizedParameters;
        }

        private NelnetPlugin getNelnetPlugin() {
            return (NelnetPlugin)PluginManager.getInstance().getPluginByClass(NelnetPlugin.class);
        }

        private void debugLogRequest(HttpServletRequest request) {
            String logMessage = this.buildLogMessageFromRequest(request);
            logger.debug(logMessage);
            EventLog.getInstance().logEvent(logMessage);
        }

        String buildLogMessageFromRequest(HttpServletRequest request) {
            return this.logMessageBuilder.buildFrom(request);
        }
    }
}

