/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.networkapi;

import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.networkapi.NetworkAPIPlugin;
import biz.papercut.pcng.ext.paymentgateway.networkapi.NetworkAPIRequest;
import biz.papercut.pcng.ext.paymentgateway.networkapi.NetworkAPIResponse;
import biz.papercut.pcng.server.ServerConfig;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAPIConnectionManager {
    private static final Logger logger = LoggerFactory.getLogger(NetworkAPIConnectionManager.class);
    private final OkHttpClient client = this.buildHttpClient();
    private final String host = NetworkAPIPlugin.getInstance().getHost();
    private final int port = NetworkAPIPlugin.getInstance().getPort();
    private final int timeout = NetworkAPIPlugin.getInstance().getTimeout();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public NetworkAPIResponse sendRequest(NetworkAPIRequest apiRequest) {
        NetworkAPIResponse networkAPIResponse;
        block10: {
            RequestBody body;
            String url = this.buildURL(apiRequest.getRequestType().toApiEndpoint());
            try {
                body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.objectMapper.writeValueAsString((Object)apiRequest));
            }
            catch (JsonProcessingException e) {
                logger.error("Error processing JSON");
                return null;
            }
            Request.Builder request = new Request.Builder().url(url);
            request.post(body);
            Response response = this.client.newCall(request.build()).execute();
            try {
                networkAPIResponse = new NetworkAPIResponse(response);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Error while sending request: {}", (Object)String.valueOf(e));
                    EventLog.getInstance().logEvent("Error while sending request: " + String.valueOf(e));
                    return null;
                }
            }
            response.close();
        }
        return networkAPIResponse;
    }

    private String buildURL(String endpoint) {
        HttpUrl.Builder httpUrlBuilder = new HttpUrl.Builder().scheme("https").host(this.host).port(this.port).addPathSegment(endpoint);
        return httpUrlBuilder.build().toString();
    }

    private OkHttpClient buildHttpClient() {
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        try (FileInputStream localKeyStore = new FileInputStream(ServerConfig.getInstance().getExtensionHome() + "/keystore.jks");){
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            final X509TrustManager defaultTrustManager = this.getX509TrustManager(trustManagerFactory.getTrustManagers());
            KeyStore customTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            customTrustStore.load(localKeyStore, "default".toCharArray());
            trustManagerFactory.init(customTrustStore);
            final X509TrustManager localTrustManager = this.getX509TrustManager(trustManagerFactory.getTrustManagers());
            X509TrustManager customTrustManager = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return defaultTrustManager.getAcceptedIssuers();
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    try {
                        defaultTrustManager.checkServerTrusted(chain, authType);
                    }
                    catch (CertificateException e) {
                        localTrustManager.checkServerTrusted(chain, authType);
                    }
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    defaultTrustManager.checkClientTrusted(chain, authType);
                }
            };
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{customTrustManager}, null);
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            httpClient.sslSocketFactory(sslSocketFactory, customTrustManager);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            logger.error("Error verifying certificate", (Throwable)e);
        }
        httpClient.readTimeout((long)this.timeout, TimeUnit.SECONDS).connectTimeout((long)this.timeout, TimeUnit.SECONDS);
        httpClient.addInterceptor(chain -> {
            Request original = chain.request();
            Headers headers = new Headers.Builder().add("PG-Access-Token", NetworkAPIPlugin.getInstance().getSharedSecret()).build();
            Request request = original.newBuilder().headers(headers).build();
            return chain.proceed(request);
        });
        return httpClient.build();
    }

    private X509TrustManager getX509TrustManager(TrustManager[] trustManagers) {
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        return null;
    }
}

