/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.networkapi;

import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.networkapi.UserInformationType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAPIPlugin {
    private static final Logger logger = LoggerFactory.getLogger(NetworkAPIPlugin.class);
    private static NetworkAPIPlugin instance;
    private final List<UserInformationType> userInformationList = new ArrayList<UserInformationType>();
    private static final String CONFIG_PREFIX = "network-api.";
    private static final String CONFIG_ENABLED = "network-api.on-demand-transfer.enabled";
    private static final String CONFIG_EXTERNAL_USER_IDS = "network-api.external-user-ids";
    private static final String CONFIG_USER_BALANCE_DISPLAY = "network-api.user-balance-display.enabled";
    private static final String CONFIG_BALANCE_DISPLAY_LABEL = "network-api.balance-display.label";
    private static final String CONFIG_SUPPORT_SHARED_ACCOUNT = "network-api.support-shared-accounts";
    private static final String CONFIG_SERVER = "server.";
    private static final String CONFIG_SERVER_HOST = "network-api.server.host";
    private static final String CONFIG_SERVER_SECURE_PORT = "network-api.server.secure-port";
    public static final String CONFIG_SERVER_SECRET = "network-api.server.secret";
    private static final String CONFIG_SERVER_TIMEOUT = "network-api.server.timeout";
    private static final String CONFIG_ON_DEMAND_TRANSFER = "on-demand-transfer.";
    private static final String CONFIG_ON_DEMAND_TRANSFER_DEFAULT_TRANSFER_AMOUNT = "network-api.on-demand-transfer.default-transfer-amount";
    private static final String CONFIG_ON_DEMAND_TRANSFER_MAX_TRANSFER_AMOUNT = "network-api.on-demand-transfer.max-transfer-amount";
    private static final String CONFIG_ON_DEMAND_TRANSFER_MIN_TRANSFER_AMOUNT = "network-api.on-demand-transfer.min-transfer-amount";
    private static final String CONFIG_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT = "network-api.on-demand-transfer.transaction-comment";

    public GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public boolean getIsConfigured() {
        GatewayConfig conf = this.getGatewayConfig();
        if (!this.isPluginEnabled().booleanValue()) {
            logger.error("Network Payment API not enabled");
            return false;
        }
        if (StringUtils.isBlank((String)conf.getString(CONFIG_EXTERNAL_USER_IDS))) {
            EventLog.getInstance().logEvent("User IDs not provided.");
            return false;
        }
        if (this.getExternalUserIds() == null) {
            return false;
        }
        if (this.getDefaultTransferAmount() == null) {
            EventLog.getInstance().logEvent("Default transfer amount not supplied.");
            return false;
        }
        if (this.getMinTransferAmount() == null) {
            EventLog.getInstance().logEvent("Min transfer amount not supplied.");
            return false;
        }
        if (this.getMaxTransferAmount() == null) {
            EventLog.getInstance().logEvent("Max transfer amount not supplied.");
            return false;
        }
        if (!this.isBalanceDisplayed().booleanValue()) {
            EventLog.getInstance().logEvent("User balance display option not supplied.");
            return false;
        }
        if (this.getBalanceDisplayLabel() == null) {
            EventLog.getInstance().logEvent("Balance label not supplied.");
            return false;
        }
        if (this.getHost() == null) {
            EventLog.getInstance().logEvent("Host address not specified.");
            return false;
        }
        if (this.getPort() == null) {
            EventLog.getInstance().logEvent("Secure port not specified.");
            return false;
        }
        if (this.getSharedSecret() == null) {
            EventLog.getInstance().logEvent("Secret token not supplied.");
            return false;
        }
        if (this.getTimeout() == null) {
            EventLog.getInstance().logEvent("Timeout not specified");
            return false;
        }
        if (this.getExternalUserIds() == null) {
            EventLog.getInstance().logEvent("At least one user ID must be specified.");
            return false;
        }
        if (StringUtils.isBlank((String)this.getGatewayConfig().getString(CONFIG_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT))) {
            return false;
        }
        this.buildUserInformationList();
        return true;
    }

    public Boolean isPluginEnabled() {
        return BooleanUtils.isTrue((Boolean)this.getGatewayConfig().getBoolean(CONFIG_ENABLED));
    }

    public String getHost() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_SERVER_HOST));
    }

    public Integer getPort() {
        return this.getGatewayConfig().getInteger(CONFIG_SERVER_SECURE_PORT);
    }

    public String getSharedSecret() {
        logger.info("SHARED SECRET: network-api.server.secret");
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_SERVER_SECRET));
    }

    public String getTransactionComment() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT));
    }

    public Boolean isBalanceDisplayed() {
        return BooleanUtils.isTrue((Boolean)this.getGatewayConfig().getBoolean(CONFIG_USER_BALANCE_DISPLAY));
    }

    public String getBalanceDisplayLabel() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_BALANCE_DISPLAY_LABEL));
    }

    public Double getMinTransferAmount() {
        return this.getGatewayConfig().getDouble(CONFIG_ON_DEMAND_TRANSFER_MIN_TRANSFER_AMOUNT);
    }

    public Double getMaxTransferAmount() {
        return this.getGatewayConfig().getDouble(CONFIG_ON_DEMAND_TRANSFER_MAX_TRANSFER_AMOUNT);
    }

    public Boolean isSharedAccountsEnabled() {
        return BooleanUtils.isTrue((Boolean)this.getGatewayConfig().getBoolean(CONFIG_SUPPORT_SHARED_ACCOUNT));
    }

    public Integer getTimeout() {
        return this.getGatewayConfig().getInteger(CONFIG_SERVER_TIMEOUT);
    }

    public Double getDefaultTransferAmount() {
        return this.getGatewayConfig().getDouble(CONFIG_ON_DEMAND_TRANSFER_DEFAULT_TRANSFER_AMOUNT);
    }

    public String getExternalUserIds() {
        return this.getGatewayConfig().getString(CONFIG_EXTERNAL_USER_IDS);
    }

    private void buildUserInformationList() {
        for (String detail : this.getExternalUserIds().split(",")) {
            if (detail.equalsIgnoreCase("email")) {
                this.userInformationList.add(UserInformationType.EMAIL);
                continue;
            }
            if (detail.equalsIgnoreCase("primary-card-number")) {
                this.userInformationList.add(UserInformationType.PRIMARY_CARD);
                continue;
            }
            if (detail.equalsIgnoreCase("secondary-card-number")) {
                this.userInformationList.add(UserInformationType.SECONDARY_CARD);
                continue;
            }
            if (detail.equalsIgnoreCase("username")) {
                this.userInformationList.add(UserInformationType.USERNAME);
                continue;
            }
            if (!detail.equalsIgnoreCase("user-alias")) continue;
            this.userInformationList.add(UserInformationType.USER_ALIAS);
        }
    }

    public List<UserInformationType> getUserInformationList() {
        return this.userInformationList;
    }

    public static NetworkAPIPlugin getInstance() {
        if (instance == null) {
            instance = new NetworkAPIPlugin();
        }
        return instance;
    }
}

