/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.networkapi;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.networkapi.NetworkAPIPlugin;
import biz.papercut.pcng.ext.paymentgateway.networkapi.NetworkAPISharedAccount;
import biz.papercut.pcng.ext.paymentgateway.networkapi.RequestType;
import biz.papercut.pcng.ext.paymentgateway.networkapi.UserInformationType;
import biz.papercut.pcng.service.UserManager;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.papercut.server.lang.service.ServiceException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAPIRequest {
    private static final Logger logger = LoggerFactory.getLogger(NetworkAPIRequest.class);
    @JsonIgnore
    private RequestType requestType;
    @JsonProperty(value="user")
    private final Map<String, String> userDetailsMap = new HashMap<String, String>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, String> jobDetails;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="topUpAmount")
    private Double amount;
    @JsonIgnore
    private UserManager userManager;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String orderId;
    @JsonIgnore
    private String username;
    private NetworkAPISharedAccount sharedAccount;

    public RequestType getRequestType() {
        return this.requestType;
    }

    private void buildUserInformationMap(String username) {
        User user = this.userManager.getUser(username);
        if (user == null) {
            throw new ServiceException("Cannot find user.");
        }
        for (UserInformationType informationType : NetworkAPIPlugin.getInstance().getUserInformationList()) {
            String value;
            if ((value = (switch (informationType) {
                default -> throw new MatchException(null, null);
                case UserInformationType.EMAIL -> user.getEmail();
                case UserInformationType.PRIMARY_CARD -> user.getCardNumber();
                case UserInformationType.SECONDARY_CARD -> user.getCardNumber2();
                case UserInformationType.USER_ALIAS -> user.getSecondaryUserName();
                case UserInformationType.USERNAME -> user.getUserName();
            })) == null) continue;
            this.userDetailsMap.put(informationType.getKey(), value);
        }
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public Map<String, String> getJobDetails() {
        return this.jobDetails;
    }

    public void setJobDetails(Map<String, String> jobDetails) {
        this.jobDetails = jobDetails;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        if (this.userDetailsMap.isEmpty()) {
            this.buildUserInformationMap(this.username);
        }
    }

    public NetworkAPISharedAccount getSharedAccount() {
        return this.sharedAccount;
    }

    public void setSharedAccount(NetworkAPISharedAccount sharedAccount) {
        this.sharedAccount = sharedAccount;
    }
}

