/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.networkapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAPIResponse {
    private static final Logger logger = LoggerFactory.getLogger(NetworkAPIResponse.class);
    private Map<String, Object> properties = new HashMap<String, Object>();
    private boolean validResponse;

    public NetworkAPIResponse(Response response) throws IOException {
        logger.debug("NetworkAPIResponse: Begin");
        this.validResponse = response.code() >= 200 && response.code() < 300 || response.code() == 404;
        String bodyContent = "";
        if (response.body() != null) {
            bodyContent = response.body().string();
        }
        if (!bodyContent.isEmpty()) {
            ObjectMapper objectMapper = new ObjectMapper();
            this.properties = (Map)objectMapper.readValue(bodyContent, Map.class);
            logger.debug("NetworkAPIResponse: Response body not empty, status code {}", (Object)response.code());
        } else {
            logger.debug("NetworkAPIResponse: Response body empty, status code {}", (Object)response.code());
        }
        logger.debug("NetworkAPIResponse: End");
    }

    @Nullable
    public Object get(String key) {
        if (this.findKey(key)) {
            return this.properties.get(key);
        }
        if (this.getError() != null) {
            logger.error(this.getError());
        }
        return null;
    }

    public String getError() {
        return (String)this.properties.get("error");
    }

    private boolean findKey(String key) {
        if (this.properties.get(key) == null) {
            logger.debug("Cannot find key: {}", (Object)key);
            return false;
        }
        return true;
    }

    public boolean getValidResponse() {
        return this.validResponse;
    }

    public void setValidResponse(boolean value) {
        this.validResponse = value;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }
}

