/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.networkapi;

import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.networkapi.NetworkAPIConnectionManager;
import biz.papercut.pcng.ext.paymentgateway.networkapi.NetworkAPIPlugin;
import biz.papercut.pcng.ext.paymentgateway.networkapi.NetworkAPIRequest;
import biz.papercut.pcng.ext.paymentgateway.networkapi.NetworkAPIResponse;
import biz.papercut.pcng.ext.paymentgateway.networkapi.NetworkAPISharedAccount;
import biz.papercut.pcng.ext.paymentgateway.networkapi.RequestType;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin3;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin4;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.UserManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class NetworkAPITopupAccountOnDemandPlugin
implements TopupAccountOnDemandPlugin4,
SpringContextPlugin {
    private static final Logger logger = LoggerFactory.getLogger(NetworkAPITopupAccountOnDemandPlugin.class);
    @AESProperty
    public static final String NOT_USE_CONFIG_SERVER_SECRET = "network-api.server.secret";
    @Nullable
    @GuardedBy(value="this")
    private ApplicationContext _ctx;
    private boolean _configured;
    private NetworkAPIConnectionManager connectionManager;

    public boolean isPluginEnabled() {
        if (!this._configured) {
            this._configured = NetworkAPIPlugin.getInstance().getIsConfigured();
        }
        if (!this._configured) {
            return false;
        }
        return NetworkAPIPlugin.getInstance().isPluginEnabled();
    }

    public Map<String, Double> getBalance(Map<String, String> userDetails) {
        if (!NetworkAPIPlugin.getInstance().isBalanceDisplayed().booleanValue()) {
            return null;
        }
        NetworkAPIRequest request = new NetworkAPIRequest();
        request.setUserManager(this.getUserManager());
        request.setUsername(userDetails.get("username"));
        request.setRequestType(RequestType.BALANCE_ENQUIRY);
        NetworkAPIResponse response = this.getConnectionManager().sendRequest(request);
        if (response == null) {
            logger.debug("getBalance: Invalid JSON response from server.");
            EventLog.getInstance().logEvent("getBalance: Invalid JSON response from server.");
            return null;
        }
        if (!response.getValidResponse()) {
            logger.error("getBalance: Invalid response from server.");
            return null;
        }
        if (response.isEmpty()) {
            logger.debug("getBalance: Empty response from server.");
            return null;
        }
        if (response.get("balance") == null) {
            EventLog.getInstance().logEvent(response.getError());
            return null;
        }
        HashMap<String, Double> displayedBalanceMap = new HashMap<String, Double>();
        String stringBalance = Objects.requireNonNull(response.get("balance")).toString();
        Double doubleBalance = Double.valueOf(stringBalance);
        displayedBalanceMap.put(NetworkAPIPlugin.getInstance().getBalanceDisplayLabel(), doubleBalance);
        return displayedBalanceMap;
    }

    @Nullable
    public TopupAccountOnDemandPlugin3.AvailableCredit getAvailableCreditForTopUp(String username, @Nullable String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        NetworkAPIRequest request = new NetworkAPIRequest();
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            if (NetworkAPIPlugin.getInstance().isSharedAccountsEnabled().booleanValue()) {
                request.setSharedAccount(new NetworkAPISharedAccount().parseSharedAccount(sharedAccount));
            } else {
                logger.error("Unable to fetch credit. Shared accounts not enabled");
                EventLog.getInstance().logEvent("Unable to fetch credit. Shared accounts not enabled");
                return null;
            }
        }
        request.setUserManager(this.getUserManager());
        request.setRequestType(RequestType.CREDIT_ENQUIRY);
        request.setUsername(username);
        NetworkAPIResponse response = this.getConnectionManager().sendRequest(request);
        if (response == null) {
            logger.debug("getAvailableCreditForTopUp: Invalid JSON response from server.");
            EventLog.getInstance().logEvent("getAvailableCreditForTopUp: Invalid JSON response from server.");
            return null;
        }
        if (!response.getValidResponse()) {
            logger.error("getAvailableCreditForTopUp: Invalid response from server.");
            return null;
        }
        if (response.isEmpty()) {
            logger.debug("getAvailableCreditForTopUp: Empty response from server.");
            return null;
        }
        if (!StringUtils.isEmpty((String)response.getError())) {
            logger.debug(response.getError());
        }
        if (response.get("availableCredit") == null || response.get("unlimited") == null) {
            logger.debug("getAvailableCreditForTopUp: availableCredit or unlimited is null");
            return null;
        }
        return new TopupAccountOnDemandPlugin3.AvailableCredit(((Boolean)response.get("unlimited")).booleanValue(), ((Double)response.get("availableCredit")).doubleValue());
    }

    public TopupAccountOnDemandPlugin.TopupResponse getTopup(double amountRequired, String username, String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged, Map<String, String> usageDetails) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        NetworkAPIRequest request = new NetworkAPIRequest();
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            if (NetworkAPIPlugin.getInstance().isSharedAccountsEnabled().booleanValue()) {
                request.setSharedAccount(new NetworkAPISharedAccount().parseSharedAccount(sharedAccount));
            } else {
                logger.error("Unable to process transaction. Shared accounts not enabled");
                EventLog.getInstance().logEvent("Unable to process transaction. Shared accounts not enabled");
                return null;
            }
        }
        request.setUserManager(this.getUserManager());
        request.setUsername(username);
        request.setRequestType(RequestType.TRANSACTION);
        request.setJobDetails(usageDetails);
        double topupAmount = this.calcTopupAmount(amountRequired);
        if (topupAmount <= 0.0) {
            logger.debug("topup amount requested is less than 0 (requested {})", (Object)topupAmount);
            return null;
        }
        GatewayUtils.TopUpDebitFunction debitFunc = this.getDebitFunction(username, request);
        return GatewayUtils.performTopupDebit((TopupAccountOnDemandPlugin3)this, debitFunc, topupAmount, amountRequired, username, sharedAccount, accountCharged, usageDetails, "Transaction successfully processed!");
    }

    private GatewayUtils.TopUpDebitFunction getDebitFunction(final String username, final NetworkAPIRequest request) {
        return new GatewayUtils.TopUpDebitFunction(){
            private Optional<String> txnComment = Optional.empty();

            @Override
            public Optional<String> getTxnComment() {
                return this.txnComment;
            }

            @Override
            public Double performDebit(double amount) {
                String orderId = NetworkAPITopupAccountOnDemandPlugin.this.getNextOrderId();
                request.setOrderId(orderId);
                request.setAmount(amount);
                NetworkAPIResponse response = NetworkAPITopupAccountOnDemandPlugin.this.getConnectionManager().sendRequest(request);
                if (response == null) {
                    logger.debug("getDebitFunction: Invalid JSON response from server.");
                    EventLog.getInstance().logEvent("getDebitFunction: Invalid JSON response from server.");
                    return null;
                }
                if (!response.getValidResponse()) {
                    logger.error("getDebitFunction: Invalid response from server.");
                    return null;
                }
                if (response.isEmpty()) {
                    logger.debug("getDebitFunction: Empty response from server.");
                    return null;
                }
                if (((String)response.get("status")).equalsIgnoreCase("success")) {
                    String transactionId = response.get("transactionId").toString();
                    String processedComment = "";
                    String defaultComment = NetworkAPIPlugin.getInstance().getTransactionComment();
                    if (defaultComment != null) {
                        processedComment = StringUtils.replace((String)defaultComment, (String)"%transactionId%", (String)transactionId);
                    } else if (response.get("comment") != null) {
                        processedComment = response.get("comment").toString();
                    }
                    this.txnComment = Optional.of(processedComment);
                    logger.info(processedComment);
                    EventLog.getInstance().logTransaction(username, transactionId, amount, processedComment, "orderId:" + orderId);
                    return amount;
                }
                logger.debug(response.getError());
                EventLog.getInstance().logEvent(response.getError());
                return null;
            }
        };
    }

    private double calcTopupAmount(double amountRequired) {
        if (amountRequired < 0.0) {
            return 0.0;
        }
        double topUpAmount = amountRequired;
        logger.debug("Amount Required: {}", (Object)amountRequired);
        double minAmount = NetworkAPIPlugin.getInstance().getMinTransferAmount();
        double maxAmount = NetworkAPIPlugin.getInstance().getMaxTransferAmount();
        double defaultTransferAmount = NetworkAPIPlugin.getInstance().getDefaultTransferAmount();
        if (minAmount > 0.0 && amountRequired < minAmount) {
            logger.debug("Using minimum transfer amount of {}", (Object)minAmount);
            topUpAmount = minAmount;
        }
        if (maxAmount > 0.0 && amountRequired > maxAmount) {
            logger.debug("Transfer amount of {} exceeds maximum of {}", (Object)amountRequired, (Object)maxAmount);
            topUpAmount = maxAmount;
        }
        if (defaultTransferAmount > 0.0 && defaultTransferAmount >= minAmount && defaultTransferAmount <= maxAmount && defaultTransferAmount >= amountRequired) {
            logger.debug("Using default transfer amount: {}", (Object)defaultTransferAmount);
            topUpAmount = defaultTransferAmount;
        }
        return (double)this.currencyInLowestUnitRounded(topUpAmount) / 100.0;
    }

    private int currencyInLowestUnitRounded(double dollars) {
        double roundingTolerance = 1.0E-5;
        double dollarsToRound = dollars - roundingTolerance;
        return (int)Math.ceil(dollarsToRound * 100.0);
    }

    public UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    public AccountManager getAccountManager() {
        return (AccountManager)this.getApplicationContext().getBean("accountManager", AccountManager.class);
    }

    public synchronized ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public synchronized void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    private String getNextOrderId() {
        return String.valueOf(CreditCardGatewayPlugin.getUniqueOrderID());
    }

    private NetworkAPIConnectionManager getConnectionManager() {
        if (this.connectionManager == null) {
            this.connectionManager = new NetworkAPIConnectionManager();
        }
        return this.connectionManager;
    }

    @VisibleForTesting
    public void setConnectionManager(NetworkAPIConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }
}

