/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.nuvision;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.nuvision.BalanceResponse;
import biz.papercut.pcng.ext.paymentgateway.nuvision.DebitResponse;
import biz.papercut.pcng.ext.paymentgateway.nuvision.NuVisionPlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnNuVision
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(ExtnNuVision.class);
    public static final String PAGE_NAME = ExtnNuVision.class.getSimpleName();

    @Nullable
    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract void setNuVisionBalance(@Nullable Double var1);

    public abstract double getAmount();

    @Nullable
    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract AccountManager getAccountManager();

    public abstract UserManager getUserManager();

    public void pageBeginRender(PageEvent arg0) {
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(GatewayUtils.createAllowedAmountsModel("nuvision.allowed-amounts", (BasePaperCutPage)this));
        }
        if (!this.getRequestCycle().isRewinding()) {
            String configError;
            if (!this.getNuVisionPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = this.getNuVisionPlugin().getIsConfigured()) == null) {
                BalanceResponse br = this.getNuVisionPlugin().getBalance(this.getUser());
                this.setNuVisionBalance(br.getBalance());
                if (!br.isSuccess()) {
                    this.addErrorMessage(br.getMessage());
                }
            } else {
                this.addWarningMessage(configError);
                logger.error(configError);
            }
        }
    }

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public void doTransaction(IRequestCycle cycle) {
        double totalUserBalance;
        double amount = this.getAmount();
        User user = this.getUser();
        if (amount <= 0.0) {
            this.addErrorMessage("Please select an amount to add");
            return;
        }
        Double accumulationLimit = this.getNuVisionPlugin().getOnlyAllowAccumulationUpTo();
        if (accumulationLimit != null && (totalUserBalance = GatewayUtils.getUserBalance(this.getAccountManager(), user)) + amount > accumulationLimit) {
            this.addErrorMessage(this.getNuVisionPlugin().getOnlyAllowAccumulationUpToMessage());
            return;
        }
        DebitResponse dr = this.getNuVisionPlugin().performDebit(user, amount);
        if (dr.isSuccess()) {
            this.addStatusMessage(this.formatBalance(amount) + " was successfully added to your account. " + dr.getMessage());
        } else if (StringUtils.isBlank((String)dr.getMessage())) {
            this.addErrorMessage(this.getNuVisionPlugin().getUnknownErrorMessage());
        } else {
            this.addErrorMessage(dr.getMessage());
        }
    }

    public boolean isAccessibleByUser() {
        return this.getNuVisionPlugin().isAccessibleByUser(this.getUserName());
    }

    public String getNoAccessMsg() {
        return this.getGatewayConfig().getNoAccessMessage();
    }

    public String getUserAndFullName() {
        StringBuilder s = new StringBuilder();
        s.append(this.getUser().getUserName());
        if (StringUtils.isNotBlank((String)this.getUser().getFullName())) {
            s.append(" (");
            s.append(this.getUser().getFullName());
            s.append(")");
        }
        return s.toString();
    }

    public String getPageTitle() {
        String title = this.getNuVisionPlugin().getPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public String getHeading() {
        return this.getNuVisionPlugin().getPageHeading();
    }

    public String getUserName() {
        return this.getUser().getUserName();
    }

    public String getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return this.formatBalance(GatewayUtils.getUserBalance(this.getAccountManager(), user));
    }

    public String getPageMessage() {
        return this.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return this.getGatewayConfig().getPageMessageAvailable();
    }

    public String getNuVisionBalanceLabel() {
        return this.getNuVisionPlugin().getBalanceDisplayLabel();
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    private NuVisionPlugin getNuVisionPlugin() {
        return (NuVisionPlugin)PluginManager.getInstance().getPluginByClass(NuVisionPlugin.class);
    }
}

