/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.nuvision;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.nuvision.BalanceResponse;
import biz.papercut.pcng.ext.paymentgateway.nuvision.DebitResponse;
import biz.papercut.pcng.ext.paymentgateway.nuvision.ExtnNuVision;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.server.ServerConfig;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.ProcessUtils;
import biz.papercut.pcng.util.io.LineHandler;
import biz.papercut.pcng.util.io.StringBufferLineHandler;
import com.papercut.server.lang.service.ApplicationLogLevelEnum;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class NuVisionPlugin
implements EnableablePlugin,
SpringContextPlugin,
UserLinkPlugin {
    private static final Logger logger = LoggerFactory.getLogger(NuVisionPlugin.class);
    private static final String CONFIG_PREFIX = "nuvision.";
    private static final String CONFIG_ENABLED = "nuvision.enabled";
    private static final String CONFIG_SERVER_IP = "nuvision.server-ip";
    private static final String CONFIG_SERVER_PORT = "nuvision.server-port";
    @AESProperty
    public static final String CONFIG_SHARED_SECRET = "nuvision.shared-secret";
    private static final String CONFIG_ACCOUNT = "nuvision.account";
    private static final String CONFIG_TERMINAL = "nuvision.terminal";
    private static final String CONFIG_PAGE_TITLE = "nuvision.page-title";
    private static final String CONFIG_PAGE_HEADING = "nuvision.page-heading";
    private static final String CONFIG_BALANCE_DISPLAY_LABEL = "nuvision.balance-display.label";
    private static final String CONFIG_ALLOWED_GROUPS = "nuvision.allowed-groups";
    public static final String CONFIG_ALLOWED_AMOUNTS = "nuvision.allowed-amounts";
    public static final String CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO = "nuvision.only-allow-accumulation-up-to";
    public static final String CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO_MESSAGE = "nuvision.only-allow-accumulation-up-to-message";
    public static final String CONFIG_UNKNOWN_ERROR = "nuvision.unknown-error";
    public static final String CONFIG_BINARY_HELPER = "nuvision.binary-helper";
    public static final String DEFAULT_BINARY_HELPER = "nuvision.exe";
    private static final List<String> ADDITIONAL_PAGES = List.of(ExtnNuVision.PAGE_NAME);
    private volatile ApplicationContext _applicationContext;

    public boolean isPluginEnabled() {
        Boolean enabled = this.getGatewayConfig().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return ADDITIONAL_PAGES;
        }
        return null;
    }

    @CheckForNull
    public String getIsConfigured() {
        String errorSuffix = " Please check the payment gateway config file.";
        if (this.getServerIP() == null) {
            String error = "Server IP not provided.";
            this.logError(error, false);
            return error + errorSuffix;
        }
        if (this.getServerPort() == null) {
            String error = "Server name not provided.";
            this.logError(error, false);
            return error + errorSuffix;
        }
        if (this.getSharedSecret() == null) {
            String error = "Shared secret not provided.";
            this.logError(error, false);
            return error + errorSuffix;
        }
        if (this.getAccount() == null) {
            String error = "Account type not provided.";
            this.logError(error, false);
            return error + errorSuffix;
        }
        if (this.getTerminal() == null) {
            String error = "Terminal number not provided.";
            this.logError(error, false);
            return error + errorSuffix;
        }
        if (this.getAllowedAmounts() == null) {
            String error = "Must specify at least one allowed payment amount.";
            this.logError(error, false);
            return error + errorSuffix;
        }
        if (this.getBinaryHelper() == null) {
            String error = "Binary helper file not found.";
            this.logError(error, false);
            return error + errorSuffix;
        }
        return null;
    }

    public boolean isAccessibleByUser(String username) {
        return GatewayUtils.isAccessibleByUser(username, CONFIG_ALLOWED_GROUPS, this.getUserManager());
    }

    public boolean isLicensed() {
        return GatewayUtils.isLicensed(this.getLicenseManager(), "payment-gateways-nuvision");
    }

    @Nullable
    public String getAllowedAmounts() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_ALLOWED_AMOUNTS));
    }

    public Double getOnlyAllowAccumulationUpTo() {
        return this.getGatewayConfig().getDouble(CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO);
    }

    public String getOnlyAllowAccumulationUpToMessage() {
        return this.getGatewayConfig().getString(CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO_MESSAGE);
    }

    @Nullable
    public String getServerIP() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_SERVER_IP));
    }

    @Nullable
    public String getServerPort() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_SERVER_PORT));
    }

    @Nullable
    public String getSharedSecret() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_SHARED_SECRET));
    }

    @Nullable
    public String getAccount() {
        String s = StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_ACCOUNT)).toUpperCase(Locale.US);
        try {
            AccountType.valueOf(s);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        return s;
    }

    @Nullable
    public String getTerminal() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_TERMINAL));
    }

    @Nullable
    public String getPageTitle() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PAGE_TITLE));
    }

    @Nullable
    public String getPageHeading() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PAGE_HEADING));
    }

    public String getBalanceDisplayLabel() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_BALANCE_DISPLAY_LABEL));
    }

    public String getUserErrorMessage() {
        return this.getGatewayConfig().getUserErrorMessage();
    }

    public String getUnknownErrorMessage() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_UNKNOWN_ERROR));
    }

    @Nullable
    public File getBinaryHelper() {
        File f;
        String binaryHelper = StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_BINARY_HELPER));
        if (binaryHelper == null) {
            binaryHelper = DEFAULT_BINARY_HELPER;
        }
        if (!(f = new File(ServerConfig.getInstance().getExtensionHome(), binaryHelper)).exists() && !(f = new File(binaryHelper)).exists()) {
            this.logError("NuVision binary helper not found.", false);
            return null;
        }
        this.logDebug("NuVision binary helper found at: " + f.getAbsolutePath());
        return f;
    }

    public BalanceResponse getBalance(User user) {
        DebitResponse dr = this.performDebit(this.getServerIP(), this.getServerPort(), this.getSharedSecret(), this.getAccount(), this.getTerminal(), user.getCardNumber(), 0.0);
        BalanceResponse br = new BalanceResponse(dr.isSuccess(), dr.getBalance(), dr.getMessage());
        this.logInfo("Received balance response: " + String.valueOf(br), false);
        return br;
    }

    public DebitResponse performDebit(User user, double amount) {
        String orderId = this.getCreditCardGatewayPlugin().createNewOrder(user.getUserName(), amount);
        DebitResponse response = this.performDebit(this.getServerIP(), this.getServerPort(), this.getSharedSecret(), this.getAccount(), this.getTerminal(), user.getCardNumber(), amount);
        this.logInfo("Received debit response: " + String.valueOf(response), false);
        if (response.isSuccess()) {
            this.getCreditCardGatewayPlugin().confirmOrder(orderId, amount);
        } else {
            this.logInfo("Canceling order " + orderId, false);
            this.getCreditCardGatewayPlugin().cancelOrder(orderId);
        }
        return response;
    }

    protected DebitResponse performDebit(String serverIP, String serverPort, String sharedSecret, String account, String terminal, String card, double amount) {
        String amountFormatted = GatewayUtils.formatNumber(amount, 2, Locale.US, false);
        String stdin = this.formatExtBinaryInput(serverIP, this.getServerPort(), this.getSharedSecret(), account, terminal, card, amountFormatted);
        String[] cmd = new String[]{this.getBinaryHelper().getAbsolutePath()};
        String msg = "Performing NuVision debit for card=" + card + ", account=" + account + ", terminal=" + terminal + ", amount=" + amountFormatted;
        if (logger.isDebugEnabled()) {
            this.logDebug(msg + ", stdin:" + SystemUtils.LINE_SEPARATOR + stdin);
        } else {
            this.logInfo(msg, false);
        }
        StringBufferLineHandler stdOutHandler = new StringBufferLineHandler();
        StringBufferLineHandler stdErrHandler = new StringBufferLineHandler();
        int exitCode = 1;
        try {
            exitCode = ProcessUtils.exec((String[])cmd, (ProcessUtils.ProcessStreamHandler)new ProcessUtils.LineStreamHandler((Reader)new StringReader(stdin), (LineHandler)stdOutHandler, (LineHandler)stdErrHandler, StandardCharsets.UTF_8));
        }
        catch (InterruptedException ie) {
            this.logError("NuVision external process interrupted: " + ie.getMessage(), false);
        }
        catch (IOException ioe) {
            this.logError("Error communicating with NuVision external process: " + ioe.getMessage(), false);
        }
        String stdout = stdOutHandler.getStringBuffer().toString();
        String stderr = stdErrHandler.getStringBuffer().toString();
        String msg2 = "NuVision external processed completed. Exit code: " + exitCode;
        if (logger.isDebugEnabled()) {
            this.logDebug(msg2 + ", stdout: " + SystemUtils.LINE_SEPARATOR + stdout + ", stderr: " + SystemUtils.LINE_SEPARATOR + stderr);
        } else {
            this.logInfo(msg2, false);
        }
        return this.parseExtBinaryOutput(stdout, stderr);
    }

    private String formatExtBinaryInput(String serverIP, String serverPort, String sharedSecret, String account, String terminal, String card, String amountFormatted) {
        String ls = SystemUtils.LINE_SEPARATOR;
        return "ServerIP=" + serverIP + ls + "ServerPort=" + serverPort + ls + "SharedSecret=" + sharedSecret + ls + "Card=" + card + ls + "Account=" + account + ls + "Terminal=" + terminal + ls + "Amount=" + amountFormatted + ls + "END" + ls;
    }

    private DebitResponse parseExtBinaryOutput(String stdout, String stderr) {
        BufferedReader soReader = new BufferedReader(new StringReader(stdout));
        try {
            String line;
            String statusLine = soReader.readLine();
            String status = StringUtils.substringBefore((String)statusLine, (String)" ");
            String message = StringUtils.substringAfter((String)statusLine, (String)" ");
            Double balance = null;
            while ((line = soReader.readLine()) != null) {
                String key = StringUtils.substringBefore((String)line, (String)"=");
                String value = StringUtils.substringAfter((String)line, (String)"=");
                if (!key.equals("Balance")) continue;
                try {
                    balance = Double.valueOf(value);
                }
                catch (Exception e) {
                    this.logError("Invalid balance returned from NuVision: " + value, true);
                }
            }
            return new DebitResponse(status.equals("OK"), balance, message);
        }
        catch (IOException ioe) {
            return new DebitResponse(false, 0.0, ioe.getMessage());
        }
    }

    private void logInfo(String msg, boolean doAppLog) {
        logger.info(msg);
        EventLog.getInstance().logEvent(msg);
        if (doAppLog) {
            this.getApplicationLogManager().logRaw(null, ApplicationLogLevelEnum.INFORMATION, "NuVision payment gateway: " + msg);
        }
    }

    private void logError(String msg, boolean doAppLog) {
        logger.error(msg);
        EventLog.getInstance().logEvent("ERROR: " + msg);
        if (doAppLog) {
            this.getApplicationLogManager().logRaw(null, ApplicationLogLevelEnum.ERROR, "NuVision payment gateway: " + msg);
        }
    }

    private void logDebug(String msg) {
        if (logger.isDebugEnabled()) {
            logger.debug(msg);
            EventLog.getInstance().logEvent("DEBUG: " + msg);
        }
    }

    private ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    private ApplicationLogManager getApplicationLogManager() {
        return (ApplicationLogManager)this.getApplicationContext().getBean("applicationLogManager", ApplicationLogManager.class);
    }

    private CreditCardGatewayPlugin getCreditCardGatewayPlugin() {
        return (CreditCardGatewayPlugin)PluginManager.getInstance().getPluginByClass(CreditCardGatewayPlugin.class);
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    private LicenseManager getLicenseManager() {
        return (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    protected static enum AccountType {
        DECLINING,
        ACCT1,
        ACCT2,
        ACCT3,
        ACCT4,
        ACCT5,
        EQUIVALENCE,
        CHARGE,
        CASH,
        INQUIRE,
        EVENT,
        GENERAL,
        GUESTPASS,
        CHECK;

    }
}

