/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.officialpayments;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.officialpayments.BaseOfficialPaymentsPage;
import biz.papercut.pcng.ext.paymentgateway.officialpayments.OfficialPaymentsFormPoster;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.GroupManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnOfficialPayments
extends BaseOfficialPaymentsPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(ExtnOfficialPayments.class);

    @Override
    public abstract User getUser();

    @Override
    public abstract void setUser(User var1);

    @Override
    public abstract Double getAmount();

    @Override
    public abstract void setAmount(Double var1);

    @Override
    public abstract IPropertySelectionModel getAmountsModel();

    @Override
    public abstract void setAmountsModel(IPropertySelectionModel var1);

    @Override
    public abstract AccountManager getAccountManager();

    @Override
    public abstract UserManager getUserManager();

    public abstract GroupManager getGroupManager();

    public void pageBeginRender(PageEvent arg0) {
        String configError;
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (!this.getRequestCycle().isRewinding()) {
            this.setAmountsModel(GatewayUtils.createAllowedAmountsModel(this.getConfig().getAllowAmounts(), (BasePaperCutPage)this));
            if (!this.getPaymentGatewayPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
        }
        if ((configError = this.getPaymentGatewayPlugin().getIsConfigured()) != null) {
            this.addWarningMessage(configError);
            logger.error(configError);
        }
    }

    public void activateExternalPage(Object[] arg0, IRequestCycle cycle) {
        HttpServletRequest r = this.getRequest();
        String orderId = r.getParameter("order-id");
        String status = r.getParameter("status");
        if ("check".equals(status)) {
            switch (this.getPaymentGatewayPlugin().getOrderStatus(orderId)) {
                case Approved: {
                    this.addStatusMessage("Funds have been added to your account.");
                    break;
                }
                case Declined: {
                    this.addStatusMessage("Your payment was declined." + this.getPaymentGatewayPlugin().getUserErrorMessage());
                    break;
                }
                case Pending: {
                    this.addStatusMessage("Your payment is being processed and will be actioned soon.");
                    break;
                }
                case Unknown: {
                    this.addStatusMessage(this.getPaymentGatewayPlugin().getUserErrorMessage());
                    break;
                }
                default: {
                    logger.error("Unexpected state: {}", (Object)status);
                    break;
                }
            }
        } else if ("cancel".equals(status)) {
            this.getPaymentGatewayPlugin().cancelOrder(orderId);
            this.addWarningMessage("Your payment was canceled.");
        }
    }

    public void formSubmit(IRequestCycle cycle) {
        Double amount = this.getAmount();
        if (amount == null || amount <= 0.0) {
            this.addErrorMessage("Please select an amount to add");
            return;
        }
        OfficialPaymentsFormPoster formPostPage = (OfficialPaymentsFormPoster)cycle.getPage(OfficialPaymentsFormPoster.class.getSimpleName());
        formPostPage.activate(cycle, this.getConfig(), this.getUser(), amount);
    }

    @Override
    public String getPageTitle() {
        String title = this.getConfig().getTitle();
        return title == null ? super.getPageTitle() : title;
    }

    @Override
    public String getHeading() {
        String heading = this.getConfig().getHeading();
        return heading == null ? super.getHeading() : heading;
    }

    public String getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return this.formatBalance(GatewayUtils.getUserBalance(this.getAccountManager(), user));
    }
}

