/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.officialpayments;

import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;

public class OfficialPaymentsConfig {
    static final String CONFIG_ENABLED = "officialpayments.enabled";
    static final String CONFIG_SUBMIT_URL = "officialpayments.submit-url";
    static final String CONFIG_PRODUCT_ID = "officialpayments.product-id";
    static final String CONFIG_ALLOWED_AMOUNTS = "officialpayments.allowed-amounts";
    static final String CONFIG_HEADING = "officialpayments.page-heading";
    static final String CONFIG_TITLE = "officialpayments.page-title";
    static final String CONFIG_ALLOWED_GROUPS = "officialpayments.allowed-groups";
    static final String CONFIG_POSTBACK_URL = "officialpayments.postback-url";
    static final String CONFIG_POSTBACK_ALLOWED_IP = "officialpayments.postback-allowed-ip";
    static final String CONFIG_SHARED_SECRET = "officialpayments.shared-secret";

    public boolean isEnabled() {
        return this.getConfig().getBoolean(CONFIG_ENABLED);
    }

    public String getSubmitUrl() {
        return this.getConfig().getString(CONFIG_SUBMIT_URL);
    }

    public List<Double> getAllowAmounts() {
        return this.getConfig().getDoubleList(CONFIG_ALLOWED_AMOUNTS);
    }

    public String getProductId() {
        return this.getConfig().getString(CONFIG_PRODUCT_ID);
    }

    @CheckForNull
    public String getHeading() {
        return StringUtils.trimToNull((String)this.getConfig().getString(CONFIG_HEADING));
    }

    @CheckForNull
    public String getTitle() {
        return StringUtils.trimToNull((String)this.getConfig().getString(CONFIG_TITLE));
    }

    public boolean isRestrictedByGroup() {
        return !this.getAllowedGroups().isEmpty();
    }

    public Set<String> getAllowedGroups() {
        return new HashSet<String>(this.getConfig().getStringList(CONFIG_ALLOWED_GROUPS));
    }

    public String getPostbackUrl() {
        return this.getConfig().getString(CONFIG_POSTBACK_URL);
    }

    public String getPostbackAllowedIp() {
        return this.getConfig().getString(CONFIG_POSTBACK_ALLOWED_IP);
    }

    public String getSharedSecret() {
        return this.getConfig().getString(CONFIG_SHARED_SECRET);
    }

    GatewayConfig getConfig() {
        return GatewayConfig.getInstance();
    }
}

