/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.officialpayments;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.officialpayments.BaseOfficialPaymentsPage;
import biz.papercut.pcng.ext.paymentgateway.officialpayments.ExtnOfficialPayments;
import biz.papercut.pcng.ext.paymentgateway.officialpayments.OfficialPaymentsConfig;
import biz.papercut.pcng.ext.paymentgateway.officialpayments.ReturnUrlBuilder;
import biz.papercut.pcng.service.ConfigManager;
import biz.papercut.pcng.service.NotificationUtils;
import biz.papercut.pcng.service.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OfficialPaymentsFormPoster
extends BaseOfficialPaymentsPage
implements PageRenderListener {
    private static final Logger logger = LoggerFactory.getLogger(OfficialPaymentsFormPoster.class);

    @Override
    @CheckForNull
    public abstract User getUser();

    @Override
    public abstract void setUser(User var1);

    @Override
    public abstract Double getAmount();

    @Override
    public abstract void setAmount(Double var1);

    public abstract String getOrderId();

    public abstract void setOrderId(String var1);

    public abstract String getProductId();

    public abstract void setProductId(String var1);

    public abstract String getSubmitUrl();

    public abstract void setSubmitUrl(String var1);

    public abstract String getPostbackUrl();

    public abstract void setPostbackUrl(String var1);

    @Override
    public abstract UserManager getUserManager();

    public void pageBeginRender(PageEvent arg0) {
    }

    public void activate(IRequestCycle cycle, OfficialPaymentsConfig config, User user, double amount) {
        this.setProductId(config.getProductId());
        this.setSubmitUrl(config.getSubmitUrl());
        this.setUser(user);
        this.setAmount(amount);
        String orderId = this.getPaymentGatewayPlugin().createNewOrder(user, amount);
        if (orderId == null) {
            logger.error("Failed to create a new order for user: {}", (Object)user);
            return;
        }
        this.setOrderId(orderId);
        if (StringUtils.isBlank((String)config.getSharedSecret())) {
            this.setPostbackUrl(config.getPostbackUrl() + "/rpc/gateway/official-payments?order-id=" + this.getOrderId());
        }
        logger.debug("Created order {} for user {}. Redirecting user to Official Payments.", (Object)orderId, (Object)user.getUserName());
        cycle.activate((IPage)this);
    }

    public String getReturnUrl() {
        HttpServletRequest r = this.getRequest();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("order-id", this.getOrderId());
        args.put("status", "check");
        return ReturnUrlBuilder.withInternalPage(r, ExtnOfficialPayments.class, args);
    }

    public String getCancelUrl() {
        HttpServletRequest r = this.getRequest();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("order-id", this.getOrderId());
        args.put("status", "cancel");
        return ReturnUrlBuilder.withInternalPage(r, ExtnOfficialPayments.class, args);
    }

    public String getErrorUrl() {
        HttpServletRequest r = this.getRequest();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("order-id", this.getOrderId());
        args.put("status", "check");
        return ReturnUrlBuilder.withInternalPage(r, ExtnOfficialPayments.class, args);
    }

    public String getUserEmail() {
        return StringUtils.trimToEmpty((String)NotificationUtils.getUserEmailAddress((ConfigManager)this.getConfigManager(), (User)this.getUser()));
    }
}

