/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.officialpayments;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.BasePaymentGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.ProtocolException;
import biz.papercut.pcng.ext.paymentgateway.officialpayments.ExtnOfficialPayments;
import biz.papercut.pcng.ext.paymentgateway.officialpayments.OfficialPaymentsConfig;
import biz.papercut.pcng.ext.paymentgateway.officialpayments.ResponseMessageParser;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.plugin.WebServerPlugin;
import biz.papercut.pcng.service.LicenseManager;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class OfficialPaymentsPlugin
extends BasePaymentGatewayPlugin
implements EnableablePlugin,
SpringContextPlugin,
UserLinkPlugin,
WebServerPlugin {
    private static final Logger logger = LoggerFactory.getLogger(OfficialPaymentsPlugin.class);
    public static final String POSTBACK_URL_PATH = "/rpc/gateway/official-payments";
    private static final int MAX_FIELD_LENGTH = 60;
    static final String CONFIG_PREFIX = "officialpayments.";
    @AESProperty
    public static final String NOT_USE_CONFIG_CARD_ID_LOOKUP_DB_PASSWORD = "officialpayments.shared-secret";
    private final OfficialPaymentsConfig _config = new OfficialPaymentsConfig();
    private LicenseManager _licenseManager;
    private final Map<String, OrderStatus> _orderStatus = Collections.synchronizedSortedMap(new TreeMap());

    @CheckForNull
    public String createNewOrder(User user, double amount) {
        return this.getCreditCardGatewayPlugin().createNewOrder(user.getUserName(), amount, 60);
    }

    public OrderStatus getOrderStatus(String orderId) {
        CreditCardGatewayPlugin ccgp = this.getCreditCardGatewayPlugin();
        if (!ccgp.isOrderExists(orderId)) {
            return OrderStatus.Unknown;
        }
        if (this._orderStatus.containsKey(orderId)) {
            return this._orderStatus.remove(orderId);
        }
        CreditCardGatewayPlugin.OrderResponse or = ccgp.getExistingOrderReponse(orderId);
        if (or == null) {
            return OrderStatus.Pending;
        }
        if (or.isSuccess()) {
            return OrderStatus.Approved;
        }
        return OrderStatus.Declined;
    }

    public void cancelOrder(String orderId) {
        GatewayUtils.LogHelper.logInfo(logger, "Canceling order " + orderId);
        this._orderStatus.remove(orderId);
        this.getCreditCardGatewayPlugin().cancelOrder(orderId);
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled()) {
            return List.of(ExtnOfficialPayments.class.getSimpleName());
        }
        return Collections.emptyList();
    }

    @Override
    public void setApplicationContext(ApplicationContext ctx) {
        super.setApplicationContext(ctx);
        this._licenseManager = (LicenseManager)ctx.getBean("licenseManager", LicenseManager.class);
    }

    @Override
    public boolean isLicensed() {
        return GatewayUtils.isLicensed(this._licenseManager, "payment-gateways-official-payments");
    }

    @CheckForNull
    public String getIsConfigured() {
        String errorSuffix = " Please check the payment gateway config file.";
        if (StringUtils.isEmpty((String)this.getConfig().getProductId())) {
            String error = "Product ID not provided.";
            GatewayUtils.LogHelper.logError(logger, error);
            return error + " Please check the payment gateway config file.";
        }
        if (this.getConfig().getAllowAmounts() == null) {
            String error = "Must specify at least one allowed payment amount.";
            GatewayUtils.LogHelper.logError(logger, error);
            return error + " Please check the payment gateway config file.";
        }
        try {
            this.getGatewayConfig().getURL("officialpayments.submit-url");
        }
        catch (Exception e) {
            GatewayUtils.LogHelper.logError(logger, "Invalid hosted order page URL: " + this.getConfig().getSubmitUrl());
            return "Invalid hosted order page URL. Please check the payment gateway config file.";
        }
        try {
            this.getGatewayConfig().getURL("officialpayments.postback-url");
        }
        catch (Exception e) {
            GatewayUtils.LogHelper.logError(logger, "Invalid post-back URL: " + this.getConfig().getPostbackUrl());
            return "Invalid hosted post-back URL. Please check the payment gateway config file.";
        }
        return null;
    }

    protected OfficialPaymentsConfig getConfig() {
        return this._config;
    }

    @Override
    public String getConfigPrefix() {
        return CONFIG_PREFIX;
    }

    public synchronized void preStartupHook(WebServerPlugin.WebServer server) {
        if (!this.isPluginEnabled()) {
            return;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            server.listenOnPort(80);
        }
        server.addServlet(OfficialPaymentsPOSTBackServlet.class, "/rpc/gateway/official-payments/*");
    }

    @Nullable
    private String validateResponse(HttpServletRequest req) {
        ResponseMessageParser.PaymentPostBack response;
        String payload;
        if (!GatewayUtils.isIPAddressValid(req.getRemoteAddr(), this._config.getPostbackAllowedIp())) {
            String msg = "Received transaction details from a disallowed IP address. Transaction ignored. See payment gateway log file for details.";
            GatewayUtils.LogHelper.logWarn(logger, "Received transaction details from a disallowed IP address. Transaction ignored. See payment gateway log file for details.", null, this.getApplicationLogManager());
            return "Received transaction details from a disallowed IP address. Transaction ignored. See payment gateway log file for details.";
        }
        String localSecret = this._config.getSharedSecret();
        if (StringUtils.isBlank((String)localSecret)) {
            GatewayUtils.LogHelper.logDebug(logger, "Shared secret not configured. Skipping validation.");
        } else if (!req.getRequestURI().contains(localSecret)) {
            String msg = "Mismatched shared secret in the URL for the reported transaction. Transaction ignored. See payment gateway log file for details.";
            GatewayUtils.LogHelper.logWarn(logger, "Mismatched shared secret in the URL for the reported transaction. Transaction ignored. See payment gateway log file for details.", null, this.getApplicationLogManager());
            return "Mismatched shared secret in the URL for the reported transaction. Transaction ignored. See payment gateway log file for details.";
        }
        try {
            ServletInputStream inputStream = req.getInputStream();
            if (inputStream == null) {
                String msg = "Empty post back response payload from: " + req.getRemoteHost();
                GatewayUtils.LogHelper.logWarn(logger, msg, null, this.getApplicationLogManager());
                return msg;
            }
            payload = IOUtils.toString((InputStream)inputStream, (String)req.getCharacterEncoding());
        }
        catch (IOException e) {
            String msg = "Couldn't parse post-back response from: " + req.getRemoteHost();
            GatewayUtils.LogHelper.logWarn(logger, msg, e, this.getApplicationLogManager());
            return msg;
        }
        try {
            response = ResponseMessageParser.valueOf(payload);
            logger.debug(this.buildLogMessage(response));
        }
        catch (ProtocolException e) {
            String msg = "Couldn't decode the payload as an Official Payments post back XML response.";
            GatewayUtils.LogHelper.logWarn(logger, "Couldn't decode the payload as an Official Payments post back XML response.", null, this.getApplicationLogManager());
            return "Couldn't decode the payload as an Official Payments post back XML response.";
        }
        String orderId = response.getPaymentIdentifier();
        this._orderStatus.put(orderId, OrderStatus.Declined);
        if (!"Approved".equalsIgnoreCase(response.getResultText()) || !"A".equals(response.getResultCode())) {
            String msg = "Transaction '" + orderId + "' wasn't approved by Official Payments, the status is: " + response.getResultText();
            GatewayUtils.LogHelper.logInfo(logger, msg, null, this.getApplicationLogManager());
            return msg;
        }
        Double amount = 0.0;
        if (response.getPaymentAmounts().isEmpty() || response.getPaymentAmounts().getFirst() == null) {
            String msg = "Transaction '" + orderId + "' doesn't specify, the payment amount and cannot be processed";
            GatewayUtils.LogHelper.logWarn(logger, msg, null, this.getApplicationLogManager());
            return msg;
        }
        amount = response.getPaymentAmounts().getFirst();
        GatewayUtils.LogHelper.logInfo(logger, "Completing order " + orderId + " for " + amount);
        CreditCardGatewayPlugin.OrderResponse result = this.getCreditCardGatewayPlugin().confirmOrder(orderId, amount);
        GatewayUtils.LogHelper.logInfo(logger, "Order " + orderId + " result: " + result.isSuccess() + ", previously processed? " + result.isAlreadyProcessed() + ", message: " + result.getMessage());
        if (!result.isSuccess()) {
            return result.getMessage();
        }
        this._orderStatus.put(orderId, OrderStatus.Approved);
        return null;
    }

    public String buildLogMessage(ResponseMessageParser.PaymentPostBack response) {
        return this.getClass().getSimpleName() + " Response: {" + StringUtils.join(this.getPropertiesToLog(response), (String)", ") + "}";
    }

    private List<String> getPropertiesToLog(ResponseMessageParser.PaymentPostBack response) {
        return List.of("payment identifier: " + response.getPaymentIdentifier(), "result code: " + response.getResultCode(), "result text: " + response.getResultText(), "transaction date: " + response.getTransactionDate(), "transaction time: " + response.getTransactionTime(), "payment amounts: " + String.valueOf(response.getPaymentAmounts()), "transaction fee: " + response.getTransactionFee(), "total charge: " + response.getTotalCharge(), "amount type: " + response.getAccountType(), "authorization code: " + response.getAuthorizationCode(), "receipt number: " + response.getReceiptNumber(), "payment ID: " + response.getPaymentID(), "payment channel: " + response.getPaymentChannel());
    }

    public static enum OrderStatus {
        Unknown,
        Pending,
        Approved,
        Declined;

    }

    public static class OfficialPaymentsPOSTBackServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
            this.debugLogRequest(req);
            String error = this.getPlugin().validateResponse(req);
            if (error != null) {
                try {
                    resp.sendError(500, error);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void debugLogRequest(HttpServletRequest request) {
            if (logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append(((Object)((Object)this)).getClass().getSimpleName()).append(" accessed via ").append(request.getMethod());
                msg.append(", URL: ").append(request.getRequestURL());
                msg.append(", from: ").append(request.getRemoteAddr());
                msg.append(", params: ");
                for (Map.Entry e : request.getParameterMap().entrySet()) {
                    String value = ((String[])e.getValue()).length > 1 ? ArrayUtils.toString(e.getValue()) : ((String[])e.getValue())[0];
                    msg.append((String)e.getKey()).append('=').append(value).append(',');
                }
                logger.debug(msg.toString());
            }
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.debugLogRequest(request);
            response.setContentType("text/html");
            response.getWriter().write("<html><body><h1>" + ((Object)((Object)this)).getClass().getSimpleName() + " URL is accessible as of " + String.valueOf(new Date()) + "</h1><p>Remember to ensure that the URL is externally accessible (i.e. that the OfficialPayments server has access)</p></body></html>");
        }

        protected OfficialPaymentsPlugin getPlugin() {
            return (OfficialPaymentsPlugin)PluginManager.getInstance().getPluginByClass(OfficialPaymentsPlugin.class);
        }
    }
}

