/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.officialpayments;

import biz.papercut.pcng.ext.paymentgateway.ProtocolException;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.UnmarshallerHandler;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class ResponseMessageParser {
    private static final Logger logger = LoggerFactory.getLogger(ResponseMessageParser.class);
    static final String NAMESPACE = "http://www.officialpayments.com/PaymentPostBack/";
    private static JAXBContext jaxbContext;

    public static PaymentPostBack valueOf(String xml) throws ProtocolException {
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (PaymentPostBack)unmarshaller.unmarshal((Reader)new StringReader(xml));
        }
        catch (JAXBException e) {
            logger.error("Failed to unmarshal XML post-back response: {}", (Object)String.valueOf((Object)e));
            throw new ProtocolException("Couldn't parse payment postback response", e);
        }
    }

    public static PaymentPostBack valueOfLenient(String xml) throws ProtocolException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            UnmarshallerHandler handler = unmarshaller.getUnmarshallerHandler();
            NamespaceFilter filter = new NamespaceFilter();
            filter.setParent(xr);
            filter.setContentHandler((ContentHandler)handler);
            InputSource source = new InputSource(new StringReader(xml));
            filter.parse(source);
            return (PaymentPostBack)handler.getResult();
        }
        catch (Exception e) {
            logger.error("Failed to unmarshal XML post-back response: {}", (Object)String.valueOf(e));
            throw new ProtocolException("Couldn't parse payment postback response", e);
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PaymentPostBack.class});
        }
        catch (JAXBException e) {
            logger.error("Error in JAXB deployment", (Throwable)e);
        }
    }

    @XmlRootElement(name="PaymentPostBack", namespace="http://www.officialpayments.com/PaymentPostBack/")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class PaymentPostBack {
        static final String OP_RESULT_APPROVED = "Approved";
        static final String OP_RESULT_DECLINED = "Declined";
        static final String OP_RESULT_CODE_APPROVED = "A";
        static final String OP_RESULT_CODE_DECLINED = "D";
        private String paymentIdentifier;
        private String resultCode;
        private String resultText;
        private String transactionDate;
        private String transactionTime;
        @XmlElementWrapper(name="paymentAmounts")
        @XmlElement(name="paymentAmount")
        private List<Double> paymentAmounts;
        private Double transactionFee;
        private Double totalCharge;
        private String accountType;
        private String authorizationCode;
        private String receiptNumber;
        private String paymentID;
        private String phoneNumber;
        @XmlElement(name="name")
        private Name name;
        @XmlElement(name="address")
        private Address address;
        private String emailAddress;
        private String paymentChannel;
        @XmlElementWrapper(name="customDataElements")
        @XmlElement(name="customDataElement")
        private List<String> customDataElements;

        public String getPaymentIdentifier() {
            return this.paymentIdentifier;
        }

        public void setPaymentIdentifier(String paymentIdentifier) {
            this.paymentIdentifier = paymentIdentifier;
        }

        public String getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        public String getResultText() {
            return this.resultText;
        }

        public void setResultText(String resultText) {
            this.resultText = resultText;
        }

        public String getTransactionDate() {
            return this.transactionDate;
        }

        public void setTransactionDate(String transactionDate) {
            this.transactionDate = transactionDate;
        }

        public String getTransactionTime() {
            return this.transactionTime;
        }

        public void setTransactionTime(String transactionTime) {
            this.transactionTime = transactionTime;
        }

        public List<Double> getPaymentAmounts() {
            return this.paymentAmounts;
        }

        public void setPaymentAmounts(List<Double> paymentAmounts) {
            this.paymentAmounts = paymentAmounts;
        }

        public Double getTransactionFee() {
            return this.transactionFee;
        }

        public void setTransactionFee(Double transactionFee) {
            this.transactionFee = transactionFee;
        }

        public Double getTotalCharge() {
            return this.totalCharge;
        }

        public void setTotalCharge(Double totalCharge) {
            this.totalCharge = totalCharge;
        }

        public String getAccountType() {
            return this.accountType;
        }

        public void setAccountType(String accountType) {
            this.accountType = accountType;
        }

        public String getAuthorizationCode() {
            return this.authorizationCode;
        }

        public void setAuthorizationCode(String authorizationCode) {
            this.authorizationCode = authorizationCode;
        }

        public String getReceiptNumber() {
            return this.receiptNumber;
        }

        public void setReceiptNumber(String receiptNumber) {
            this.receiptNumber = receiptNumber;
        }

        public String getPaymentID() {
            return this.paymentID;
        }

        public void setPaymentID(String paymentId) {
            this.paymentID = paymentId;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public Name getName() {
            return this.name;
        }

        public void setName(Name name) {
            this.name = name;
        }

        public Address getAddress() {
            return this.address;
        }

        public void setAddress(Address address) {
            this.address = address;
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        public void setEmailAddress(String email) {
            this.emailAddress = email;
        }

        public String getPaymentChannel() {
            return this.paymentChannel;
        }

        public void setPaymentChannel(String paymentChannel) {
            this.paymentChannel = paymentChannel;
        }

        public List<String> getCustomDataElements() {
            return this.customDataElements;
        }

        public void setCustomDataElements(List<String> customDataElements) {
            this.customDataElements = customDataElements;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PaymentPostBack [");
            if (this.paymentIdentifier != null) {
                builder.append("paymentIdentifier=");
                builder.append(this.paymentIdentifier);
                builder.append(", ");
            }
            if (this.resultCode != null) {
                builder.append("resultCode=");
                builder.append(this.resultCode);
                builder.append(", ");
            }
            if (this.resultText != null) {
                builder.append("resultText=");
                builder.append(this.resultText);
                builder.append(", ");
            }
            if (this.transactionDate != null) {
                builder.append("transactionDate=");
                builder.append(this.transactionDate);
                builder.append(", ");
            }
            if (this.transactionTime != null) {
                builder.append("transactionTime=");
                builder.append(this.transactionTime);
                builder.append(", ");
            }
            if (this.paymentAmounts != null) {
                builder.append("paymentAmount=");
                builder.append(this.paymentAmounts);
                builder.append(", ");
            }
            if (this.transactionFee != null) {
                builder.append("transactionFee=");
                builder.append(this.transactionFee);
                builder.append(", ");
            }
            if (this.totalCharge != null) {
                builder.append("totalCharge=");
                builder.append(this.totalCharge);
                builder.append(", ");
            }
            if (this.accountType != null) {
                builder.append("accountType=");
                builder.append(this.accountType);
                builder.append(", ");
            }
            if (this.authorizationCode != null) {
                builder.append("authorizationCode=");
                builder.append(this.authorizationCode);
                builder.append(", ");
            }
            if (this.receiptNumber != null) {
                builder.append("receiptNumber=");
                builder.append(this.receiptNumber);
                builder.append(", ");
            }
            if (this.paymentID != null) {
                builder.append("paymentId=");
                builder.append(this.paymentID);
                builder.append(", ");
            }
            if (this.phoneNumber != null) {
                builder.append("phoneNumber=");
                builder.append(this.phoneNumber);
                builder.append(", ");
            }
            if (this.name != null) {
                builder.append("name=");
                builder.append(this.name);
                builder.append(", ");
            }
            if (this.address != null) {
                builder.append("address=");
                builder.append(this.address);
                builder.append(", ");
            }
            if (this.emailAddress != null) {
                builder.append("email=");
                builder.append(this.emailAddress);
                builder.append(", ");
            }
            if (this.paymentChannel != null) {
                builder.append("paymentChannel=");
                builder.append(this.paymentChannel);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    static class NamespaceFilter
    extends XMLFilterImpl {
        NamespaceFilter() {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(ResponseMessageParser.NAMESPACE, localName, qName);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(ResponseMessageParser.NAMESPACE, localName, qName, atts);
        }
    }

    @XmlRootElement(name="address")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class Address {
        private String street1;
        private String street2;
        private String city;
        private String stateOrProvince;
        private String zipOrPostalCode;
        private String countryCode;

        Address() {
        }

        public String getStreet1() {
            return this.street1;
        }

        public void setStreet1(String street1) {
            this.street1 = street1;
        }

        public String getStreet2() {
            return this.street2;
        }

        public void setStreet2(String street2) {
            this.street2 = street2;
        }

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getStateOrProvince() {
            return this.stateOrProvince;
        }

        public void setStateOrProvince(String stateOrProvince) {
            this.stateOrProvince = stateOrProvince;
        }

        public String getZipOrPostalCode() {
            return this.zipOrPostalCode;
        }

        public void setZipOrPostalCode(String zipOrPostalCode) {
            this.zipOrPostalCode = zipOrPostalCode;
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Address [");
            if (this.street1 != null) {
                builder.append("street1=");
                builder.append(this.street1);
                builder.append(", ");
            }
            if (this.street2 != null) {
                builder.append("street2=");
                builder.append(this.street2);
                builder.append(", ");
            }
            if (this.city != null) {
                builder.append("city=");
                builder.append(this.city);
                builder.append(", ");
            }
            if (this.stateOrProvince != null) {
                builder.append("stateOrProvince=");
                builder.append(this.stateOrProvince);
                builder.append(", ");
            }
            if (this.zipOrPostalCode != null) {
                builder.append("zipOrPostalCode=");
                builder.append(this.zipOrPostalCode);
                builder.append(", ");
            }
            if (this.countryCode != null) {
                builder.append("countryCode=");
                builder.append(this.countryCode);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    @XmlRootElement(name="name")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class Name {
        private String first;
        private String middle;
        private String last;
        private String suffix;

        Name() {
        }

        public String getFirst() {
            return this.first;
        }

        public void setFirst(String first) {
            this.first = first;
        }

        public String getMiddle() {
            return this.middle;
        }

        public void setMiddle(String middle) {
            this.middle = middle;
        }

        public String getLast() {
            return this.last;
        }

        public void setLast(String last) {
            this.last = last;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Name [");
            if (this.first != null) {
                builder.append("first=");
                builder.append(this.first);
                builder.append(", ");
            }
            if (this.middle != null) {
                builder.append("middle=");
                builder.append(this.middle);
                builder.append(", ");
            }
            if (this.last != null) {
                builder.append("last=");
                builder.append(this.last);
                builder.append(", ");
            }
            if (this.suffix != null) {
                builder.append("suffix=");
                builder.append(this.suffix);
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

