/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.pages;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.AuthorizeNetPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthorizeNetRedirect
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizeNetRedirect.class);
    public static final String PAGE_NAME = "AuthorizeNetRedirect";

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract double getAmount();

    public abstract void setAmount(double var1);

    public abstract String getOrderId();

    public abstract void setOrderId(String var1);

    public abstract String getTimestamp();

    public abstract void setTimestamp(String var1);

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public void activate(IRequestCycle cycle, User user, double amount) {
        this.setUser(user);
        this.setAmount(amount);
        HttpServletRequest r = this.getRequest();
        String returnRedirectURL = r.getScheme() + "://" + r.getServerName() + ":" + r.getServerPort() + "/app?service=external/ExtnAuthorizeNet";
        String orderId = this.getAuthorizeNetPlugin().createNewOrder(user.getUserName(), amount, returnRedirectURL);
        this.setOrderId(orderId);
        long currentUTCMillis = System.currentTimeMillis();
        long currentUTCSecs = currentUTCMillis / 1000L;
        this.setTimestamp(String.valueOf(currentUTCSecs));
        logger.debug("Associated return redirect URL {} with order {} for user {}.  Timestamp: {}", new Object[]{returnRedirectURL, orderId, user.getUserName(), this.getTimestamp()});
        cycle.activate((IPage)this);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            throw new PageRedirectException("ExtnAuthorizeNet");
        }
    }

    public String getPOSTURL() {
        return this.getGatewayConfig().getString("authorize-net.post-url");
    }

    public String getFingerprintHash() {
        return this.getAuthorizeNetPlugin().calculateFingerprintHash(this.getLogin(), this.getFingerprintSequence(), this.getTimestamp(), this.getFormattedAmount());
    }

    public String getFingerprintSequence() {
        return this.getOrderId();
    }

    public String getRequestIP() {
        return this.getRequest().getRemoteAddr();
    }

    public String getPostbackURL() {
        String serverName = this.getGatewayConfig().getString("authorize-net.public-relay-response-hostname");
        return "http://" + serverName + "/rpc/gateway/authorize-net";
    }

    public String getLogin() {
        return this.getGatewayConfig().getString("authorize-net.login");
    }

    public String getFormattedAmount() {
        return GatewayUtils.formatNumber(this.getAmount(), 2, Locale.US, false);
    }

    public String getPaymentFormDescription() {
        return this.getAuthorizeNetPlugin().getPaymentFormDescription();
    }

    private AuthorizeNetPlugin getAuthorizeNetPlugin() {
        return (AuthorizeNetPlugin)PluginManager.getInstance().getPluginByClass(AuthorizeNetPlugin.class);
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }
}

