/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.pages;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.BarclaycardEPDQPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import java.text.DecimalFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BarclaycardEPDQRedirect
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(BarclaycardEPDQRedirect.class);

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract void setAmount(String var1);

    public abstract void setEncryptedDataInputTag(String var1);

    public abstract void setOrderId(String var1);

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public void activate(IRequestCycle cycle, User user, double amount) {
        this.setUser(user);
        DecimalFormat fmt = new DecimalFormat("0");
        String amountStr = fmt.format(amount * 100.0);
        this.setAmount(amountStr);
        HttpServletRequest r = this.getRequest();
        String returnRedirectURL = r.getScheme() + "://" + r.getServerName() + ":" + r.getServerPort() + "/app?service=external/ExtnBarclaycardEPDQ";
        String orderId = this.getBarclaycardEPDQPlugin().createNewOrder(user.getUserName(), amount, returnRedirectURL);
        this.setOrderId(orderId);
        String encryptedDataInputTag = this.getBarclaycardEPDQPlugin().getEncryptedDataInputTag(orderId, amount);
        if (StringUtils.isBlank((String)encryptedDataInputTag)) {
            this.addErrorMessage(GatewayConfig.getInstance().getUserErrorMessage());
            throw new PageRedirectException("ExtnBarclaycardEPDQ");
        }
        this.setEncryptedDataInputTag(encryptedDataInputTag);
        logger.debug("Associated return redirect URL {} with order {} for user {}", new Object[]{returnRedirectURL, orderId, user.getUserName()});
        cycle.activate((IPage)this);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            throw new PageRedirectException("ExtnBarclaycardEPDQ");
        }
    }

    public String getPaymentPageURL() {
        return GatewayConfig.getInstance().getString("barclaycard-epdq.epdq-payment-page-url");
    }

    public String getReturnURL() {
        RequestContext rc = this.getRequestCycle().getRequestContext();
        String securityToken = GatewayConfig.getInstance().getString("barclaycard-epdq.security-token");
        return rc.getScheme() + "://" + rc.getServerName() + ":" + rc.getServerPort() + "/rpc/gateway/barclaycardepdq/" + securityToken;
    }

    public String getMerchantName() {
        return GatewayConfig.getInstance().getString("barclaycard-epdq.merchant-name");
    }

    public String getPspId() {
        return GatewayConfig.getInstance().getString("barclaycard-epdq.client-id");
    }

    public String getLanguage() {
        return GatewayConfig.getInstance().getString("barclaycard-epdq.language");
    }

    public String getCurrency() {
        return GatewayConfig.getInstance().getString("barclaycard-epdq.currency-code");
    }

    private BarclaycardEPDQPlugin getBarclaycardEPDQPlugin() {
        return (BarclaycardEPDQPlugin)PluginManager.getInstance().getPluginByClass(BarclaycardEPDQPlugin.class);
    }
}

