/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.pages;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.BarclaycardPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BarclaycardRedirect
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(BarclaycardRedirect.class);

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract void setAmount(double var1);

    public abstract void setEncryptedDataInputTag(String var1);

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public void activate(IRequestCycle cycle, User user, double amount) {
        this.setUser(user);
        this.setAmount(amount);
        HttpServletRequest r = this.getRequest();
        String returnRedirectURL = r.getScheme() + "://" + r.getServerName() + ":" + r.getServerPort() + "/app?service=external/ExtnBarclaycard";
        String orderId = this.getBarclaycardPlugin().createNewOrder(user.getUserName(), amount, returnRedirectURL);
        String encryptedDataInputTag = this.getBarclaycardPlugin().getEncryptedDataInputTag(orderId, amount);
        if (StringUtils.isBlank((String)encryptedDataInputTag)) {
            this.addErrorMessage(GatewayConfig.getInstance().getUserErrorMessage());
            throw new PageRedirectException("ExtnBarclaycard");
        }
        this.setEncryptedDataInputTag(encryptedDataInputTag);
        logger.debug("Associated return redirect URL {} with order {} for user {}", new Object[]{returnRedirectURL, orderId, user.getUserName()});
        cycle.activate((IPage)this);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            throw new PageRedirectException("ExtnBarclaycard");
        }
    }

    public String getPaymentPageURL() {
        return GatewayConfig.getInstance().getString("barclaycard.epdq-payment-page-url");
    }

    public String getReturnURL() {
        RequestContext rc = this.getRequestCycle().getRequestContext();
        String securityToken = GatewayConfig.getInstance().getString("barclaycard.security-token");
        return rc.getScheme() + "://" + rc.getServerName() + ":" + rc.getServerPort() + "/rpc/gateway/barclaycard/" + securityToken;
    }

    public String getMerchantName() {
        return GatewayConfig.getInstance().getString("barclaycard.merchant-name");
    }

    private BarclaycardPlugin getBarclaycardPlugin() {
        return (BarclaycardPlugin)PluginManager.getInstance().getPluginByClass(BarclaycardPlugin.class);
    }
}

