/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.pages;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.ExternalCreditSourcePlugin;
import biz.papercut.pcng.ext.paymentgateway.ExternalCreditSourceProvider;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.MyStudentAccountProvider;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.CreditSourceManager;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.Visit;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.ValidationDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnAddCredit
extends BasePaperCutPage
implements PageRenderListener {
    private static final Logger logger = LoggerFactory.getLogger(ExtnAddCredit.class);
    private static final String CONFIG_PREFIX = "external-credit-source.";
    private static final String CONFIG_ALLOWED_AMOUNTS = "external-credit-source.allowed-amounts";
    private static final String CONFIG_SOURCE = "external-credit-source.source";

    public abstract Double getAmount();

    public abstract void setAmount(Double var1);

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract UserManager getUserManager();

    public abstract AccountManager getAccountManager();

    public abstract CreditSourceManager getCreditSourceManager();

    public abstract ApplicationLogManager getApplicationLogManager();

    public abstract LicenseManager getLicenseManager();

    public String getPageTitle() {
        String title = this.getPlugin().getPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            String userName = ((Visit)this.getVisit()).getUserName();
            User u = this.getUserManager().getUser(userName);
            this.setUser(u);
        }
        if (!event.getRequestCycle().isRewinding()) {
            if (this.getExternalCreditProvider() == null) {
                this.addWarningMessage("This module has not been configured. Please ensure 'external-credit-source' is correctly set in ext-payment-gateway-external-credit-source.properties");
            }
            if (!this.isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
        }
    }

    private ExternalCreditSourcePlugin getPlugin() {
        return (ExternalCreditSourcePlugin)PluginManager.getInstance().getPluginByClass(ExternalCreditSourcePlugin.class);
    }

    public String getNoAccessMsg() {
        return GatewayConfig.getInstance().getNoAccessMessage();
    }

    public String getHeading() {
        ExternalCreditSourceProvider creditProvider = this.getExternalCreditProvider();
        if (creditProvider == null || StringUtils.isBlank((String)creditProvider.getSourceName())) {
            return "Add Credit to Account";
        }
        return "Add Credit from " + creditProvider.getSourceName();
    }

    public String getAvailableCreditLabel() {
        ExternalCreditSourceProvider creditProvider = this.getExternalCreditProvider();
        if (creditProvider == null || StringUtils.isBlank((String)creditProvider.getSourceName())) {
            return "Available Credit";
        }
        return "Available Credit in " + creditProvider.getSourceName();
    }

    public boolean userCanUse() {
        return this.getPlugin().userHasAccess(this.getPaperCutVisit().getUserName());
    }

    public Double getAvailableCredit() {
        ExternalCreditSourceProvider creditProvider = this.getExternalCreditProvider();
        if (creditProvider == null) {
            return null;
        }
        Double avaliableCredit = null;
        try {
            avaliableCredit = creditProvider.availableCredit(this.getUser().getUserName(), this.getUser().getFullName(), this.getUser().getCardNumber());
        }
        catch (Exception e) {
            avaliableCredit = null;
        }
        return avaliableCredit;
    }

    public void doTransaction(IRequestCycle cycle) {
        GatewayConfig conf;
        ValidationDelegate delegate = (ValidationDelegate)this.getBeans().getBean("delegate");
        if (delegate.getHasErrors()) {
            this.addErrorMessage(delegate.getFirstError().toString());
            return;
        }
        if (!this.userCanUse()) {
            this.addErrorMessage("You do not have permission to access this feature.");
            return;
        }
        if (this.getAmount() == null) {
            this.addErrorMessage("Please select an amount to add to your account.");
            return;
        }
        double amount = this.getAmount();
        if (amount <= 0.0) {
            this.addErrorMessage("The amount must be greater than zero.");
            return;
        }
        String formattedAmount = this.formatBalance(amount);
        ExternalCreditSourceProvider creditProvider = this.getExternalCreditProvider();
        if (creditProvider == null) {
            return;
        }
        boolean success = false;
        try {
            ExternalCreditSourceProvider.RequestResponse response = null;
            response = creditProvider.withdrawCredit(this.getUser().getUserName(), this.getUser().getFullName(), this.getUser().getCardNumber(), amount, "");
            if (response.isSuccess()) {
                String transactionComment = "Funds added from " + creditProvider.getSourceName();
                if (!StringUtils.isEmpty((String)response.getMessage())) {
                    transactionComment = transactionComment + " External Data: " + response.getMessage();
                }
                GatewayUtils.addCreditToUser(this.getAccountManager(), this.getCreditSourceManager(), this.getUser(), amount, transactionComment);
                this.addStatusMessage(this.formatBalance(amount) + " was successfully added to your account.");
                cycle.activate("UserSummary");
                success = true;
            } else {
                this.addErrorMessage("Unable to perform transaction: " + response.getMessage());
                this.getApplicationLogManager().logInfo(((Object)((Object)this)).getClass(), "ExtnAddCredit.failed-transaction", new String[]{formattedAmount, this.getUser().getUserName(), response.getMessage()});
            }
        }
        catch (Exception e) {
            logger.error("Unable to perform add credit transaction on user: {}", (Object)this.getUser().getUserName(), (Object)e);
            this.addErrorMessage("Failed to add " + formattedAmount + " to your account: " + e.getMessage());
            this.getApplicationLogManager().logInfo(((Object)((Object)this)).getClass(), "ExtnAddCredit.failed-transaction", new String[]{formattedAmount, this.getUser().getUserName(), e.getMessage()});
        }
        if (!success && StringUtils.isNotBlank((String)(conf = GatewayConfig.getInstance()).getUserErrorMessage())) {
            this.addErrorMessage(conf.getUserErrorMessage());
        }
    }

    private boolean isLicensed() {
        return this.getPlugin().isLicensed(this.getExternalCreditProvider());
    }

    public ExternalCreditSourceProvider getExternalCreditProvider() {
        ExternalCreditSourceProvider ret = null;
        String src = GatewayConfig.getInstance().getString(CONFIG_SOURCE);
        if (StringUtils.isBlank((String)src)) {
            logger.error("'external-credit-source.source' is not defined in the gateway config file.");
            return null;
        }
        if (src.equals("MY_STUDENT_ACCOUNT")) {
            ret = new MyStudentAccountProvider();
        } else {
            try {
                ret = (ExternalCreditSourceProvider)Class.forName(src).newInstance();
            }
            catch (Exception e) {
                logger.error("Unable to load extenal credit provider class: {}", (Object)src, (Object)e);
            }
        }
        if (ret != null) {
            GatewayConfig conf = GatewayConfig.getInstance();
            ret.setConfig(conf.getAllProperties());
        }
        return ret;
    }

    public IPropertySelectionModel getAllowedAmountsModel() {
        return GatewayUtils.createAllowedAmountsModel(CONFIG_ALLOWED_AMOUNTS, (BasePaperCutPage)this);
    }

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    private static GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public String getPageMessage() {
        return ExtnAddCredit.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return ExtnAddCredit.getGatewayConfig().getPageMessageAvailable();
    }
}

