/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.pages;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.AuthorizeNetPlugin;
import biz.papercut.pcng.ext.paymentgateway.BasePaymentGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.pages.AuthorizeNetRedirect;
import biz.papercut.pcng.ext.paymentgateway.pages.BasePaymentGatewayPage;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnAuthorizeNet
extends BasePaymentGatewayPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(ExtnAuthorizeNet.class);
    public static final String PAGE_NAME = "ExtnAuthorizeNet";

    @Override
    public abstract AccountManager getAccountManager();

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(this.createAmountsModel());
        }
        if (!this.getRequestCycle().isRewinding()) {
            String orderId;
            String configError;
            if (!this.getAuthorizeNetPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = this.getAuthorizeNetPlugin().getIsConfigured()) != null) {
                this.addWarningMessage(configError);
                logger.error(configError);
            }
            if (!StringUtils.isBlank((String)(orderId = this.getRequestCycle().getRequestContext().getParameter("order-id")))) {
                Boolean success = this.getAuthorizeNetPlugin().finalize(orderId);
                if (success == null) {
                    this.addErrorMessage(GatewayConfig.getInstance().getUserErrorMessage());
                } else if (success.booleanValue()) {
                    this.addStatusMessage("Funds have been added to your account");
                } else {
                    this.addWarningMessage("Your transaction was canceled");
                }
            }
        }
    }

    public void formSubmit(IRequestCycle cycle) {
        Double amount = this.getAmount();
        if (amount == null || amount <= 0.0) {
            this.addErrorMessage("Please select an amount to add");
            return;
        }
        AuthorizeNetRedirect redirectPage = (AuthorizeNetRedirect)cycle.getPage("AuthorizeNetRedirect");
        redirectPage.activate(cycle, this.getUser(), amount);
    }

    public void redirectToSummaryPage(IRequestCycle cycle) {
        cycle.activate("UserSummary");
    }

    @Override
    public BasePaymentGatewayPlugin getPlugin() {
        return this.getAuthorizeNetPlugin();
    }

    public void activateExternalPage(Object[] arguments, IRequestCycle cycle) {
    }

    private AuthorizeNetPlugin getAuthorizeNetPlugin() {
        return (AuthorizeNetPlugin)PluginManager.getInstance().getPluginByClass(AuthorizeNetPlugin.class);
    }
}

