/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.pages;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.BarclaycardPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.pages.BarclaycardRedirect;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.Formatter;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnBarclaycard
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(ExtnBarclaycard.class);
    public static final String PAGE_NAME = "ExtnBarclaycard";

    public abstract User getUser();

    public abstract void setUser(User var1);

    @CheckForNull
    public abstract Double getAmount();

    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract UserManager getUserManager();

    public abstract AccountManager getAccountManager();

    public abstract ApplicationLogManager getApplicationLogManager();

    public abstract LicenseManager getLicenseManager();

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public String getPageTitle() {
        String title = this.getBarclaycardPlugin().getPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public void activateExternalPage(Object[] arguments, IRequestCycle cycle) {
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(this.createAmountsModel());
        }
        if (!this.getRequestCycle().isRewinding()) {
            String qs;
            String configError;
            if (!this.getBarclaycardPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = this.getBarclaycardPlugin().getIsConfigured()) != null) {
                this.addWarningMessage(configError);
                logger.error(configError);
            }
            if ((qs = this.getRequest().getQueryString()).contains("success=true")) {
                this.addStatusMessage("Funds have been added to your account");
            } else if (qs.contains("success=false")) {
                this.addErrorMessage(GatewayConfig.getInstance().getUserErrorMessage());
            }
        }
    }

    public void formSubmit(IRequestCycle cycle) {
        Double amount = this.getAmount();
        if (amount == null || amount <= 0.0) {
            this.addErrorMessage("Please select an amount to add");
            return;
        }
        BarclaycardRedirect redirectPage = (BarclaycardRedirect)cycle.getPage("BarclaycardRedirect");
        redirectPage.activate(cycle, this.getUser(), amount);
    }

    private IPropertySelectionModel createAmountsModel() {
        return GatewayUtils.createAllowedAmountsModel("barclaycard.allowed-amounts", (BasePaperCutPage)this);
    }

    public String getNoAccessMsg() {
        return GatewayConfig.getInstance().getNoAccessMessage();
    }

    public String getHeading() {
        GatewayConfig conf = GatewayConfig.getInstance();
        String heading = conf.getString("barclaycard.page-heading");
        if (StringUtils.isBlank((String)heading)) {
            heading = "Add credit using a Credit Card";
        }
        return heading;
    }

    public String formatAmountInDropdown(double amount) {
        if (amount < 0.01) {
            return "--- Select the amount ---";
        }
        return this.formatBalance(amount);
    }

    private BarclaycardPlugin getBarclaycardPlugin() {
        return (BarclaycardPlugin)PluginManager.getInstance().getPluginByClass(BarclaycardPlugin.class);
    }

    public boolean isAccessibleByUser() {
        return this.getBarclaycardPlugin().isAccessibleByUser(this.getPaperCutVisit().getUserName());
    }

    public List<Double> getAllowedAmounts() {
        GatewayConfig conf = GatewayConfig.getInstance();
        return conf.getDoubleList("barclaycard.allowed-amounts");
    }

    public String formatAmount(double amount) {
        return Formatter.formatNumber((double)amount, (int)2, (Locale)Locale.US);
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public String getPageMessage() {
        return this.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return this.getGatewayConfig().getPageMessageAvailable();
    }
}

