/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.pages;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.MonerisPlugin;
import biz.papercut.pcng.ext.paymentgateway.pages.MonerisRedirect;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnMoneris
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(ExtnMoneris.class);
    public static final String PAGE_NAME = "ExtnMoneris";

    public abstract boolean isShowReceipt();

    public abstract void setShowReceipt(boolean var1);

    public abstract User getUser();

    public abstract void setUser(User var1);

    @CheckForNull
    public abstract Double getAmount();

    public abstract void setAmount(Double var1);

    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract String getTransactionType();

    public abstract void setTransactionType(String var1);

    public abstract String getTimestamp();

    public abstract void setTimestamp(String var1);

    public abstract String getTransactionAmount();

    public abstract void setTransactionAmount(String var1);

    public abstract String getOrderId();

    public abstract void setOrderId(String var1);

    public abstract String getCardholderName();

    public abstract void setCardholderName(String var1);

    public abstract String getResponseCode();

    public abstract void setResponseCode(String var1);

    public abstract String getResponseMessage();

    public abstract void setResponseMessage(String var1);

    public abstract String getBankReferenceNumber();

    public abstract void setBankReferenceNumber(String var1);

    public abstract String getBankAuthCode();

    public abstract void setBankAuthCode(String var1);

    public abstract String getISOCode();

    public abstract void setISOCode(String var1);

    public abstract String getInteracCardIssuerName();

    public abstract void setInteracCardIssuerName(String var1);

    public abstract String getInteracIssuerConfirmation();

    public abstract void setInteracIssuerConfirmation(String var1);

    public abstract String getInteracInvoiceNumber();

    public abstract void setInteracInvoiceNumber(String var1);

    public abstract UserManager getUserManager();

    public abstract AccountManager getAccountManager();

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public String getPageTitle() {
        String title = this.getMonerisPlugin().getPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public void activateExternalPage(Object[] arguments, IRequestCycle cycle) {
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(GatewayUtils.createAllowedAmountsModel("moneris.allowed-amounts", (BasePaperCutPage)this));
        }
        if (!this.getRequestCycle().isRewinding()) {
            HttpServletRequest r;
            String qs;
            String configError;
            if (!this.getMonerisPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = this.getMonerisPlugin().getIsConfigured()) != null) {
                this.addWarningMessage(configError);
                logger.error(configError);
            }
            if (StringUtils.isNotBlank((String)(qs = (r = this.getRequest()).getQueryString()))) {
                if (qs.contains("response=approve")) {
                    this.addStatusMessage(this.getMessages().getMessage("success-message"));
                    this.setShowReceipt(true);
                    this.setTransactionType(r.getParameter("transaction-type"));
                    this.setTimestamp(r.getParameter("timestamp"));
                    this.setTransactionAmount(r.getParameter("transaction-amount"));
                    this.setOrderId(r.getParameter("order-id"));
                    this.setCardholderName(r.getParameter("cardholder-name"));
                    this.setResponseCode(r.getParameter("response-code"));
                    this.setResponseMessage(r.getParameter("response-message"));
                    this.setBankReferenceNumber(r.getParameter("bank-reference-number"));
                    this.setBankAuthCode(r.getParameter("bank-auth-code"));
                    this.setISOCode(r.getParameter("iso-code"));
                    this.setInteracCardIssuerName(r.getParameter("interac-card-issuer-name"));
                    this.setInteracInvoiceNumber(r.getParameter("interac-invoice-number"));
                    this.setInteracIssuerConfirmation(r.getParameter("interac-issuer-confirmation"));
                } else if (qs.contains("response=decline")) {
                    this.addWarningMessage(GatewayConfig.getInstance().getString("moneris.declined-message"));
                } else if (qs.contains("response=error")) {
                    this.addErrorMessage(GatewayConfig.getInstance().getUserErrorMessage());
                } else if (qs.contains("response=cancel")) {
                    this.addWarningMessage(this.getMessages().getMessage("transaction-cancelled"));
                }
            }
        }
    }

    public void formSubmit(IRequestCycle cycle) {
        Double amount = this.getAmount();
        if (amount == null || amount <= 0.0) {
            this.addErrorMessage(this.getMessages().getMessage("select-amount"));
            return;
        }
        MonerisRedirect redirectPage = (MonerisRedirect)cycle.getPage("MonerisRedirect");
        redirectPage.activate(cycle, this.getUser(), amount);
    }

    public void redirectToSummaryPage(IRequestCycle cycle) {
        cycle.activate("UserSummary");
    }

    public String getSuccessMessage() {
        return GatewayConfig.getInstance().getString("moneris.success-message");
    }

    public String getNoAccessMsg() {
        return GatewayConfig.getInstance().getNoAccessMessage();
    }

    public String getHeading() {
        GatewayConfig conf = GatewayConfig.getInstance();
        String heading = conf.getString("moneris.page-heading");
        if (StringUtils.isBlank((String)heading)) {
            heading = "Add credit using a Credit Card";
        }
        return heading;
    }

    public String getReceiptPageCurrency() {
        return this.getMonerisPlugin().getReceiptPageCurrency();
    }

    public boolean isAccessibleByUser() {
        return this.getMonerisPlugin().isAccessibleByUser(this.getPaperCutVisit().getUserName());
    }

    public List<Double> getAllowedAmounts() {
        GatewayConfig conf = GatewayConfig.getInstance();
        return conf.getDoubleList("moneris.allowed-amounts");
    }

    protected MonerisPlugin getMonerisPlugin() {
        return (MonerisPlugin)this.getPluginManager().getPluginByClass(MonerisPlugin.class);
    }

    protected PluginManager getPluginManager() {
        return PluginManager.getInstance();
    }

    private static GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public String getPageMessage() {
        return ExtnMoneris.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return ExtnMoneris.getGatewayConfig().getPageMessageAvailable();
    }
}

