/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.pages;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.monerisCheckout.MonerisCheckoutPlugin;
import biz.papercut.pcng.ext.paymentgateway.monerisCheckout.MonerisReceiptResponse;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import java.net.MalformedURLException;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnMonerisCheckout
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(ExtnMonerisCheckout.class);
    private final String PAYMENT_STATUS_COMPLETE = "complete";
    private final String PAYMENT_STATUS_CANCEL = "cancel";
    private final String PAYMENT_STATUS_ERROR = "error";
    public static final String PAGE_NAME = "ExtnMonerisCheckout";

    public abstract void setPaymentStage(PaymentStage var1);

    public abstract PaymentStage getPaymentStage();

    public abstract User getUser();

    public abstract void setUser(User var1);

    @CheckForNull
    public abstract Double getAmount();

    public abstract void setAmount(Double var1);

    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract String getTokenID();

    public abstract void setTokenID(String var1);

    public abstract String getOrderID();

    public abstract void setOrderID(String var1);

    public abstract String getPaymentResult();

    public abstract void setPaymentResult(String var1);

    public abstract String getReceiptTransactionType();

    public abstract void setReceiptTransactionType(String var1);

    public abstract String getTimestamp();

    public abstract void setTimestamp(String var1);

    public abstract String getTransactionAmount();

    public abstract void setTransactionAmount(String var1);

    public abstract String getCardholderName();

    public abstract void setCardholderName(String var1);

    public abstract String getResponseCode();

    public abstract void setResponseCode(String var1);

    public abstract String getResponseMessage();

    public abstract void setResponseMessage(String var1);

    public abstract String getBankReferenceNumber();

    public abstract void setBankReferenceNumber(String var1);

    public abstract String getBankAuthCode();

    public abstract void setBankAuthCode(String var1);

    public abstract String getISOCode();

    public abstract void setISOCode(String var1);

    public abstract UserManager getUserManager();

    public abstract AccountManager getAccountManager();

    public boolean isShowingReceipt() {
        return this.getPaymentStage() == PaymentStage.SHOW_RECEIPT;
    }

    public boolean isProcessingPayment() {
        return this.getPaymentStage() == PaymentStage.PROCESSING_PAYMENT;
    }

    public boolean isSelectAmount() {
        return this.getPaymentStage() == PaymentStage.SELECT_AMOUNT;
    }

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public String getPageTitle() {
        String title = this.getMonerisCheckoutPlugin().getPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public void activateExternalPage(Object[] arguments, IRequestCycle cycle) {
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(GatewayUtils.createAllowedAmountsModel("moneris-checkout.allowed-amounts", (BasePaperCutPage)this));
        }
        if (this.getPaymentStage() == null) {
            this.setPaymentStage(PaymentStage.SELECT_AMOUNT);
        }
        if (!this.getRequestCycle().isRewinding()) {
            String configError;
            if (!this.getMonerisCheckoutPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = this.getMonerisCheckoutPlugin().getIsConfigured()) != null) {
                this.addWarningMessage(configError);
                logger.error(configError);
            }
        }
    }

    public void formSubmit(IRequestCycle cycle) {
        Double amount = this.getAmount();
        if (amount == null || amount <= 0.0) {
            this.addErrorMessage(this.getMessages().getMessage("select-amount"));
            return;
        }
        MonerisCheckoutPlugin.MonerisOrder order = this.getMonerisCheckoutPlugin().createNewOrder(this.getUser().getUserName(), amount);
        if (order == null) {
            this.addErrorMessage(GatewayConfig.getInstance().getUserErrorMessage());
            return;
        }
        this.setPaymentStage(PaymentStage.PROCESSING_PAYMENT);
        this.setTokenID(order.getTicketID());
        this.setOrderID(order.getOrderID());
    }

    private String displayResponseCode(String responseCode) {
        if (StringUtils.isBlank((String)responseCode)) {
            return "";
        }
        int number = Integer.parseInt(responseCode);
        if (number < 50) {
            return this.getMessages().getMessage("approved");
        }
        return this.getMessages().getMessage("declined");
    }

    private void fillReceipt(MonerisReceiptResponse response) {
        this.addStatusMessage(this.getMessages().getMessage("success-message"));
        this.setReceiptTransactionType(response.getReceipt().getCreditCard().getTransactionFinancialType());
        this.setTimestamp(response.getReceipt().getCreditCard().getTransactionDate());
        this.setTransactionAmount(MonerisCheckoutPlugin.formatTransactionAmount(response.getRequest().getTransactionAmount()));
        this.setOrderID(response.getReceipt().getCreditCard().getOrderNumber());
        this.setCardholderName(response.getRequest().getCardholder());
        this.setResponseCode(response.getReceipt().getCreditCard().getResponseCode());
        this.setResponseMessage(this.displayResponseCode(response.getReceipt().getCreditCard().getResponseCode()));
        this.setBankReferenceNumber(response.getReceipt().getCreditCard().getReferenceNumber());
        this.setBankAuthCode(response.getReceipt().getCreditCard().getApprovalCode());
        this.setISOCode(response.getReceipt().getCreditCard().getIsoResponseCode());
    }

    public void paymentFormSubmit(IRequestCycle cycle) {
        String result;
        String orderID = this.getOrderID();
        switch (result = this.getPaymentResult()) {
            case "complete": {
                MonerisReceiptResponse response = this.getMonerisCheckoutPlugin().verifyTransaction(orderID);
                if (response == null || response.getReceipt() == null || !response.isSuccess()) {
                    this.addErrorMessage(GatewayConfig.getInstance().getUserErrorMessage());
                    this.setPaymentStage(PaymentStage.SELECT_AMOUNT);
                    return;
                }
                if (!response.getReceipt().isAccepted()) {
                    this.addWarningMessage(GatewayConfig.getInstance().getString("moneris-checkout.declined-message"));
                    this.setPaymentStage(PaymentStage.SELECT_AMOUNT);
                    return;
                }
                this.setPaymentStage(PaymentStage.SHOW_RECEIPT);
                this.fillReceipt(response);
                return;
            }
            case "cancel": {
                this.getMonerisCheckoutPlugin().cancelTransaction(orderID);
                this.addWarningMessage(this.getMessages().getMessage("transaction-cancelled"));
                this.setPaymentStage(PaymentStage.SELECT_AMOUNT);
                return;
            }
        }
        this.getMonerisCheckoutPlugin().cancelTransaction(orderID);
        this.addErrorMessage(GatewayConfig.getInstance().getUserErrorMessage());
        this.setPaymentStage(PaymentStage.SELECT_AMOUNT);
    }

    public void redirectToSummaryPage(IRequestCycle cycle) {
        cycle.activate("UserSummary");
    }

    public String getSuccessMessage() {
        return GatewayConfig.getInstance().getString("moneris-checkout.success-message");
    }

    public String getNoAccessMsg() {
        return GatewayConfig.getInstance().getNoAccessMessage();
    }

    public String getHeading() {
        GatewayConfig conf = GatewayConfig.getInstance();
        String heading = conf.getString("moneris-checkout.page-heading");
        if (StringUtils.isBlank((String)heading)) {
            heading = "Add credit using a Credit Card";
        }
        return heading;
    }

    public String getReceiptPageCurrency() {
        return this.getMonerisCheckoutPlugin().getReceiptPageCurrency();
    }

    public String getEnvironment() {
        return this.getMonerisCheckoutPlugin().getEnvironment();
    }

    public String getPaymentPageJSClient() {
        try {
            String url = this.getMonerisCheckoutPlugin().getPaymentPageJSClient().toString();
            return String.format("<script src=\"%s\"></script>", url);
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    public boolean isAccessibleByUser() {
        return this.getMonerisCheckoutPlugin().isAccessibleByUser(this.getPaperCutVisit().getUserName());
    }

    public List<Double> getAllowedAmounts() {
        GatewayConfig conf = GatewayConfig.getInstance();
        return conf.getDoubleList("moneris-checkout.allowed-amounts");
    }

    protected MonerisCheckoutPlugin getMonerisCheckoutPlugin() {
        return (MonerisCheckoutPlugin)this.getPluginManager().getPluginByClass(MonerisCheckoutPlugin.class);
    }

    protected PluginManager getPluginManager() {
        return PluginManager.getInstance();
    }

    private static GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public String getPageMessage() {
        return ExtnMonerisCheckout.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return ExtnMonerisCheckout.getGatewayConfig().getPageMessageAvailable();
    }

    public static enum PaymentStage {
        SELECT_AMOUNT,
        PROCESSING_PAYMENT,
        SHOW_RECEIPT;

    }
}

