/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.pages;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.BasePaymentGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.ThreeDSecureFormData;
import biz.papercut.pcng.ext.paymentgateway.pages.RealexRRRedirect;
import biz.papercut.pcng.ext.paymentgateway.pages.ThreeDSecurePaymentGatewayPage;
import biz.papercut.pcng.ext.paymentgateway.realex.RealexRRPlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;

public abstract class ExtnRealexRR
extends ThreeDSecurePaymentGatewayPage
implements PageRenderListener,
IExternalPage {
    private static final Log logger = LogFactory.getLog(ExtnRealexRR.class);
    public static final String PAGE_NAME = "ExtnRealexRR";

    @Override
    public boolean isAccessibleByUser() {
        return this.getRealexRRPlugin().isAccessibleByUser(this.getPaperCutVisit().getUserName());
    }

    @Override
    public BasePaymentGatewayPlugin getPlugin() {
        return this.getRealexRRPlugin();
    }

    @Override
    public String getPageTitle() {
        String title = this.getRealexRRPlugin().getPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    @Override
    public String getHeading() {
        return this.getRealexRRPlugin().getPageHeading();
    }

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(GatewayUtils.createAllowedAmountsModel("realex-rr.allowed-amounts", (BasePaperCutPage)this));
        }
        if (this.getFormData() == null) {
            this.setFormData(this.buildForm());
        }
        if (!this.getRequestCycle().isRewinding()) {
            String configError;
            if (!this.getRealexRRPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = this.getRealexRRPlugin().getIsConfigured()) != null) {
                this.addWarningMessage(configError);
                logger.error((Object)configError);
            }
        }
    }

    private ThreeDSecureFormData buildForm() {
        ThreeDSecureFormData formData = new ThreeDSecureFormData();
        formData.setEnabled(this.getRealexRRPlugin().getThreeDSecureEnabled());
        if (formData.isEnabled()) {
            String elements = this.getRealexRRPlugin().getThreeDSecureFormElements();
            if (elements != null) {
                formData.setFormElements(elements.split(","));
            }
            if (this.getRealexRRPlugin().getThreeDSecurePromptString() != null) {
                formData.setPromptString(this.getRealexRRPlugin().getThreeDSecurePromptString());
            }
        }
        return formData;
    }

    public void formSubmit(IRequestCycle cycle) {
        Double amount = this.getAmount();
        if (amount == null || amount <= 0.0) {
            this.addErrorMessage("Please select an amount to add");
            return;
        }
        ThreeDSecureFormData formData = this.getFormData();
        if (this.getRealexRRPlugin().getThreeDSecureEnabled()) {
            if (formData.getFormElements() == null) {
                this.addErrorMessage("Please configure the form fields for 3DS/SCA compliance.");
                return;
            }
            List<String> elements = formData.getFormElements();
            if (elements.contains("currency") && formData.getCurrency() == null) {
                formData.setCurrency("realex-rr.currency");
            }
        }
        RealexRRRedirect redirectPage = (RealexRRRedirect)cycle.getPage("RealexRRRedirect");
        redirectPage.activate(cycle, this.getUser(), amount, formData);
    }

    public void redirectToSummaryPage(IRequestCycle cycle) {
        cycle.activate("UserSummary");
    }

    public void activateExternalPage(Object[] arguments, IRequestCycle cycle) {
        HttpServletRequest r = this.getRequest();
        String success = r.getParameter("success");
        String message = r.getParameter("message");
        if (Boolean.parseBoolean(success)) {
            this.addStatusMessage(StringUtils.isBlank((String)message) ? "Funds have been added to your account" : message);
        } else {
            EventLog.getInstance().logEvent("Failure reason " + message + GatewayConfig.getInstance().getUserErrorMessage());
            this.addErrorMessage(StringUtils.isBlank((String)message) ? GatewayConfig.getInstance().getUserErrorMessage() : message);
        }
    }

    private RealexRRPlugin getRealexRRPlugin() {
        return (RealexRRPlugin)PluginManager.getInstance().getPluginByClass(RealexRRPlugin.class);
    }
}

